/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps;

import com.diquest.ir.client.command.CommandSearchRequest;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.protocol.query.Query;
import com.diquest.ir.common.msg.protocol.query.QueryParser;
import com.diquest.ir.common.msg.protocol.query.QuerySet;
import com.diquest.ir.common.msg.protocol.query.SelectSet;
import com.diquest.ir.common.msg.protocol.result.GroupResult;
import com.diquest.ir.common.msg.protocol.result.Result;
import com.diquest.ir.common.msg.protocol.result.ResultSet;
import com.diquest.ir.util.common.FileUtil;
import java.io.BufferedReader;
import java.io.IOException;

public class TestSearchCommander {
    private String ip;
    private int port;
    private String queryFile;
    private Query query;
    private QueryParser parser;
    private CommandSearchRequest command;
    public static StringBuffer help = new StringBuffer();

    static {
        help.append("TestSearchCommander : execute search and return result.\n");
        help.append("[IP] [Port] [Query file]\n");
        help.append("IP : Destination Server IP Address\n");
        help.append("Port : Destination Server search port\n");
        help.append("Query file : Filename contains Query String.(query for each line)\n");
    }

    public TestSearchCommander(String ip, int port, String queryFile) {
        this.ip = ip;
        this.port = port;
        this.queryFile = queryFile;
        this.parser = new QueryParser();
    }

    public void execute() throws IRException {
        System.out.println("\u25c6 IP : " + this.ip);
        System.out.println("\u25c6 Port : " + this.port + "\n");
        this.command = new CommandSearchRequest(this.ip, this.port);
        int lineNum = 0;
        try {
            String str;
            BufferedReader br = FileUtil.getBufferedReader((String)this.queryFile);
            while ((str = br.readLine()) != null) {
                ++lineNum;
                if (str.equals("")) continue;
                this.search(str, lineNum);
                str = "";
            }
            br.close();
        }
        catch (IRException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IRException(2, "An IOException is occurred during reading query file.");
        }
    }

    public void search(String queryStr, int lineNum) throws IRException {
        System.out.println("=================================================");
        System.out.println("\u25c6 Query(" + lineNum + " line) : " + queryStr);
        this.query = null;
        try {
            this.query = this.parser.parseQuery(queryStr);
        }
        catch (IRException e) {
            throw new IRException(2, "Incorrect query format.", (Throwable)e);
        }
        QuerySet querySet = new QuerySet(1);
        querySet.addQuery(this.query);
        Result result = null;
        long st = System.currentTimeMillis();
        int errorCode = this.command.request(querySet);
        System.out.println("ErrorCode = " + errorCode);
        if (errorCode < 0) {
            return;
        }
        ResultSet results = this.command.getResultSet();
        result = results.getResultList()[0];
        long et = System.currentTimeMillis();
        if (result != null) {
            GroupResult[] groupResults = result.getGroupResults();
            int i = 0;
            while (i < groupResults.length) {
                GroupResult groupResult = groupResults[i];
                char[][] ids = groupResult.getIds();
                int[] values = groupResult.getIntValues();
                int groupSize = values.length;
                if (groupSize > 0) {
                    int total = 0;
                    int j = 0;
                    while (j < groupSize) {
                        total += values[j];
                        ++j;
                    }
                    System.out.println("Group size : " + groupSize + " (Total Size : " + total + ")");
                    j = 0;
                    while (j < groupSize) {
                        System.out.println("\t[" + String.valueOf(ids[j]) + "] : " + values[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        SelectSet[] selectSets = this.query.getSelectFields();
        int totalSize = result.getTotalSize();
        System.out.println("Result size : " + totalSize + " Documents");
        if (totalSize > 0) {
            int realSize = result.getRealSize();
            int i = 0;
            while (i < realSize) {
                System.out.println("-------------------------------------------------");
                System.out.println("[No] : " + (this.query.getResultStart() + i));
                int j = 0;
                while (j < selectSets.length) {
                    System.out.println("[" + String.valueOf(selectSets[j].getField()) + "] : " + String.valueOf(result.getResult(i, j)));
                    ++j;
                }
                ++i;
            }
        } else {
            System.out.println("Empty Result");
        }
        System.out.println("\nSearch Time : " + (double)(et - st) / 1000.0 + " secs");
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Not enough arguments.");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = 0;
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            System.out.println("Illegal port number.");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String queryFile = args[2];
        try {
            System.out.println("start...");
            long st = System.currentTimeMillis();
            TestSearchCommander cmd = new TestSearchCommander(ip, port, queryFile);
            cmd.execute();
            long et = System.currentTimeMillis();
            System.out.println("=================================================");
            System.out.println("end...");
            System.out.println("Total Execute Time : " + (double)(et - st) / 1000.0 + " secs");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

