/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.profile.bannedword.BannedWord;
import com.diquest.ir.common.database.handler.dictionary.BannedWordDB;
import com.diquest.ir.common.msg.dictionary.BannedWordDictionary;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.sql.Connection;

public class BannedWordDicMaker {
    public static StringBuffer help = new StringBuffer();
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;
    private static final char KEY_DELIMITER = ',';
    public static final char SYSTEM = '1';
    public static final char USER_SYSTEM = '2';
    public static final char COLLECTION = '3';
    public static final String EMPTY = "*";

    static {
        help.append("BannedWordDicMaker : Import or export banned word dictionary.\n");
        help.append("[IP] [Port] [collectionID] [profileID] [type] [filename]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("CollectionID : Target collection ID\n");
        help.append("ProfileID : Target profile ID\n");
        help.append("type : 1, 2, 3, 4, 5, 6\n");
        help.append("\t1 - text file => BannedWord dictionary for user system.\n");
        help.append("\t2 - text file => BannedWord dictionary for one collection(profile).\n");
        help.append("\t3 - text file => BannedWord dictionary RDBMS table(PREFIX_BANNEDWORD) for user system.\n");
        help.append("\t4 - text file => BannedWord dictionary RDBMS table(PREFIX_BANNEDWORD) for one collection(profile).\n");
        help.append("\t5 - BannedWord dictionary RDBMS table(PREFIX_BANNEDWORD) for user system => text file\n");
        help.append("\t6 - BannedWord dictionary RDBMS table(PREFIX_BANNEDWORD) for one collection(profile) => text file\n");
        help.append("filename : BannedWord dictionary text file path.\n");
        help.append("(text file : banned word for each line.\n\n");
        help.append("<notice>\n");
        help.append("Type 1, 2, not execute this process but register task to server. Server must be alive.\n");
    }

    public BannedWordDicMaker(String ip, int port, String collection, String profile) {
        this.ip = ip;
        this.port = port;
        this.collection = StringUtil.isEmpty((String)collection) ? "" : collection;
        this.profile = StringUtil.isEmpty((String)profile) ? "" : profile;
    }

    public void transTxtToUserSystemDic(String file) {
        this.transTxtToDic(file, '2');
    }

    public void transTxtToCollectionDic(String file) {
        this.transTxtToDic(file, '3');
    }

    public void transTxtToUserSystemDB(String file) {
        this.transTxtToDB(file, '2');
    }

    public void transTxtToCollectionDB(String file) {
        this.transTxtToDB(file, '3');
    }

    public void transUserSystemDBToTxt(String file) {
        this.transDBToTxt(file, '2');
    }

    public void transDBToCollectionTxt(String file) {
        this.transDBToTxt(file, '3');
    }

    private void transTxtToDic(String file, char type) {
        block20: {
            BufferedReader in = null;
            try {
                try {
                    BannedWordDictionary dic = new BannedWordDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        if (!"".equals(line.trim())) {
                            dic.add(StringUtil.removeWhitespaces((String)line.toUpperCase()));
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(3);
                    switch (type) {
                        case '2': {
                            data.put("collectionID", (Transmitable)new StringT(""));
                            data.put("profileID", (Transmitable)new StringT(""));
                            data.put("dic", (Transmitable)dic);
                            break;
                        }
                        case '3': {
                            data.put("collectionID", (Transmitable)new StringT(this.collection));
                            data.put("profileID", (Transmitable)new StringT(this.profile));
                            data.put("dic", (Transmitable)dic);
                            break;
                        }
                    }
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.bannedword.ExtMessageBannedWordDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block20;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void transTxtToDB(String file, char type) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    if (!"".equals(line.trim())) {
                        String keyword = StringUtil.removeWhitespaces((String)line.toUpperCase());
                        switch (type) {
                            case '2': {
                                BannedWordDB.put((Connection)conn, (String)keyword);
                                break;
                            }
                            case '3': {
                                BannedWordDB.put((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword);
                                break;
                            }
                        }
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    private void transDBToTxt(String file, char type) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = new BufferedWriter(new FileWriter(file));
                int count = 0;
                BannedWord[] bannedWords = null;
                switch (type) {
                    case '2': {
                        bannedWords = BannedWordDB.getListSystem((Connection)conn, (String)"KEYWORD ASC");
                        break;
                    }
                    case '3': {
                        bannedWords = BannedWordDB.getList((Connection)conn, (String)this.collection, (String)this.profile, (String)"KEYWORD ASC");
                        break;
                    }
                }
                int size = bannedWords.length;
                int i = 0;
                while (i < size) {
                    out.write(String.valueOf(bannedWords[i].getKeyword()) + "\n");
                    ++count;
                    ++i;
                }
                out.flush();
                conn.commit();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            System.out.println("Not enough arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String profileID = args[3];
        if ("NULL".equalsIgnoreCase(collectionID) || EMPTY.equals(collectionID)) {
            collectionID = "";
        }
        if ("NULL".equalsIgnoreCase(profileID) || EMPTY.equals(profileID)) {
            profileID = "";
        }
        int cmdType = Integer.parseInt(args[4]);
        String fileName = args[5];
        if (1 > cmdType || cmdType > 6) {
            System.out.println("Illegal type : " + cmdType + "\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            BannedWordDicMaker cmd = new BannedWordDicMaker(ip, port, collectionID, profileID);
            switch (cmdType) {
                case 1: {
                    cmd.transTxtToUserSystemDic(fileName);
                    break;
                }
                case 2: {
                    cmd.transTxtToCollectionDic(fileName);
                    break;
                }
                case 3: {
                    cmd.transTxtToUserSystemDB(fileName);
                    break;
                }
                case 4: {
                    cmd.transTxtToCollectionDB(fileName);
                    break;
                }
                case 5: {
                    cmd.transUserSystemDBToTxt(fileName);
                    break;
                }
                case 6: {
                    cmd.transDBToCollectionTxt(fileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

