/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.profile.bannedword.BannedWord;
import com.diquest.ir.common.database.handler.dictionary.BannedWordDB;
import com.diquest.ir.common.msg.dictionary.BannedWordDictionary;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.sql.Connection;

public class BannedWordDicMaker_old {
    public static StringBuffer help = new StringBuffer();
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;

    static {
        help.append("BannedWordDicMaker : Import or export banned word dictionary.\n");
        help.append("[IP] [Port] [collectionID] [profileID] [type] [filename]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("CollectionID : Target collection ID\n");
        help.append("ProfileID : Target profile ID\n");
        help.append("type : 1, 2, 3, 4, 5, 6\n");
        help.append("\t1 - text file => BannedWord dictionary for all collections.\n");
        help.append("\t2 - text file => BannedWord dictionary for one collection(profile).\n");
        help.append("\t3 - text file => BannedWord dictionary RDBMS table(PREFIX_BANNEDWORD) for one collection(profile).\n");
        help.append("\t4 - BannedWord dictionary RDBMS table(PREFIX_BANNEDWORD) for one collection(profile) => text file\n");
        help.append("\t5 - text file => BannedWord dictionary RDBMS table(PREFIX_BANNEDWORD) for all collections\n");
        help.append("\t6 - BannedWord dictionary RDBMS table(PREFIX_BANNEDWORD) for all collections => text file\n");
        help.append("filename : BannedWord dictionary text file path.\n");
        help.append("(text file : banned word for each line.\n\n");
        help.append("<notice>\n");
        help.append("Type 1, 2, not execute this process but register task to server. Server must be alive.\n");
    }

    public BannedWordDicMaker_old(String ip, int port, String collection, String profile) {
        this.ip = ip;
        this.port = port;
        if (StringUtil.isEmpty((String)collection)) {
            collection = "";
        }
        if (StringUtil.isEmpty((String)profile)) {
            profile = "";
        }
        this.collection = collection;
        this.profile = profile;
    }

    public void transTxtToSystemDic(String file) {
        block16: {
            BufferedReader in = null;
            try {
                try {
                    BannedWordDictionary dic = new BannedWordDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        if (!"".equals(line.trim())) {
                            dic.add(line.trim().toUpperCase());
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(3);
                    data.put("collectionID", (Transmitable)new StringT(""));
                    data.put("profileID", (Transmitable)new StringT(""));
                    data.put("dic", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.bannedword.ExtMessageBannedWordDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block16;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDic(String file) {
        block16: {
            BufferedReader in = null;
            try {
                try {
                    BannedWordDictionary dic = new BannedWordDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        if (!"".equals(line.trim())) {
                            dic.add(line.trim().toUpperCase());
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(3);
                    data.put("collectionID", (Transmitable)new StringT(this.collection));
                    data.put("profileID", (Transmitable)new StringT(this.profile));
                    data.put("dic", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.bannedword.ExtMessageBannedWordDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block16;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    if (!"".equals(line.trim())) {
                        String keyword = line.trim().toUpperCase();
                        BannedWordDB.put((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword);
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = new BufferedWriter(new FileWriter(file));
                int count = 0;
                BannedWord[] bannedWords = BannedWordDB.getList((Connection)conn, (String)this.collection, (String)this.profile, (String)"KEYWORD ASC");
                int size = bannedWords.length;
                int i = 0;
                while (i < size) {
                    out.write(String.valueOf(bannedWords[i].getKeyword()) + "\n");
                    ++count;
                    ++i;
                }
                out.flush();
                conn.commit();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transTxtToSystemDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    if (!"".equals(line.trim())) {
                        String keyword = line.trim().toUpperCase();
                        BannedWordDB.put((Connection)conn, (String)keyword);
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transSystemDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = new BufferedWriter(new FileWriter(file));
                int count = 0;
                BannedWord[] bannedWords = BannedWordDB.getListSystem((Connection)conn, (String)"KEYWORD ASC");
                int size = bannedWords.length;
                int i = 0;
                while (i < size) {
                    out.write(String.valueOf(bannedWords[i].getKeyword()) + "\n");
                    ++count;
                    ++i;
                }
                out.flush();
                conn.commit();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            System.out.println("Not enough arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String profileID = args[3];
        if (profileID.equalsIgnoreCase("NULL")) {
            profileID = "";
        }
        int cmdType = Integer.parseInt(args[4]);
        String fileName = args[5];
        if (1 > cmdType || cmdType > 6) {
            System.out.println("Illegal type : " + cmdType + "\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            BannedWordDicMaker_old cmd = new BannedWordDicMaker_old(ip, port, collectionID, profileID);
            switch (cmdType) {
                case 1: {
                    cmd.transTxtToSystemDic(fileName);
                    break;
                }
                case 2: {
                    cmd.transTxtToDic(fileName);
                    break;
                }
                case 3: {
                    cmd.transTxtToDB(fileName);
                    break;
                }
                case 4: {
                    cmd.transDBToTxt(fileName);
                    break;
                }
                case 5: {
                    cmd.transTxtToSystemDB(fileName);
                    break;
                }
                case 6: {
                    cmd.transSystemDBToTxt(fileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

