/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.common.database.entity.profile.categoryranking.CategoryRanking;
import com.diquest.ir.common.database.entity.profile.categoryranking.CategoryRankingKeyword;
import com.diquest.ir.common.database.handler.dictionary.CategoryRankingDB;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.common.StringTokenizer;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CategoryRankingDicMaker {
    public static StringBuffer help = new StringBuffer();
    private final String ip;
    private final int port;
    private final String collection;
    private String profile;
    private final String field;
    private final int type;
    private final int rank;
    private static final char SYSTEM = 'S';
    private static final char USER = 'U';
    static /* synthetic */ Class class$0;

    static {
        help.append("========================================================================\n");
        help.append("CategoryRankingDicMaker : Import or export category ranking dictionary.\n");
        help.append("[IP] [Port] [Collection] [Profile] [Type] [Filename] [Field] [RankType] [Rank]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("Collection : Collection name to apply category ranking dictionary\n");
        help.append("Profile : Profile name to apply category ranking dictionary\n");
        help.append("\n");
        help.append("Type : 1, 2, 3\n");
        help.append("\n");
        help.append("\t1 - Binary dictionary file (Diver4) => Category Ranking RDBMS table ($PREFIX_CATEGORY_RANKING, $PREFIX_CATEGORY_RANKING_KEYWORD)\n");
        help.append("\t2 - text file => Category Ranking RDBMS table ($PREFIX_CATEGORY_RANKING, $PREFIX_CATEGORY_RANKING_KEYWORD)\n");
        help.append("\t3 - remove system entry from Category Ranking RDBMS table ($PREFIX_CATEGORY_RANKING, $PREFIX_CATEGORY_RANKING_KEYWORD)\n");
        help.append("\t4 - remove user entry from Category Ranking RDBMS table ($PREFIX_CATEGORY_RANKING, $PREFIX_CATEGORY_RANKING_KEYWORD)\n");
        help.append("\n");
        help.append("Filename : text user dictionary file path / binary dictionary file\n");
        help.append("(text file : keyword category|category|category... per each line)\n");
        help.append("\n");
        help.append("Field : Name of Category Field\n");
        help.append("\n");
        help.append("RankType : 1,2,3\n");
        help.append("\t1 - Absolute Rank \n");
        help.append("\t2 - Weighted Rank\n");
        help.append("\t3 - Remove\n");
        help.append("\n");
        help.append("Rank : Integer, rank number when RankType=1, weight when RankType=2\n");
        help.append("========================================================================\n");
    }

    public CategoryRankingDicMaker(String ip, int port, String collection, String profile, String field, int type, int rank) {
        this.ip = ip;
        this.port = port;
        this.collection = collection;
        this.profile = profile;
        this.field = field;
        this.type = type;
        this.rank = rank;
    }

    /*
     * Exception decompiling
     */
    public void dicToDB(String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void txtToDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        int totalKeyword = 0;
        int totalCategory = 0;
        if (this.profile.equalsIgnoreCase("NULL")) {
            this.profile = "";
        }
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                boolean count = false;
                while (line != null && line.length() > 0) {
                    char[][] tokens = StringTokenizer.token((String)line.trim(), (char)'\t');
                    String[] categoryString = new String[tokens.length];
                    int i = 0;
                    while (i < tokens.length) {
                        categoryString[i] = new String(tokens[i]);
                        ++i;
                    }
                    String keyword = categoryString[0];
                    List categoryList = null;
                    if (categoryString.length < 2) {
                        System.out.println("Invalid Line : Keyword = " + keyword);
                    } else {
                        categoryList = this.makeCategoryList(categoryString[1], '|');
                    }
                    int categories = 0;
                    if (categoryList != null && categoryList.size() > 0) {
                        Iterator i2 = categoryList.iterator();
                        while (i2.hasNext()) {
                            String categoryName = (String)i2.next();
                            CategoryRanking category = new CategoryRanking(this.collection, this.profile, keyword, this.field, categoryName, (byte)this.type, this.rank, 0L, 0L, 0L, false, true, 'S');
                            try {
                                CategoryRankingDB.putCategory((Connection)conn, (CategoryRanking)category);
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            CategoryRankingKeyword categoryRankingKeyword = CategoryRankingDB.getKeyword((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword);
                            categories = CategoryRankingDB.getCountCategory((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword);
                            if (categoryRankingKeyword == null) {
                                CategoryRankingDB.putKeyword((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword, (int)categories);
                            } else {
                                CategoryRankingDB.updateKeyword((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword, (int)categories);
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        ++totalKeyword;
                        totalCategory += categories;
                    }
                    line = in.readLine();
                }
                System.out.println("Keywords : " + totalKeyword + " , Categories : " + totalCategory + " inserted...");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void removeEntry(char creator) {
        System.out.println("Remove Entry from DB...");
        System.out.println("Collection : " + this.collection);
        System.out.println("Profile : " + this.profile);
        System.out.println("Creator : " + creator);
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                CategoryRankingDB.deleteProfileCategory((Connection)conn, (String)this.collection, (String)this.profile, (char)creator);
                CategoryRankingKeyword[] categoryRankingKeywords = CategoryRankingDB.getListKeyword((Connection)conn, (String)this.collection, (String)this.profile, null);
                int i = 0;
                while (i < categoryRankingKeywords.length) {
                    String keyword = categoryRankingKeywords[i].getKeyword();
                    int categoryCount = CategoryRankingDB.getCountCategory((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword);
                    if (categoryCount == 0) {
                        CategoryRankingDB.deleteCategoryKeywordByKeyword((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword);
                    } else {
                        CategoryRankingDB.updateKeyword((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword, (int)categoryCount);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private List makeCategoryList(String categoryList, char delim) {
        if (categoryList == null || categoryList.equals("")) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        char[] arr = categoryList.toCharArray();
        int prevPos = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == delim) {
                list.add(new String(arr, prevPos, i - prevPos));
                prevPos = i + 1;
            }
            ++i;
        }
        list.add(new String(arr, prevPos, arr.length - prevPos));
        return list;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 9) {
            System.out.println("Not enough argument.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String profileID = args[3];
        if ("NULL".equalsIgnoreCase(collectionID) || "*".equals(collectionID)) {
            collectionID = "";
        }
        if ("NULL".equalsIgnoreCase(profileID) || "*".equals(profileID)) {
            profileID = "";
        }
        int cmdType = Integer.parseInt(args[4]);
        String fileName = args[5];
        String field = args[6];
        int type = Integer.parseInt(args[7]);
        int rank = Integer.parseInt(args[8]);
        if (1 > cmdType || cmdType > 4) {
            System.out.println("Illegal type : " + cmdType + "\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            CategoryRankingDicMaker dicMaker = new CategoryRankingDicMaker(ip, port, collectionID, profileID, field, type, rank);
            switch (cmdType) {
                case 1: {
                    dicMaker.dicToDB(fileName);
                    break;
                }
                case 2: {
                    dicMaker.txtToDB(fileName);
                    break;
                }
                case 3: {
                    dicMaker.removeEntry('S');
                    break;
                }
                case 4: {
                    dicMaker.removeEntry('U');
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

