/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.common.database.handler.dictionary.CategoryRankingDB;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public class CategoryRankingDicRemover {
    public static StringBuffer help = new StringBuffer();
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;

    static {
        help.append("========================================================================\n");
        help.append("CategoryRankingDicMaker : Import or export category ranking dictionary.\n");
        help.append("[IP] [Port] [Collection] [Profile] \n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("Collection : Collection name to apply category ranking dictionary\n");
        help.append("Profile : Profile name to apply category ranking dictionary\n");
        help.append("========================================================================\n");
    }

    public CategoryRankingDicRemover(String ip, int port, String collection, String profile) {
        this.ip = ip;
        this.port = port;
        this.collection = collection;
        this.profile = profile;
    }

    public void remove() {
        block20: {
            BufferedReader in = null;
            Connection conn = null;
            try {
                try {
                    conn = ConnectionFactory.getConnection();
                    conn.setAutoCommit(false);
                    if (this.collection.equals("")) {
                        CategoryRankingDB.deleteAll((Connection)conn);
                        break block20;
                    }
                    if (this.profile.equals("")) {
                        CategoryRankingDB.deleteCollection((Connection)conn, (String)this.collection);
                        break block20;
                    }
                    CategoryRankingDB.deleteProfile((Connection)conn, (String)this.collection, (String)this.profile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private List makeCategoryList(String categoryList, char delim) {
        if (categoryList == null || categoryList.equals("")) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        char[] arr = categoryList.toCharArray();
        int prevPos = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == delim) {
                list.add(new String(arr, prevPos, i - prevPos));
                prevPos = i + 1;
            }
            ++i;
        }
        list.add(new String(arr, prevPos, arr.length - prevPos));
        return list;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Not enough argument.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String profileID = args[3];
        if ("NULL".equalsIgnoreCase(collectionID) || "*".equals(collectionID)) {
            collectionID = "";
        }
        if ("NULL".equalsIgnoreCase(profileID) || "*".equals(profileID)) {
            profileID = "";
        }
        System.out.println("start...");
        try {
            CategoryRankingDicRemover dicRemover = new CategoryRankingDicRemover(ip, port, collectionID, profileID);
            dicRemover.remove();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

