/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.client.command.dictionary.CommandBannedWord;
import com.diquest.ir.client.command.dictionary.CommandCategoryRanking;
import com.diquest.ir.client.command.dictionary.CommandDocumentRanking;
import com.diquest.ir.client.command.dictionary.CommandFeedbackWord;
import com.diquest.ir.client.command.dictionary.CommandRecommend;
import com.diquest.ir.client.command.dictionary.CommandRedirect;
import com.diquest.ir.client.command.dictionary.CommandStopword;
import com.diquest.ir.client.command.dictionary.CommandThesaurus;
import com.diquest.ir.client.command.dictionary.CommandUserDic;
import com.diquest.ir.common.exception.IRException;

public class DictionaryCommandApp {
    private static final String userName = "console command";

    public static void main(String[] args) throws IRException {
        StringBuffer helpStringBuf = new StringBuffer();
        helpStringBuf.append("arguments : $IP $PORT $COMMAND $COLLECTION(optional) $PROFILE(optional)\n");
        helpStringBuf.append("$IP : AdminServer IP Address\n");
        helpStringBuf.append("$PORT : AdminServer port\n");
        helpStringBuf.append("$COMMAND : (ignors case) BANNEDWORD, CATEGORYRANKING, DOCUMENTRANKING, RECOMMEND, REDIRECT, STOPWORD, EQUIV_SYNONYM, QUASI_SYNONYM, USERDIC, FEEDBACKWORD\n");
        helpStringBuf.append("$COLLECTION : Destination collectionID. if null, destionation is System Dictionary\n");
        helpStringBuf.append("$PROFILE : Destination profileID. if null, destionation is System Dictionary\n");
        if (args.length < 3) {
            System.out.println(helpStringBuf.toString());
            System.exit(-args.length);
        }
        String IP = null;
        int PORT = 0;
        String commandType = null;
        String collectionID = null;
        String profileID = null;
        IP = args[0];
        PORT = Integer.parseInt(args[1]);
        commandType = args[2];
        if (args.length > 3) {
            collectionID = args[3];
        }
        if (args.length > 4) {
            profileID = args[4];
        }
        boolean result = false;
        if (commandType.equalsIgnoreCase("BANNEDWORD")) {
            CommandBannedWord command = new CommandBannedWord(new AdminServerClient(IP, PORT), userName);
            result = command.apply(collectionID, profileID);
        } else if (commandType.equalsIgnoreCase("CATEGORYRANKING")) {
            CommandCategoryRanking command = new CommandCategoryRanking(new AdminServerClient(IP, PORT), userName);
            result = command.apply(collectionID, profileID);
        } else if (commandType.equalsIgnoreCase("DOCUMENTRANKING")) {
            CommandDocumentRanking command = new CommandDocumentRanking(new AdminServerClient(IP, PORT), userName);
            result = command.apply(collectionID, profileID);
        } else if (commandType.equalsIgnoreCase("RECOMMEND")) {
            CommandRecommend command = new CommandRecommend(new AdminServerClient(IP, PORT), userName);
            result = command.apply(collectionID, profileID);
        } else if (commandType.equalsIgnoreCase("REDIRECT")) {
            CommandRedirect command = new CommandRedirect(new AdminServerClient(IP, PORT), userName);
            result = command.apply(collectionID, profileID);
        } else if (commandType.equalsIgnoreCase("STOPWORD")) {
            CommandStopword command = new CommandStopword(new AdminServerClient(IP, PORT), userName);
            result = command.apply(collectionID, profileID);
        } else if (commandType.equalsIgnoreCase("EQUIV_SYNONYM")) {
            CommandThesaurus command = new CommandThesaurus(new AdminServerClient(IP, PORT), userName, 1);
            result = command.apply(collectionID, profileID);
        } else if (commandType.equalsIgnoreCase("QUASI_SYNONYM")) {
            CommandThesaurus command = new CommandThesaurus(new AdminServerClient(IP, PORT), userName, 4);
            result = command.apply(collectionID, profileID);
        } else if (commandType.equalsIgnoreCase("USERDIC")) {
            CommandUserDic command = new CommandUserDic(new AdminServerClient(IP, PORT), userName);
            result = command.apply();
        } else if (commandType.equalsIgnoreCase("FEEDBACKWORD")) {
            CommandFeedbackWord command = new CommandFeedbackWord(new AdminServerClient(IP, PORT), userName);
            result = command.apply(collectionID, profileID);
        } else {
            System.out.println("Illegal command : " + commandType);
            System.out.println(helpStringBuf.toString());
            System.exit(-1);
        }
        System.out.println("command register " + (result ? "success." : "failed."));
    }
}

