/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.client.command.dictionary.CommandDocumentRanking;
import com.diquest.ir.common.exception.IRException;

public class DocumentRankingDicApplier {
    public static StringBuffer help = new StringBuffer();
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;

    static {
        help.append("========================================================================\n");
        help.append("DocumentRankingDicApplier : Apply document ranking dictionary from RDBMS.\n");
        help.append("[IP] [Port] [Collection] [Profile] \n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("Collection : Collection name to apply document ranking dictionary\n");
        help.append("Profile : Profile name to apply document ranking dictionary\n");
        help.append("========================================================================\n");
    }

    public DocumentRankingDicApplier(String ip, int port, String collection, String profile) {
        this.ip = ip;
        this.port = port;
        this.collection = collection;
        this.profile = profile;
    }

    public void apply() throws IRException {
        System.out.println("Apply DocumentRanking Dictionary from RDBMS.");
        System.out.println("adminServer IP : " + this.ip + " , PORT : " + this.port);
        CommandDocumentRanking command = new CommandDocumentRanking(new AdminServerClient(this.ip, this.port), "");
        System.out.println("collection=" + this.collection + " , profile=" + this.profile);
        command.apply(this.collection, this.profile);
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Not Enough Arguments.");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collection = args[2];
        String profile = args[3];
        if ("NULL".equalsIgnoreCase(collection) || "*".equals(collection)) {
            collection = "";
        }
        if ("NULL".equalsIgnoreCase(profile) || "*".equals(profile)) {
            profile = "";
        }
        DocumentRankingDicApplier documentRankingDicApplier = new DocumentRankingDicApplier(ip, port, collection, profile);
        System.out.println("Start..");
        try {
            try {
                documentRankingDicApplier.apply();
            }
            catch (IRException e) {
                e.printStackTrace();
                System.out.println("End...");
            }
        }
        finally {
            System.out.println("End...");
        }
    }
}

