/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.profile.documentranking.DocumentRanking;
import com.diquest.ir.common.database.entity.profile.documentranking.DocumentRankingKeyword;
import com.diquest.ir.common.database.handler.dictionary.DocumentRankingDB;
import com.diquest.ir.common.msg.dictionary.DocumentRankingDictionary;
import com.diquest.ir.common.msg.dictionary.DocumentRankingElement;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DocumentRankingDicMaker {
    public static StringBuffer help = new StringBuffer();
    private static final char DELIMETER_FILE = ',';
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;

    static {
        help.append("DocumentRankingDicMaker : Import or export document ranking dictionary.\n");
        help.append("[IP] [PORT] [COLLECTIONNAME] [PROFILE] [EXECUTETYPE] [FILE]\n");
        help.append("IP\t\t\t\t: Destination server IP address.\n");
        help.append("Port\t\t\t: Destination server port.\n");
        help.append("CollectionID\t: Target collection ID.\n");
        help.append("ProfileID\t\t: Target profile ID.\n");
        help.append("ExecuteType\t: 1, 2, 3\n");
        help.append("\t ExecuteType 1 does not execute this process but register task to server. Server must be alive.\n");
        help.append("\t text file -> Collection(profile) DocumentRanking dictionary.\n");
        help.append("\t text file -> RDBMS ($PREFIX_DOCUMENT_RANKING, $PREFIX_DOCUMENT_RANKING_KEYWORD table)\n");
        help.append("\t RDBMS -> text file ($PREFIX_DOCUMENT_RANKING, $PREFIX_DOCUMENT_RANKING_KEYWORD table)\n");
        help.append("File\t\t\t: Document ranking text file path. (1, 2 : inputfile / 3 : outputfile)\n");
        help.append("\t ex) %IR_HOME%\\script\\documentRanking.collectionName.profileName.MS949\n");
    }

    public DocumentRankingDicMaker(String ip, int port, String collection, String profile) {
        this.ip = ip;
        this.port = port;
        this.collection = collection;
        this.profile = profile;
    }

    public void transTxtToCollectionDic(String inputfile) {
        block20: {
            BufferedReader br = null;
            try {
                try {
                    DocumentRankingDictionary dic = new DocumentRankingDictionary(16384);
                    br = FileUtil.getBufferedReader((String)inputfile);
                    int totalDocumentRanking = 0;
                    HashMap<String, String> countKeywords = new HashMap<String, String>();
                    ArrayList<String> list = new ArrayList<String>();
                    String line = null;
                    String prevKeyword = null;
                    while ((line = br.readLine()) != null && line.length() > 0) {
                        String[] tokens = DocumentRankingDB.makeDocumentRankingList((String)line);
                        if (tokens.length == 6) {
                            list.add(line);
                            if (prevKeyword == null) {
                                countKeywords.put(tokens[0], "1");
                                prevKeyword = tokens[0];
                            } else if (countKeywords.containsKey(tokens[0])) {
                                countKeywords.put(tokens[0], String.valueOf(Integer.parseInt((String)countKeywords.get(tokens[0])) + 1));
                                prevKeyword = tokens[0];
                            } else {
                                DocumentRankingElement dre = this.makeDocumentRankingElement(prevKeyword, list, Integer.parseInt((String)countKeywords.get(prevKeyword)));
                                dic.add(dre);
                                list.clear();
                                list.add(line);
                                countKeywords.clear();
                                countKeywords.put(tokens[0], "1");
                                prevKeyword = tokens[0];
                            }
                            ++totalDocumentRanking;
                            continue;
                        }
                        System.out.println("Keyword List is too " + (tokens.length < 6 ? "short" : "long") + ", Keyword : " + tokens[0]);
                    }
                    br.close();
                    DocumentRankingElement dre = this.makeDocumentRankingElement(prevKeyword, list, Integer.parseInt((String)countKeywords.get(prevKeyword)));
                    dic.add(dre);
                    DataT data = new DataT(3);
                    data.put("collectionID", (Transmitable)new StringT(this.collection));
                    data.put("profileID", (Transmitable)new StringT(this.profile));
                    data.put("dictionary", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.documentranking.ExtMessageDocumentRankingDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + totalDocumentRanking + " is imported.");
                        break block20;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDB(String inputfile) {
        BufferedReader br = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                if (StringUtil.isEmpty((String)this.profile)) {
                    DocumentRankingDB.deleteProfile((Connection)conn, (String)this.collection, (String)this.profile);
                }
                br = FileUtil.getBufferedReader((String)inputfile);
                HashMap<String, String> countKeywords = new HashMap<String, String>();
                int totalDocumentRanking = 0;
                String line = null;
                while ((line = br.readLine()) != null && line.length() > 0) {
                    String[] tokens = DocumentRankingDB.makeDocumentRankingList((String)line);
                    if (tokens.length == 6) {
                        String keyword = tokens[0];
                        String docID = tokens[1];
                        int type = Integer.parseInt(tokens[2]);
                        int rank = Integer.parseInt(tokens[3]);
                        long start = Long.parseLong(tokens[4]);
                        long end = Long.parseLong(tokens[5]);
                        DocumentRankingDB.putDocument((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword, (String)docID, (byte)((byte)type), (int)rank, (long)start, (long)end);
                        countKeywords.put(tokens[0], countKeywords.containsKey(tokens[0]) ? String.valueOf(Integer.parseInt((String)countKeywords.get(tokens[0])) + 1) : "1");
                        ++totalDocumentRanking;
                        continue;
                    }
                    System.out.println("Keyword List is too " + (tokens.length < 6 ? "short" : "long") + ", Keyword : " + tokens[0]);
                }
                Iterator iter = countKeywords.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    DocumentRankingDB.putKeyword((Connection)conn, (String)this.collection, (String)this.profile, (String)key, (int)Integer.parseInt((String)countKeywords.get(key)));
                }
                System.out.println("Keywords : " + countKeywords.size() + ", DocumentRankings : " + totalDocumentRanking + " inserted...");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transDBToTxt(String outputfile) {
        BufferedWriter bw = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                bw = FileUtil.getBufferedWriter((String)outputfile);
                int totalDocumentRanking = 0;
                DocumentRankingKeyword[] documentRankingKeywordList = DocumentRankingDB.getListKeyword((Connection)conn, (String)this.collection, (String)this.profile, (String)"KEYWORD ASC");
                int i = 0;
                while (i < documentRankingKeywordList.length) {
                    DocumentRanking[] dr = DocumentRankingDB.getListDocument((Connection)conn, (String)this.collection, (String)this.profile, (String)documentRankingKeywordList[i].getKeyword(), (String)"KEYWORD ASC");
                    int j = 0;
                    while (j < dr.length) {
                        bw.write(String.valueOf(dr[j].getKeyword()) + ',' + dr[j].getDocID() + ',' + dr[j].getType() + ',' + dr[j].getRank() + ',' + dr[j].getStart() + ',' + dr[j].getEnd());
                        bw.newLine();
                        ++totalDocumentRanking;
                        ++j;
                    }
                    ++i;
                }
                bw.flush();
                System.out.println("Success : Keyword " + documentRankingKeywordList.length + " and DocumentRankings " + totalDocumentRanking + " is exported.");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private List makeList(String sequence) {
        ArrayList<String> list = new ArrayList<String>();
        char[] arr = sequence.toCharArray();
        int prevPos = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == ',') {
                list.add(StringUtil.removeWhitespaces((String)new String(arr, prevPos, i - prevPos).toUpperCase()));
                prevPos = i + 1;
            }
            ++i;
        }
        list.add(StringUtil.removeWhitespaces((String)new String(arr, prevPos, arr.length - prevPos).toUpperCase()));
        return list;
    }

    private DocumentRankingElement makeDocumentRankingElement(String prevKeyword, List list, int length) {
        String keyword = prevKeyword;
        String[] docIDs = new String[length];
        byte[] type = new byte[length];
        int[] rank = new int[length];
        long[] start = new long[length];
        long[] end = new long[length];
        int i = 0;
        while (i < length) {
            String[] prevToken = DocumentRankingDB.makeDocumentRankingList((String)list.get(i).toString());
            docIDs[i] = prevToken[1];
            type[i] = (byte)Integer.parseInt(prevToken[2]);
            rank[i] = Integer.parseInt(prevToken[3]);
            start[i] = Long.parseLong(prevToken[4]);
            end[i] = Long.parseLong(prevToken[5]);
            ++i;
        }
        DocumentRankingElement dre = new DocumentRankingElement(keyword, docIDs, type, rank, start, end);
        return dre;
    }

    public static void main(String[] args) {
        String profileName;
        if (args.length < 5) {
            System.out.println("Not enought arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionName = args[2];
        if ("NULL".equalsIgnoreCase(collectionName) || "*".equals(collectionName)) {
            System.out.println("Collection name is null or '*'.");
            System.exit(1);
        }
        if ("NULL".equalsIgnoreCase(profileName = args[3]) || "*".equals(profileName)) {
            profileName = "";
        }
        int executeType = Integer.parseInt(args[4]);
        String file = args[5];
        System.out.println("start...");
        try {
            DocumentRankingDicMaker cmd = new DocumentRankingDicMaker(ip, port, collectionName, profileName);
            switch (executeType) {
                case 1: {
                    cmd.transTxtToCollectionDic(file);
                    break;
                }
                case 2: {
                    cmd.transTxtToDB(file);
                    break;
                }
                case 3: {
                    cmd.transDBToTxt(file);
                    break;
                }
                default: {
                    System.out.println(help.toString());
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

