/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.profile.keywordprofile.KeywordProfile;
import com.diquest.ir.common.database.handler.dictionary.KeywordProfileDB;
import com.diquest.ir.common.msg.dictionary.KeywordProfileDictionary;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public class KeywordProfileDicMaker {
    public static StringBuffer help;
    public static final String NEW_LINE = "\n";
    public static final char KEY_DELIMITER = ',';
    public static int KEYWORDPROFILE_ELEMENT_SIZE;
    public static final char COLLECTION = '1';
    private final String ip;
    private final int port;
    private final String collection;

    static {
        KEYWORDPROFILE_ELEMENT_SIZE = 2;
        help = new StringBuffer();
        help.append("KeywordProfileDicMaker : Import or export Keyword-Profile Dictionary\n");
        help.append("[IP] [Port] [collectionID] [type] [filename]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("CollectionID : Target collection ID\n");
        help.append("\t1 - text file => Keyword-Profile dictionary for one collection.\n");
        help.append("\t2 - text file => Keyword-Profile dictionary RDBMS table(PREFIX_KEYWORDPROFILE) for one collection.\n");
        help.append("\t3 - Keyword-Profile dictionary RDBMS table(PREFIX_KEYWORDPROFILE) for one collection => text file\n");
        help.append("\t4 - Remove Keyword-Profile dictionary RDBMS table(PREFIX_KEYWORDPROFILE) for one collection\n");
        help.append("filename : Keyword-Profile dictionary text file path.\n");
        help.append("(text file : Keyword-Profile for each line. ex) keyword,profile1\n\n");
        help.append("<notice>\n");
        help.append("Type 1, 2, not execute this process but register task to server. Server must be alive.\n");
    }

    public KeywordProfileDicMaker(String ip, int port, String collection) {
        this.ip = ip;
        this.port = port;
        this.collection = StringUtil.isEmpty((String)collection) ? "" : collection;
    }

    public void transTxtToCollectionDic(String file) {
        this.transTxtToDic(file);
    }

    public void transTxtToCollectionDB(String file) {
        this.transTxtToDB(file);
    }

    public void transCollectionDBToTxt(String file) {
        this.transDBToTxt(file);
    }

    public void transTxtToDic(String file) {
        block19: {
            BufferedReader in = null;
            try {
                try {
                    KeywordProfileDictionary dic = new KeywordProfileDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        List list = this.makeList(line);
                        if (list.size() >= KEYWORDPROFILE_ELEMENT_SIZE) {
                            String keyword = (String)list.get(0);
                            String profileName = (String)list.get(1);
                            dic.add(keyword, profileName);
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(2);
                    data.put("collectionID", (Transmitable)new StringT(this.collection));
                    data.put("dictionary", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.keywordprofile.ExtMessageKeywordProfileDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block19;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    List list = this.makeList(line);
                    if (list.size() >= KEYWORDPROFILE_ELEMENT_SIZE) {
                        String keyword = (String)list.get(0);
                        String profileID = (String)list.get(1);
                        try {
                            KeywordProfileDB.put((Connection)conn, (String)this.collection, (String)keyword, (String)profileID);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = FileUtil.getBufferedWriter((String)file);
                int count = 0;
                KeywordProfile[] keywordProfiles = null;
                keywordProfiles = KeywordProfileDB.getList((Connection)conn, (String)this.collection, (String)"KEYWORD ASC");
                int i = 0;
                while (i < keywordProfiles.length) {
                    KeywordProfile keywordProfile = keywordProfiles[i];
                    String keyword = keywordProfile.getKeyword().replace(',', ' ');
                    String profileName = keywordProfile.getProfileName();
                    out.write(String.valueOf(keyword) + ',' + profileName + NEW_LINE);
                    ++count;
                    ++i;
                }
                out.flush();
                out.close();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void removeEntry() {
        System.out.println("Remove Entry from DB...");
        System.out.println("Collection : " + this.collection);
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                KeywordProfileDB.deleteCollection((Connection)conn, (String)this.collection);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private List makeList(String sequence) {
        ArrayList<String> list = new ArrayList<String>();
        char[] arr = sequence.toCharArray();
        int prevPos = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == ',') {
                list.add(new String(arr, prevPos, i - prevPos).trim());
                prevPos = i + 1;
            }
            ++i;
        }
        list.add(new String(arr, prevPos, arr.length - prevPos).trim());
        return list;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 5) {
            System.out.println("Not enough arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        if ("NULL".equalsIgnoreCase(collectionID) || "*".equals(collectionID)) {
            collectionID = "";
        }
        int cmdType = Integer.parseInt(args[3]);
        String fileName = args[4];
        if (1 > cmdType || cmdType > 4) {
            System.out.println("Illegal type :" + cmdType + NEW_LINE);
            System.out.println(help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            KeywordProfileDicMaker cmd = new KeywordProfileDicMaker(ip, port, collectionID);
            switch (cmdType) {
                case 1: {
                    cmd.transTxtToCollectionDic(fileName);
                    break;
                }
                case 2: {
                    cmd.transTxtToCollectionDB(fileName);
                    break;
                }
                case 3: {
                    cmd.transCollectionDBToTxt(fileName);
                    break;
                }
                case 4: {
                    cmd.removeEntry();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

