/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.profile.recommend.Recommend;
import com.diquest.ir.common.database.handler.dictionary.RecommendDB;
import com.diquest.ir.common.msg.dictionary.RecommendDictionary;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class RecommendDicMaker {
    public static StringBuffer help = new StringBuffer();
    private static final char KEY_DELIMITER = ',';
    private static final char DELIMETER_DIC = '\t';
    public static final char SYSTEM = '1';
    public static final char USER_SYSTEM = '2';
    public static final char COLLECTION = '3';
    public static final char SINGLE_WAY = '1';
    public static final char MULTI_WAY = '2';
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;

    static {
        help.append("RecommendDicMaker : Import or export recommend dictionary.\n");
        help.append("[IP] [Port] [collectionID] [profileID] [type] [filename]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("CollectionID : Target collection ID\n");
        help.append("ProfileID : Target profile ID\n");
        help.append("type : 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12\n");
        help.append("\t1 - text file => Recommend dictionary for system. single-way(first keyword to the others.)\n");
        help.append("\t2 - text file => Recommend dictionary for system. multi-way(each keyword to the others.)\n\n");
        help.append("\t3 - text file => Recommend dictionary for user system. single-way(first keyword to the others.)\n");
        help.append("\t4 - text file => Recommend dictionary for user system. multi-way(each keyword to the others.)\n\n");
        help.append("\t5 - text file => Recommend dictionary for one collection(profile). single-way(first keyword to the others.)\n");
        help.append("\t6 - text file => Recommend dictionary for one collection(profile). multi-way(each keyword to the others.)\n");
        help.append("\t7 - text file => Recommend dictionary RDBMS table(PREFIX_RECOMMEND) for user system. single-way(first keyword to the others.)\n");
        help.append("\t8 - text file => Recommend dictionary RDBMS table(PREFIX_RECOMMEND) for user system. multi-way(each keyword to the others.)\n");
        help.append("\t9 - text file => Recommend dictionary RDBMS table(PREFIX_RECOMMEND) for one collection. single-way(first keyword to the others.)\n");
        help.append("\t10 - text file => Recommend dictionary RDBMS table(PREFIX_RECOMMEND) for one collection. multi-way(each keyword to the others.)\n");
        help.append("\t11 - Recommend dictionary RDBMS table(PREFIX_RECOMMEND) for user system. => text file\n");
        help.append("\t12 - Recommend dictionary RDBMS table(PREFIX_RECOMMEND) for one collection. => text file\n");
        help.append("filename : Recommend Dictionary text file path\n");
        help.append("(text file : Recommend set for each line, ex) keyword,recommend,recommend )\n\n");
        help.append("<notice>\n");
        help.append("Type 1-6 not execute this process but register task to server. Server must be alive.\n");
    }

    public RecommendDicMaker(String ip, int port, String collection, String profile) {
        this.ip = ip;
        this.port = port;
        this.collection = StringUtil.isEmpty((String)collection) ? "" : collection;
        this.profile = StringUtil.isEmpty((String)profile) ? "" : profile;
    }

    public void transTxtToSystemDic(String file) {
        this.transTxtToDic(file, '1', '1');
    }

    public void transAllTxtToSystemDic(String file) {
        this.transTxtToDic(file, '1', '2');
    }

    public void transTxtToUserSystemDic(String file) {
        this.transTxtToDic(file, '2', '1');
    }

    public void transAllTxtToUserSystemDic(String file) {
        this.transTxtToDic(file, '2', '2');
    }

    public void transTxtToCollectionDic(String file) {
        this.transTxtToDic(file, '3', '1');
    }

    public void transAllTxtToCollectionDic(String file) {
        this.transTxtToDic(file, '3', '2');
    }

    public void transTxtToUserSystemDB(String file) {
        this.transTxtToDB(file, '2', '1');
    }

    public void transAllTxtToUserSystemDB(String file) {
        this.transTxtToDB(file, '2', '2');
    }

    public void transTxtToCollectionDB(String file) {
        this.transTxtToDB(file, '3', '1');
    }

    public void transAllTxtToCollectionDB(String file) {
        this.transTxtToDB(file, '3', '2');
    }

    public void transUserSystemDBToTxt(String file) {
        this.transDBToTxt(file, '2');
    }

    public void transCollectionDBToTxt(String file) {
        this.transDBToTxt(file, '3');
    }

    public void transTxtToDic(String file, char type, char way) {
        block29: {
            BufferedReader in = null;
            try {
                try {
                    RecommendDictionary dic = new RecommendDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        List list = this.makeList(line);
                        String value = "";
                        if (list.size() > 1) {
                            switch (way) {
                                case '1': {
                                    value = this.makeDicInput(list, 0);
                                    dic.add((String)list.get(0), value.toCharArray(), 0, value.length());
                                    ++count;
                                    break;
                                }
                                case '2': {
                                    int i = 0;
                                    while (i < list.size()) {
                                        value = this.makeDicInput(list, i);
                                        dic.add((String)list.get(i), value.toCharArray(), 0, value.length());
                                        ++count;
                                        ++i;
                                    }
                                    break;
                                }
                            }
                        }
                        line = in.readLine();
                    }
                    DataT data = new DataT(3);
                    switch (type) {
                        case '1': {
                            data.put("isSystem", (Transmitable)new BooleanT(true));
                            data.put("collectionID", (Transmitable)new StringT(""));
                            data.put("profileID", (Transmitable)new StringT(""));
                            data.put("dictionary", (Transmitable)dic);
                            break;
                        }
                        case '2': {
                            data.put("isSystem", (Transmitable)new BooleanT(false));
                            data.put("collectionID", (Transmitable)new StringT(""));
                            data.put("profileID", (Transmitable)new StringT(""));
                            data.put("dictionary", (Transmitable)dic);
                            break;
                        }
                        case '3': {
                            data.put("isSystem", (Transmitable)new BooleanT(false));
                            data.put("collectionID", (Transmitable)new StringT(this.collection));
                            data.put("profileID", (Transmitable)new StringT(this.profile));
                            data.put("dictionary", (Transmitable)dic);
                        }
                    }
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.recommend.ExtMessageRecommendDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block29;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDB(String file, char type, char way) {
        block37: {
            Connection conn = null;
            BufferedReader in = null;
            try {
                try {
                    conn = ConnectionFactory.getConnection();
                    conn.setAutoCommit(false);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        StringTokenizer tokenizer = new StringTokenizer(StringUtil.removeWhitespaces((String)line), String.valueOf(','));
                        int tokencnt = tokenizer.countTokens();
                        if (tokencnt > 1) {
                            String[] keywordList = new String[tokencnt];
                            int i = 0;
                            while (i < keywordList.length) {
                                keywordList[i] = tokenizer.nextToken();
                                ++i;
                            }
                            try {
                                String keyword = "";
                                switch (way) {
                                    case '1': {
                                        keyword = keywordList[0];
                                        String[] recommendList = new String[keywordList.length - 1];
                                        int i2 = 0;
                                        while (i2 < recommendList.length) {
                                            recommendList[i2] = keywordList[i2 + 1];
                                            ++i2;
                                        }
                                        if (type == '2') {
                                            RecommendDB.put((Connection)conn, null, null, (String)keyword, (int)recommendList.length, (String[])recommendList);
                                        } else if (type == '3') {
                                            RecommendDB.put((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword, (int)recommendList.length, (String[])recommendList);
                                        }
                                        ++count;
                                        break;
                                    }
                                    case '2': {
                                        String[] recommendList;
                                        int i2 = 0;
                                        while (i2 < keywordList.length) {
                                            keyword = keywordList[i2];
                                            recommendList = new String[keywordList.length - 1];
                                            int index = 0;
                                            int j = 0;
                                            while (j < keywordList.length) {
                                                if (j != i2) {
                                                    recommendList[index] = keywordList[j];
                                                    ++index;
                                                }
                                                ++j;
                                            }
                                            if (type == '2') {
                                                RecommendDB.put((Connection)conn, null, null, (String)keyword, (int)recommendList.length, (String[])recommendList);
                                            } else if (type == '3') {
                                                RecommendDB.put((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword, (int)recommendList.length, (String[])recommendList);
                                            }
                                            ++count;
                                            ++i2;
                                        }
                                        break;
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        line = in.readLine();
                    }
                    conn.commit();
                    System.out.println("Success : " + count + " is imported");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        ConnectionFactory.release((Connection)conn);
                    }
                    if (in == null) break block37;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (conn != null) {
                    ConnectionFactory.release((Connection)conn);
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void transDBToTxt(String file, char type) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = FileUtil.getBufferedWriter((String)file);
                int count = 0;
                StringBuffer buf = new StringBuffer();
                Recommend[] recommends = null;
                switch (type) {
                    case '2': {
                        recommends = RecommendDB.getList((Connection)conn, null, null, (String)"KEYWORD ASC");
                        break;
                    }
                    case '3': {
                        recommends = RecommendDB.getList((Connection)conn, (String)this.collection, (String)this.profile, (String)"KEYWORD ASC");
                    }
                }
                int i = 0;
                while (i < recommends.length) {
                    Recommend recommend = recommends[i];
                    String keyword = recommend.getKeyword();
                    String[] recommendList = recommend.getRecommendList();
                    buf.append(keyword);
                    this.appendRecommendString(recommendList, buf);
                    buf.append('\n');
                    out.write(buf.toString());
                    buf.setLength(0);
                    ++count;
                    ++i;
                }
                out.flush();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private List makeList(String sequence) {
        ArrayList<String> list = new ArrayList<String>();
        char[] arr = sequence.toCharArray();
        int prevPos = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == ',') {
                list.add(StringUtil.removeWhitespaces((String)new String(arr, prevPos, i - prevPos)).toUpperCase());
                prevPos = i + 1;
            }
            ++i;
        }
        list.add(StringUtil.removeWhitespaces((String)new String(arr, prevPos, arr.length - prevPos)).toUpperCase());
        return list;
    }

    private String makeDicInput(List list, int index) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < index) {
            buf.append(StringUtil.removeWhitespaces((String)((String)list.get(i))).toUpperCase());
            buf.append('\t');
            ++i;
        }
        i = index + 1;
        while (i < list.size()) {
            buf.append(StringUtil.removeWhitespaces((String)((String)list.get(i))).toUpperCase());
            buf.append('\t');
            ++i;
        }
        return new String(buf.toString().substring(0, buf.toString().length() - 1));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            System.out.println("Not enough arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String profileID = args[3];
        if ("NULL".equalsIgnoreCase(collectionID) || "*".equals(collectionID)) {
            collectionID = "";
        }
        if ("NULL".equalsIgnoreCase(profileID) || "*".equals(profileID)) {
            profileID = "";
        }
        int cmdType = Integer.parseInt(args[4]);
        String fileName = args[5];
        if (1 > cmdType || cmdType > 12) {
            System.out.println("Illegal type : " + cmdType + "\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            RecommendDicMaker cmd = new RecommendDicMaker(ip, port, collectionID, profileID);
            switch (cmdType) {
                case 1: {
                    cmd.transTxtToSystemDic(fileName);
                    break;
                }
                case 2: {
                    cmd.transAllTxtToSystemDic(fileName);
                    break;
                }
                case 3: {
                    cmd.transTxtToUserSystemDic(fileName);
                    break;
                }
                case 4: {
                    cmd.transAllTxtToUserSystemDic(fileName);
                    break;
                }
                case 5: {
                    cmd.transTxtToCollectionDic(fileName);
                    break;
                }
                case 6: {
                    cmd.transAllTxtToCollectionDic(fileName);
                    break;
                }
                case 7: {
                    cmd.transTxtToUserSystemDB(fileName);
                    break;
                }
                case 8: {
                    cmd.transAllTxtToUserSystemDB(fileName);
                    break;
                }
                case 9: {
                    cmd.transTxtToCollectionDB(fileName);
                    break;
                }
                case 10: {
                    cmd.transAllTxtToCollectionDB(fileName);
                    break;
                }
                case 11: {
                    cmd.transUserSystemDBToTxt(fileName);
                    break;
                }
                case 12: {
                    cmd.transCollectionDBToTxt(fileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }

    private void appendRecommendString(String[] keywords, StringBuffer buf) {
        if (keywords.length > 0) {
            int i = 0;
            while (i < keywords.length) {
                buf.append(',');
                buf.append(keywords[i]);
                ++i;
            }
        }
    }
}

