/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.profile.recommend.Recommend;
import com.diquest.ir.common.database.handler.dictionary.RecommendDB;
import com.diquest.ir.common.msg.dictionary.RecommendDictionary;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class RecommendDicMaker_old {
    public static StringBuffer help = new StringBuffer();
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;

    static {
        help.append("RecommendDicMaker : Import or export recommend dictionary.\n");
        help.append("[IP] [Port] [collectionID] [profileID] [type] [filename]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("CollectionID : Target collection ID\n");
        help.append("ProfileID : Target profile ID\n");
        help.append("type : 1, 2, 3, 4, 5, 6\n");
        help.append("\t1 - text file => Recommend dictionary for all collections. single-way(first keyword to the others.)\n");
        help.append("\t2 - text file => Recommend dictionary for one collection(profile). single-way(first keyword to the others.)\n");
        help.append("\t3 - text file => Recommend dictionary RDBMS table(M2_COLLECTION_RECOMMEND) for one collection. single-way(first keyword to the others.)\n");
        help.append("\t4 - Recommend dictionary RDBMS table(M2_COLLECTION_RECOMMEND) for one collection. => text file\n");
        help.append("\t5 - text file => Recommend dictionary RDBMS table(M2_INTEGRATED_RECOMMEND) for all collections. single-way(first keyword to the others.)\n");
        help.append("\t6 - Recommend dictionary RDBMS table(M2_INETEGRATED_RECOMMEND) for all collections. => text file\n");
        help.append("filename : Recommend Dictionary text file path\n");
        help.append("(text file : Recommend set for each line, ex) keyword recommend recommend)\n\n");
        help.append("<notice>\n");
        help.append("Type 1, 2, not execute this process but register task to server. Server must be alive.\n");
    }

    public RecommendDicMaker_old(String ip, int port, String collection, String profile) {
        this.ip = ip;
        this.port = port;
        this.collection = collection;
        this.profile = profile;
    }

    public void transTxtToSystemDic(String file) {
        block19: {
            BufferedReader in = null;
            try {
                try {
                    RecommendDictionary dic = new RecommendDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        List list = this.makeList(line);
                        if (list.size() > 1) {
                            String value = this.makeDicInput(list, 0).toUpperCase();
                            dic.add(((String)list.get(0)).toUpperCase(), value.toCharArray(), 0, value.length());
                            ++count;
                        }
                        line = in.readLine();
                    }
                    DataT data = new DataT(3);
                    data.put("collectionID", (Transmitable)new StringT(""));
                    data.put("profileID", (Transmitable)new StringT(""));
                    data.put("dic", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.recommend.ExtMessageRecommendDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block19;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDic(String file) {
        block19: {
            BufferedReader in = null;
            try {
                try {
                    RecommendDictionary dic = new RecommendDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        List list = this.makeList(line);
                        if (list.size() > 1) {
                            String value = this.makeDicInput(list, 0).toUpperCase();
                            dic.add(((String)list.get(0)).toUpperCase(), value.toCharArray(), 0, value.length());
                            ++count;
                        }
                        line = in.readLine();
                    }
                    DataT data = new DataT(3);
                    data.put("collectionID", (Transmitable)new StringT(this.collection));
                    data.put("profileID", (Transmitable)new StringT(this.profile));
                    data.put("dic", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.recommend.ExtMessageRecommendDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block19;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDB(String file) {
        block22: {
            Connection conn = null;
            BufferedReader in = null;
            try {
                try {
                    conn = ConnectionFactory.getConnection();
                    conn.setAutoCommit(false);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                        if (tokenizer.countTokens() > 2) {
                            String keyword = tokenizer.nextToken();
                            String[] recommendList = new String[tokenizer.countTokens() - 1];
                            int i = 0;
                            while (i < recommendList.length) {
                                recommendList[i] = tokenizer.nextToken();
                                ++i;
                            }
                            try {
                                RecommendDB.put((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword, (int)recommendList.length, (String[])recommendList);
                                ++count;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        line = in.readLine();
                    }
                    conn.commit();
                    System.out.println("Success : " + count + " is imported");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        ConnectionFactory.release((Connection)conn);
                    }
                    if (in == null) break block22;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (conn != null) {
                    ConnectionFactory.release((Connection)conn);
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void transDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = FileUtil.getBufferedWriter((String)file);
                int count = 0;
                StringBuffer buf = new StringBuffer();
                Recommend[] recommends = RecommendDB.getList((Connection)conn, (String)this.collection, (String)this.profile, (String)"KEYWORD ASC");
                int i = 0;
                while (i < recommends.length) {
                    Recommend recommend = recommends[i];
                    String keyword = recommend.getKeyword();
                    String[] recommendList = recommend.getRecommendList();
                    buf.append(keyword).append('\t');
                    this.appendRecommendString(recommendList, buf);
                    buf.append('\n');
                    out.write(buf.toString());
                    buf.setLength(0);
                    ++count;
                    ++i;
                }
                out.flush();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transTxtToSystemDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                    if (tokenizer.countTokens() > 2) {
                        String keyword = tokenizer.nextToken();
                        String[] recommendList = new String[tokenizer.countTokens() - 1];
                        int i = 0;
                        while (i < recommendList.length) {
                            recommendList[i] = tokenizer.nextToken();
                            ++i;
                        }
                        try {
                            RecommendDB.put((Connection)conn, null, null, (String)keyword, (int)recommendList.length, (String[])recommendList);
                            ++count;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transSystemDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = FileUtil.getBufferedWriter((String)file);
                int count = 0;
                StringBuffer buf = new StringBuffer();
                Recommend[] recommends = RecommendDB.getList((Connection)conn, null, null, (String)"KEYWORD ASC");
                int i = 0;
                while (i < recommends.length) {
                    Recommend recommend = recommends[i];
                    String keyword = recommend.getKeyword();
                    String[] recommendList = recommend.getRecommendList();
                    buf.append(keyword).append('\t');
                    this.appendRecommendString(recommendList, buf);
                    buf.append('\n');
                    out.write(buf.toString());
                    buf.setLength(0);
                    ++count;
                    ++i;
                }
                out.flush();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private List makeList(String sequence) {
        ArrayList<String> list = new ArrayList<String>();
        char[] arr = sequence.toCharArray();
        int prevPos = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == '\t') {
                list.add(new String(arr, prevPos, i - prevPos));
                prevPos = i + 1;
            }
            ++i;
        }
        list.add(new String(arr, prevPos, arr.length - prevPos));
        return list;
    }

    private String makeInput(List list, int index) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < index) {
            buf.append(list.get(i));
            buf.append('_');
            ++i;
        }
        i = index + 1;
        while (i < list.size()) {
            buf.append(list.get(i));
            buf.append('_');
            ++i;
        }
        return buf.toString().substring(0, buf.toString().length() - 1);
    }

    private String makeDicInput(List list, int index) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < index) {
            buf.append(list.get(i));
            buf.append('\t');
            ++i;
        }
        i = index + 1;
        while (i < list.size()) {
            buf.append(list.get(i));
            buf.append('\t');
            ++i;
        }
        return buf.toString().substring(0, buf.toString().length() - 1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            System.out.println("Not enough arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String profileID = args[3];
        if (profileID.equalsIgnoreCase("NULL")) {
            profileID = "";
        }
        int cmdType = Integer.parseInt(args[4]);
        String fileName = args[5];
        if (1 > cmdType || cmdType > 6) {
            System.out.println("Illegal type : " + cmdType + "\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            RecommendDicMaker_old cmd = new RecommendDicMaker_old(ip, port, collectionID, profileID);
            switch (cmdType) {
                case 1: {
                    cmd.transTxtToSystemDic(fileName);
                    break;
                }
                case 2: {
                    cmd.transTxtToDic(fileName);
                    break;
                }
                case 3: {
                    cmd.transTxtToDB(fileName);
                    break;
                }
                case 4: {
                    cmd.transDBToTxt(fileName);
                    break;
                }
                case 5: {
                    cmd.transTxtToSystemDB(fileName);
                    break;
                }
                case 6: {
                    cmd.transSystemDBToTxt(fileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }

    private void appendRecommendString(String[] keywords, StringBuffer buf) {
        if (keywords.length > 1) {
            buf.append(keywords[0]);
            int i = 1;
            while (i < keywords.length) {
                buf.append('\t');
                buf.append(keywords[i]);
                ++i;
            }
        }
    }
}

