/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.profile.redirect.Redirect;
import com.diquest.ir.common.database.handler.dictionary.RedirectDB;
import com.diquest.ir.common.msg.dictionary.RedirectDictionary;
import com.diquest.ir.common.msg.dictionary.RedirectElement;
import com.diquest.ir.util.common.DateUtil;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RedirectDicMaker {
    public static StringBuffer help;
    public static final String dateFormatString = "yyyyMMddHHmmss";
    public static final String NEW_LINE = "\n";
    public static final char KEY_DELIMITER = '\t';
    public static final char KEYSET_DELIMITER = ',';
    public static int SIZE_REDIRECT_ELEMENT;
    public static final char SYSTEM = '1';
    public static final char USER_SYSTEM = '2';
    public static final char COLLECTION = '3';
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;

    static {
        SIZE_REDIRECT_ELEMENT = 6;
        help = new StringBuffer();
        help.append("RedirectDicMaker : Import or export Redirect dictionary\n");
        help.append("[IP] [Port] [collectionID] [profileID] [type] [filename]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("CollectionID : Target collection ID\n");
        help.append("ProfileID : Target profile ID\n");
        help.append("\t1 - text file => Redirect dictionary for user system.\n");
        help.append("\t2 - text file => Redirect dictionary for one collection(profile).\n");
        help.append("\t3 - text file => Redirect dictionary RDBMS table(PREFIX_REDIRECT) for user system\n");
        help.append("\t4 - text file => Redirect dictionary RDBMS table(PREFIX_REDIRCT) for one collection(profile).\n");
        help.append("\t5 - Redirect dictionary RDBMS table(PREFIX_REDIRECT) for user system => text file\n");
        help.append("\t6 - Redirect dictionary RDBMS table(PREFIX_REDIRECT) for one collection(profile) => text file\n");
        help.append("filename : Redirect dictionary text file path.\n");
        help.append("(text file : Redirects for each line. ex) title,keyword,url1&|url2&|url3,author,start,end \n\n");
        help.append("<notice>\n");
        help.append("Type 1, 2, not execute this process but register task to server. Server must be alive.\n");
    }

    public RedirectDicMaker(String ip, int port, String collection, String profile) {
        this.ip = ip;
        this.port = port;
        this.collection = StringUtil.isEmpty((String)collection) ? "" : collection;
        this.profile = StringUtil.isEmpty((String)profile) ? "" : profile;
    }

    public void transTxtToUserSystemDic(String file) {
        this.transTxtToDic(file, '2');
    }

    public void transTxtToCollectionDic(String file) {
        this.transTxtToDic(file, '3');
    }

    public void transTxtToUserSystemDB(String file) {
        this.transTxtToDB(file, '2');
    }

    public void transTxtToCollectionDB(String file) {
        this.transTxtToDB(file, '3');
    }

    public void transUserSystemDBToTxt(String file) {
        this.transDBToTxt(file, '2');
    }

    public void transCollectionDBToTxt(String file) {
        this.transDBToTxt(file, '3');
    }

    public void transTxtToDic(String file, char type) {
        block27: {
            BufferedReader in = null;
            try {
                try {
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    HashMap<String, RedirectElement> mapKeyRedirect = new HashMap<String, RedirectElement>(1);
                    while (line != null && line.length() > 0) {
                        List list = this.makeList(line);
                        if (list.size() > SIZE_REDIRECT_ELEMENT - 1) {
                            char[] themeTitle = ((String)list.get(0)).toCharArray();
                            String keywordSet = (String)list.get(1);
                            String url = (String)list.get(2);
                            url = StringUtil.simpleHTML2Text((String)url);
                            url = StringUtil.simpleHTML2TextApos((String)url);
                            char[] author = ((String)list.get(3)).toCharArray();
                            String startDateString = (String)list.get(4);
                            long start = startDateString.equals("0") ? 0L : this.dateToLong(startDateString);
                            String endDateString = (String)list.get(5);
                            long end = endDateString.equals("0") ? 0L : this.dateToLong(endDateString);
                            String[] keywords = keywordSet.split(",");
                            int i = 0;
                            while (i < keywords.length) {
                                if (mapKeyRedirect.containsKey(keywords[i])) {
                                    RedirectElement redirectEle = (RedirectElement)mapKeyRedirect.get(keywords[i]);
                                    redirectEle.add(start, end, url.toCharArray());
                                    mapKeyRedirect.put(keywords[i], redirectEle);
                                } else {
                                    mapKeyRedirect.put(keywords[i], new RedirectElement(new long[]{start}, new long[]{end}, url));
                                }
                                ++i;
                            }
                            ++count;
                        }
                        line = in.readLine();
                    }
                    RedirectDictionary dic = new RedirectDictionary(mapKeyRedirect.size());
                    Set entrySet = mapKeyRedirect.entrySet();
                    Iterator itrSet = entrySet.iterator();
                    while (itrSet.hasNext()) {
                        Map.Entry entry = itrSet.next();
                        RedirectElement redirectEle = (RedirectElement)entry.getValue();
                        byte[] value = RedirectElement.createBytes((long[])redirectEle.getStart(), (long[])redirectEle.getEnd(), (char[][])redirectEle.getUrl());
                        dic.add(((String)entry.getKey()).toCharArray(), value);
                    }
                    in.close();
                    DataT data = new DataT(3);
                    switch (type) {
                        case '1': 
                        case '2': {
                            data.put("collectionID", (Transmitable)new StringT(""));
                            data.put("profileID", (Transmitable)new StringT(""));
                            data.put("dictionary", (Transmitable)dic);
                            break;
                        }
                        case '3': {
                            data.put("collectionID", (Transmitable)new StringT(this.collection));
                            data.put("profileID", (Transmitable)new StringT(this.profile));
                            data.put("dictionary", (Transmitable)dic);
                            break;
                        }
                    }
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.redirect.ExtMessageRedirectDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block27;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDB(String file, char type) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    List list = this.makeList(line);
                    if (list.size() > SIZE_REDIRECT_ELEMENT - 1) {
                        String themeTitle = (String)list.get(0);
                        String keyword = (String)list.get(1);
                        String redirectURL = (String)list.get(2);
                        redirectURL = StringUtil.simpleHTML2Text((String)redirectURL);
                        redirectURL = StringUtil.simpleHTML2TextApos((String)redirectURL);
                        String author = (String)list.get(3);
                        String startDate = (String)list.get(4);
                        long start = this.dateToLong(startDate);
                        String endDate = (String)list.get(5);
                        long end = this.dateToLong(endDate);
                        switch (type) {
                            case '2': {
                                RedirectDB.put((Connection)conn, null, null, (String)keyword, (String)themeTitle, (String)author, (long)start, (long)end, (String)redirectURL);
                                break;
                            }
                            case '3': {
                                RedirectDB.put((Connection)conn, (String)this.collection, (String)this.profile, (String)keyword, (String)themeTitle, (String)author, (long)start, (long)end, (String)redirectURL);
                                break;
                            }
                        }
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transDBToTxt(String file, char type) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = FileUtil.getBufferedWriter((String)file);
                int count = 0;
                Redirect[] redirects = null;
                switch (type) {
                    case '2': {
                        redirects = RedirectDB.getList((Connection)conn, null, null, (String)"KEYWORD ASC");
                        break;
                    }
                    case '3': {
                        redirects = RedirectDB.getList((Connection)conn, (String)this.collection, (String)this.profile, (String)"KEYWORD ASC");
                        break;
                    }
                }
                int i = 0;
                while (i < redirects.length) {
                    Redirect redirect = redirects[i];
                    String themeTitle = redirect.getThemeTitle();
                    String keyword = redirect.getKeyword();
                    String redirectURL = redirect.getRedirectHtmlURL();
                    String author = redirect.getAuthor();
                    String startDate = DateUtil.changeFormat((Date)new Date(redirect.getStart()), (String)dateFormatString);
                    String endDate = DateUtil.changeFormat((Date)new Date(redirect.getEnd()), (String)dateFormatString);
                    out.write(String.valueOf(themeTitle) + '\t' + keyword + '\t' + redirectURL + '\t' + author + '\t' + startDate + '\t' + endDate + NEW_LINE);
                    ++count;
                    ++i;
                }
                out.flush();
                out.close();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private long dateToLong(String date) {
        Date d = DateUtil.getDate((String)date);
        return d.getTime();
    }

    private List makeList(String sequence) {
        ArrayList<String> list = new ArrayList<String>();
        char[] arr = sequence.toCharArray();
        int prevPos = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == '\t') {
                list.add(new String(arr, prevPos, i - prevPos).toUpperCase().trim());
                prevPos = i + 1;
            }
            ++i;
        }
        list.add(new String(arr, prevPos, arr.length - prevPos).toUpperCase().trim());
        return list;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            System.out.println("Not enough arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String profileID = args[3];
        if ("NULL".equalsIgnoreCase(collectionID) || "*".equals(collectionID)) {
            collectionID = "";
        }
        if ("NULL".equalsIgnoreCase(profileID) || "*".equals(profileID)) {
            profileID = "";
        }
        int cmdType = Integer.parseInt(args[4]);
        String fileName = args[5];
        if (1 > cmdType || cmdType > 6) {
            System.out.println("Illegal type :" + cmdType + NEW_LINE);
            System.out.println(help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            RedirectDicMaker cmd = new RedirectDicMaker(ip, port, collectionID, profileID);
            switch (cmdType) {
                case 1: {
                    cmd.transTxtToUserSystemDic(fileName);
                    break;
                }
                case 2: {
                    cmd.transTxtToCollectionDic(fileName);
                    break;
                }
                case 3: {
                    cmd.transTxtToUserSystemDB(fileName);
                    break;
                }
                case 4: {
                    cmd.transTxtToCollectionDB(fileName);
                    break;
                }
                case 5: {
                    cmd.transUserSystemDBToTxt(fileName);
                    break;
                }
                case 6: {
                    cmd.transCollectionDBToTxt(fileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

