/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.apps.dicmaker.RedirectDicMaker;
import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.profile.redirect.Redirect;
import com.diquest.ir.common.database.handler.dictionary.RedirectDB;
import com.diquest.ir.common.msg.dictionary.RedirectDictionary;
import com.diquest.ir.util.common.DateUtil;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RedirectDicMaker_old {
    public static StringBuffer help = new StringBuffer();
    public static final String dateFormatString = "yyyyMMddHHmmss";
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;

    static {
        help.append("RedirectDicMaker : Import or export Redirect dictionary\n");
        help.append("[IP] [Port] [collectionID] [profileID] [type] [filename]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("CollectionID : Target collection ID\n");
        help.append("ProfileID : Target profile ID\n");
        help.append("\t1 - text file => Redirect dictionary for System.\n");
        help.append("\t2 - text file => Redirect dictionary for one collection(profile).\n");
        help.append("\t3 - text file => Redirect dictionary RDBMS table(PREFIX_REDIRCT) for one collection(profile).\n");
        help.append("\t4 - Redirect dictionary RDBMS table(PREFIX_REDIRECT) for one collection(profile) => text file\n");
        help.append("\t5 - text file => Redirect dictionary RDBMS table(PREFIX_STOPWORD) for System\n");
        help.append("\t6 - Redirect dictionary RDBMS table(PREFIX_REDIRECT) for System => text file\n");
        help.append("filename : Redirect dictionary text file path.\n");
        help.append("(text file : Redirects for each line. dateformat : yyyyMMddHHmmss)\n\n");
        help.append("<notice>\n");
        help.append("Type 1, 2, not execute this process but register task to server. Server must be alive.\n");
    }

    public RedirectDicMaker_old(String ip, int port, String collection, String profile) {
        this.ip = ip;
        this.port = port;
        this.collection = collection;
        this.profile = profile;
    }

    private long dateToLong(String date) {
        Date d = DateUtil.getDate((String)date);
        return d.getTime();
    }

    public void transTxtToSystemDic(String file) {
        block19: {
            BufferedReader in = null;
            try {
                try {
                    RedirectDictionary dic = new RedirectDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        List list = this.makeList(line);
                        if (list.size() > 3) {
                            char[] keyword = ((String)list.get(0)).toCharArray();
                            String startDateString = (String)list.get(1);
                            long start = this.dateToLong(startDateString);
                            String endDateString = (String)list.get(2);
                            long end = this.dateToLong(endDateString);
                            char[] url = ((String)list.get(3)).toCharArray();
                            dic.add(keyword, start, end, url);
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(3);
                    data.put("collectionID", (Transmitable)new StringT(""));
                    data.put("profileID", (Transmitable)new StringT(""));
                    data.put("dic", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.redirect.ExtMessageRedirectDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block19;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDic(String file) {
        block19: {
            BufferedReader in = null;
            try {
                try {
                    RedirectDictionary dic = new RedirectDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        List list = this.makeList(line);
                        if (list.size() > 3) {
                            char[] keyword = ((String)list.get(0)).toCharArray();
                            String startDateString = (String)list.get(1);
                            long start = this.dateToLong(startDateString);
                            String endDateString = (String)list.get(2);
                            long end = this.dateToLong(endDateString);
                            char[] url = ((String)list.get(3)).toCharArray();
                            dic.add(keyword, start, end, url);
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(3);
                    data.put("collectionID", (Transmitable)new StringT(this.collection));
                    data.put("profileID", (Transmitable)new StringT(this.profile));
                    data.put("dic", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.redirect.ExtMessageRedirectDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block19;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    List list = this.makeList(line);
                    if (list.size() > 3) {
                        String keyword = (String)list.get(0);
                        String startDate = (String)list.get(1);
                        long start = this.dateToLong(startDate);
                        String endDate = (String)list.get(2);
                        long end = this.dateToLong(endDate);
                        String redirectURL = (String)list.get(3);
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                RedirectDB db = new RedirectDB();
                out = FileUtil.getBufferedWriter((String)file);
                int count = 0;
                Redirect[] redirects = RedirectDB.getList((Connection)conn, (String)this.collection, (String)this.profile, (String)"KEYWORD ASC");
                int i = 0;
                while (i < redirects.length) {
                    Redirect redirect = redirects[i];
                    String keyword = redirect.getKeyword().replace('\t', ' ');
                    String startDate = DateUtil.changeFormat((Date)new Date(redirect.getStart()), (String)dateFormatString);
                    String endDate = DateUtil.changeFormat((Date)new Date(redirect.getEnd()), (String)dateFormatString);
                    String redirectURL = redirect.getRedirectURL();
                    out.write(String.valueOf(keyword) + "\t" + startDate + "\t" + endDate + "\t" + redirectURL + "\n");
                    ++count;
                    ++i;
                }
                out.flush();
                out.close();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transTxtToSystemDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                RedirectDB db = new RedirectDB();
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    List list = this.makeList(line);
                    if (list.size() > 3) {
                        String keyword = (String)list.get(0);
                        String startDate = (String)list.get(1);
                        long start = this.dateToLong(startDate);
                        String endDate = (String)list.get(2);
                        long end = this.dateToLong(endDate);
                        String redirectURL = (String)list.get(3);
                        ++count;
                    }
                    line = in.readLine();
                }
                in.close();
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transSystemDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                RedirectDB db = new RedirectDB();
                out = FileUtil.getBufferedWriter((String)file);
                int count = 0;
                Redirect[] redirects = RedirectDB.getList((Connection)conn, null, null, (String)"KEYWORD ASC");
                int i = 0;
                while (i < redirects.length) {
                    Redirect redirect = redirects[i];
                    String keyword = redirect.getKeyword().replace('\t', ' ');
                    String startDate = DateUtil.changeFormat((Date)new Date(redirect.getStart()), (String)dateFormatString);
                    String endDate = DateUtil.changeFormat((Date)new Date(redirect.getEnd()), (String)dateFormatString);
                    String redirectURL = redirect.getRedirectURL();
                    out.write(String.valueOf(keyword) + "\t" + startDate + "\t" + endDate + "\t" + redirectURL + "\n");
                    ++count;
                    ++i;
                }
                out.flush();
                out.close();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private List makeList(String sequence) {
        ArrayList<String> list = new ArrayList<String>();
        char[] arr = sequence.toCharArray();
        int prevPos = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == '\t') {
                list.add(new String(arr, prevPos, i - prevPos));
                prevPos = i + 1;
            }
            ++i;
        }
        list.add(new String(arr, prevPos, arr.length - prevPos));
        return list;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            System.out.println("Not enough arguments.\n");
            System.out.println(RedirectDicMaker.help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String profileID = args[3];
        if (profileID.equalsIgnoreCase("NULL")) {
            profileID = "";
        }
        int cmdType = Integer.parseInt(args[4]);
        String fileName = args[5];
        if (1 > cmdType || cmdType > 6) {
            System.out.println("Illegal type :" + cmdType + "\n");
            System.out.println(RedirectDicMaker.help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            RedirectDicMaker_old cmd = new RedirectDicMaker_old(ip, port, collectionID, profileID);
            switch (cmdType) {
                case 1: {
                    cmd.transTxtToSystemDic(fileName);
                    break;
                }
                case 2: {
                    cmd.transTxtToDic(fileName);
                    break;
                }
                case 3: {
                    cmd.transTxtToDB(fileName);
                    break;
                }
                case 4: {
                    cmd.transDBToTxt(fileName);
                    break;
                }
                case 5: {
                    cmd.transTxtToSystemDB(fileName);
                    break;
                }
                case 6: {
                    cmd.transSystemDBToTxt(fileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

