/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.handler.dictionary.StopwordDB;
import com.diquest.ir.common.msg.dictionary.StopwordDictionary;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.common.StringTokenizer;
import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class StopwordDicMaker {
    public static StringBuffer help = new StringBuffer();
    private static final char KEY_DELIMITER = ',';
    public static final char SYSTEM = '1';
    public static final char USER_SYSTEM = '2';
    public static final char COLLECTION = '3';
    public static final char FIELD = '4';
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;
    private final String field;

    static {
        help.append("StopwordDicMaker : Import or export stopword dictionary.\n");
        help.append("[IP] [Port] [collectionID] [profileID] [fieldID] [type] [filename]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("CollectionID : Target collection ID\n");
        help.append("ProfileID : Target profile ID (If null, default profile of target Collection.\n");
        help.append("fieldID : Target field ID (If null, for every field. If not null, target field Stopword dictionary.\n");
        help.append("type : 1, 2, 3, 4, 5, 6, 7, 8, 9\n");
        help.append("\t1 - text file => Stopword dictionary for user system.\n");
        help.append("\t2 - text file => Stopword dictionary for one collection(profile).\n");
        help.append("\t3 - text file => Stopword dictionary for one field of collection.\n");
        help.append("\t4 - text file => Stopword dictionary RDBMS table(PREFIX_STOPWORD) for user system.\n");
        help.append("\t5 - text file => Stopword dictionary RDBMS table(PREFIX_STOPWORD) for one collection(profile).\n");
        help.append("\t6 - text file => Stopword dictionary RDBMS table(PREFIX_STOPWORD) for one field of collections.\n");
        help.append("\t7 - Stopword dictionary RDBMS table(PREFIX_STOPWORD) for user system => text file.\n");
        help.append("\t8 - Stopword dictionary RDBMS table(PREFIX_STOPWORD) for one collection(profile) => text file.\n");
        help.append("\t9 - Stopword dictionary RDBMS table(PREFIX_STOPWORD) for one field of collection => text file.\n");
        help.append("filename : Stopword dictionary text file path.\n");
        help.append("(text file : stopword,field for each line. )\n\n");
        help.append("<notice>\n");
        help.append("Type 1, 2 and 3 does not execute this process but register task to server. Server must be alive.\n");
    }

    public StopwordDicMaker(String ip, int port, String collection, String profile, String field) {
        this.ip = ip;
        this.port = port;
        this.collection = StringUtil.isEmpty((String)collection) ? "" : collection;
        this.profile = StringUtil.isEmpty((String)profile) ? "" : profile;
        this.field = StringUtil.isEmpty((String)field) ? "" : field;
    }

    public void transTxtToUserSystemDic(String file) {
        this.transTxtToDic(file, '2');
    }

    public void transTxtToCollectionDic(String file) {
        this.transTxtToDic(file, '3');
    }

    public void transTxtToFieldDic(String file) {
        this.transTxtToDic(file, '4');
    }

    public void transTxtToUserSystemDB(String file) {
        this.transTxtToDB(file, '2');
    }

    public void transTxtToCollectionDB(String file) {
        this.transTxtToDB(file, '3');
    }

    public void transTxtToFieldDB(String file) {
        this.transTxtToDB(file, '4');
    }

    public void transUserSystemDBToTxt(String file) {
        this.transDBToTxt(file, '2');
    }

    public void transCollectionDBToTxt(String file) {
        this.transDBToTxt(file, '3');
    }

    public void transFieldDBToTxt(String file) {
        this.transDBToTxt(file, '4');
    }

    public void transTxtToDic(String file, char type) {
        block40: {
            BufferedReader in = null;
            boolean hasField = false;
            try {
                try {
                    StopwordDictionary dic = null;
                    HashMap<String, HashSet> map = new HashMap<String, HashSet>();
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        if (!line.trim().equals("")) {
                            char[][] terms = StringTokenizer.token((String)StringUtil.removeWhitespaces((String)line.toUpperCase()), (char)',');
                            if (terms.length <= 2) {
                                if (terms.length == 2) {
                                    hasField = true;
                                    String keyword = new String(terms[0]);
                                    String field = new String(terms[1]);
                                    HashSet set = null;
                                    set = !map.containsKey(field) ? new HashSet() : (HashSet)map.get(field);
                                    set.add(keyword);
                                    map.put(field, set);
                                } else {
                                    if (dic == null) {
                                        dic = new StopwordDictionary(16384);
                                    }
                                    dic.add(StringUtil.removeWhitespaces((String)line));
                                }
                            }
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    ExtRequest request = null;
                    ExtResponse response = null;
                    boolean occurError = false;
                    if (hasField) {
                        Iterator iter = map.keySet().iterator();
                        while (iter.hasNext()) {
                            String newField = (String)iter.next();
                            StopwordDictionary newDic = new StopwordDictionary(16384);
                            HashSet newSet = (HashSet)map.get(newField);
                            Iterator iter2 = newSet.iterator();
                            while (iter2.hasNext()) {
                                newDic.add((String)iter2.next());
                            }
                            DataT data = new DataT(4);
                            data.put("collectionID", (Transmitable)new StringT(this.collection));
                            data.put("profileID", (Transmitable)new StringT(""));
                            data.put("fieldID", (Transmitable)new StringT(newField));
                            data.put("dictionary", (Transmitable)newDic);
                            request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.stopword.ExtMessageStopwordDicApply", (Transmitable)data);
                            response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                            boolean bl = occurError = occurError || response.getErrorCode() <= 0;
                        }
                        if (dic != null) {
                            DataT data = new DataT(4);
                            switch (type) {
                                case '1': {
                                    break;
                                }
                                case '2': {
                                    break;
                                }
                                case '3': {
                                    data.put("collectionID", (Transmitable)new StringT(this.collection));
                                    data.put("profileID", (Transmitable)new StringT(this.profile));
                                    data.put("fieldID", (Transmitable)new StringT(""));
                                    data.put("dictionary", (Transmitable)dic);
                                    break;
                                }
                                case '4': {
                                    break;
                                }
                            }
                            request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.stopword.ExtMessageStopwordDicApply", (Transmitable)data);
                            response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                            occurError = occurError || response.getErrorCode() <= 0;
                        }
                    } else {
                        DataT data = new DataT(4);
                        switch (type) {
                            case '1': {
                                break;
                            }
                            case '2': {
                                data.put("collectionID", (Transmitable)new StringT(""));
                                data.put("profileID", (Transmitable)new StringT(""));
                                data.put("fieldID", (Transmitable)new StringT(""));
                                data.put("dictionary", (Transmitable)dic);
                                break;
                            }
                            case '3': {
                                data.put("collectionID", (Transmitable)new StringT(this.collection));
                                data.put("profileID", (Transmitable)new StringT(this.profile));
                                data.put("fieldID", (Transmitable)new StringT(""));
                                data.put("dictionary", (Transmitable)dic);
                                break;
                            }
                            case '4': {
                                data.put("collectionID", (Transmitable)new StringT(this.collection));
                                data.put("profileID", (Transmitable)new StringT(""));
                                data.put("fieldID", (Transmitable)new StringT(this.field));
                                data.put("dictionary", (Transmitable)dic);
                                break;
                            }
                        }
                        request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.stopword.ExtMessageStopwordDicApply", (Transmitable)data);
                        response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                        boolean bl = occurError = occurError || response.getErrorCode() <= 0;
                    }
                    if (!occurError) {
                        System.out.println("Success : " + count + " is imported");
                        break block40;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDB(String file, char type) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    if (!line.trim().equals("")) {
                        String keyword = StringUtil.removeWhitespaces((String)line.toUpperCase());
                        switch (type) {
                            case '1': {
                                break;
                            }
                            case '2': {
                                StopwordDB.put((Connection)conn, null, null, null, (String)keyword);
                                break;
                            }
                            case '3': {
                                StopwordDB.put((Connection)conn, (String)this.collection, (String)this.profile, null, (String)keyword);
                                break;
                            }
                            case '4': {
                                char[][] terms = StringTokenizer.token((String)keyword, (char)',');
                                if (terms.length > 2 || terms.length != 2) break;
                                String key = new String(terms[0]);
                                String field = new String(terms[1]);
                                StopwordDB.put((Connection)conn, (String)this.collection, null, (String)field, (String)key);
                                break;
                            }
                        }
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Exception decompiling
     */
    public void transDBToTxt(String file, char type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 7) {
            System.out.println("Not enough arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String profileID = args[3];
        String fieldID = args[4];
        if ("NULL".equalsIgnoreCase(collectionID) || "*".equals(collectionID)) {
            collectionID = "";
        }
        if ("NULL".equalsIgnoreCase(profileID) || "*".equals(profileID)) {
            profileID = "";
        }
        int cmdType = Integer.parseInt(args[5]);
        String fileName = args[6];
        if (1 > cmdType || cmdType > 10) {
            System.out.println("Illegal type : " + cmdType + "\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            StopwordDicMaker cmd = new StopwordDicMaker(ip, port, collectionID, profileID, fieldID);
            switch (cmdType) {
                case 1: {
                    cmd.transTxtToUserSystemDic(fileName);
                    break;
                }
                case 2: {
                    cmd.transTxtToCollectionDic(fileName);
                    break;
                }
                case 3: {
                    cmd.transTxtToFieldDic(fileName);
                    break;
                }
                case 4: {
                    cmd.transTxtToUserSystemDB(fileName);
                    break;
                }
                case 5: {
                    cmd.transTxtToCollectionDB(fileName);
                    break;
                }
                case 6: {
                    cmd.transTxtToFieldDB(fileName);
                    break;
                }
                case 7: {
                    cmd.transUserSystemDBToTxt(fileName);
                    break;
                }
                case 8: {
                    cmd.transCollectionDBToTxt(fileName);
                    break;
                }
                case 9: {
                    cmd.transFieldDBToTxt(fileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

