/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.profile.stopword.Stopword;
import com.diquest.ir.common.database.handler.dictionary.StopwordDB;
import com.diquest.ir.common.msg.dictionary.StopwordDictionary;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.sql.Connection;

public class StopwordDicMaker_old {
    public static StringBuffer help = new StringBuffer();
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;
    private final String field;

    static {
        help.append("StopwordDicMaker : Import or export stopword dictionary.\n");
        help.append("[IP] [Port] [collectionID] [profileID] [fieldID] [type] [filename]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("CollectionID : Target collection ID\n");
        help.append("ProfileID : Target profile ID (If null, default profile of target Collection.\n");
        help.append("fieldID : Target field ID (If null, for every field. If not null, target field Stopword dictionary.\n");
        help.append("type : 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12\n");
        help.append("\t1 - text file => Stopword dictionary for all collections(System).\n");
        help.append("\t2 - text file => Stopword dictionary for one collection(profile).\n");
        help.append("\t3 - text file => Stopword dictionary for one profile of collection.\n");
        help.append("\t4 - text file => Stopword dictionary for one field of collection.\n");
        help.append("\t5 - text file => Stopword dictionary RDBMS table(PREFIX_STOPWORD) for one collection(profile).\n");
        help.append("\t6 - text file => Stopword dictionary RDBMS table(PREFIX_STOPWORD) for all collections(System)\n");
        help.append("\t7 - text file => Stopword dictionary RDBMS table(PREFIX_STOPWORD) for one profile of collections\n");
        help.append("\t8 - text file => Stopword dictionary RDBMS table(PREFIX_STOPWORD) for one field of collections\n");
        help.append("\t9 - Stopword dictionary RDBMS table(PREFIX_STOPWORD) for one collection(profile) => text file\n");
        help.append("\t10 - Stopword dictionary RDBMS table(PREFIX_STOPWORD) for all collections(System) => text file\n");
        help.append("\t11 - Stopword dictionary RDBMS table(PREFIX_STOPWORD) for one profile of collection => text file\n");
        help.append("\t12 - Stopword dictionary RDBMS table(PREFIX_STOPWORD) for one field of collection => text file\n");
        help.append("filename : Stopword dictionary text file path.\n");
        help.append("(text file : field\tstopword for each line.\n\n");
        help.append("<notice>\n");
        help.append("Type 1, 2, 3 and 4 does not execute this process but register task to server. Server must be alive.\n");
    }

    public StopwordDicMaker_old(String ip, int port, String collection, String profile, String field) {
        this.ip = ip;
        this.port = port;
        this.collection = collection;
        this.profile = profile;
        this.field = field;
    }

    public void transTxtToSystemDic(String file) {
        block19: {
            BufferedReader in = null;
            try {
                try {
                    StopwordDictionary dic = new StopwordDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        if ((line = line.trim()).length() > 0) {
                            dic.add(line);
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(4);
                    data.put("collectionID", (Transmitable)new StringT(""));
                    data.put("profileID", (Transmitable)new StringT(""));
                    data.put("fieldID", (Transmitable)new StringT(""));
                    data.put("dictionary", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.stopword.ExtMessageStopwordDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block19;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToCollectionDic(String file) {
        block19: {
            BufferedReader in = null;
            try {
                try {
                    StopwordDictionary dic = new StopwordDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        if (!line.trim().equals("")) {
                            dic.add(line.trim());
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(4);
                    data.put("collectionID", (Transmitable)new StringT(this.collection));
                    data.put("profileID", (Transmitable)new StringT(""));
                    data.put("fieldID", (Transmitable)new StringT(""));
                    data.put("dictionary", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.stopword.ExtMessageStopwordDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block19;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToProfileDic(String file) {
        block19: {
            BufferedReader in = null;
            try {
                try {
                    StopwordDictionary dic = new StopwordDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        if (!line.trim().equals("")) {
                            dic.add(line.trim());
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(4);
                    data.put("collectionID", (Transmitable)new StringT(this.collection));
                    data.put("profileID", (Transmitable)new StringT(this.profile));
                    data.put("fieldID", (Transmitable)new StringT(""));
                    data.put("dictionary", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.stopword.ExtMessageStopwordDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block19;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToFieldDic(String file) {
        block19: {
            BufferedReader in = null;
            try {
                try {
                    StopwordDictionary dic = new StopwordDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        if (!line.trim().equals("")) {
                            dic.add(line.trim());
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(4);
                    data.put("collectionID", (Transmitable)new StringT(this.collection));
                    data.put("profileID", (Transmitable)new StringT(""));
                    data.put("fieldID", (Transmitable)new StringT(this.field));
                    data.put("dictionary", (Transmitable)dic);
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.stopword.ExtMessageStopwordDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block19;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToSystemDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    if ((line = line.trim()).length() > 0) {
                        StopwordDB.put((Connection)conn, null, null, null, (String)line);
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transTxtToCollectionDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    if (!line.trim().equals("")) {
                        String keyword = line.trim();
                        StopwordDB.put((Connection)conn, (String)this.collection, null, null, (String)keyword);
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transTxtToProfileDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    if (!line.trim().equals("")) {
                        String keyword = line.trim();
                        StopwordDB.put((Connection)conn, (String)this.collection, (String)this.profile, null, (String)keyword);
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transTxtToFieldDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    if (!line.trim().equals("")) {
                        String keyword = line.trim();
                        StopwordDB.put((Connection)conn, (String)this.collection, null, (String)this.field, (String)keyword);
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transSystemDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = new BufferedWriter(new FileWriter(file));
                int count = 0;
                Stopword[] stopwords = StopwordDB.getListSystem((Connection)conn, (String)"KEYWORD ASC");
                int i = 0;
                while (i < stopwords.length) {
                    Stopword stopword = stopwords[i];
                    out.write(String.valueOf(stopword.getKeyword()) + "\n");
                    ++count;
                    ++i;
                }
                out.flush();
                out.close();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transCollectionDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = new BufferedWriter(new FileWriter(file));
                int count = 0;
                Stopword[] stopwords = StopwordDB.getList((Connection)conn, (String)this.collection, null, (String)"KEYWORD ASC");
                int i = 0;
                while (i < stopwords.length) {
                    Stopword stopword = stopwords[i];
                    out.write(String.valueOf(stopword.getKeyword()) + "\n");
                    ++count;
                    ++i;
                }
                out.flush();
                out.close();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transProfileDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            conn = ConnectionFactory.getConnection();
            conn.setAutoCommit(false);
            out = new BufferedWriter(new FileWriter(file));
            int count = 0;
            if (this.profile == null) {
                System.out.println("Profile is null.");
                return;
            }
            try {
                Stopword[] stopwords = StopwordDB.getList((Connection)conn, (String)this.collection, (String)this.profile, (String)"KEYWORD ASC");
                int i = 0;
                while (i < stopwords.length) {
                    Stopword stopword = stopwords[i];
                    out.write(String.valueOf(stopword.getKeyword()) + "\n");
                    ++count;
                    ++i;
                }
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transFieldDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            conn = ConnectionFactory.getConnection();
            conn.setAutoCommit(false);
            out = new BufferedWriter(new FileWriter(file));
            int count = 0;
            if (this.field == null) {
                System.out.println("Field is null.");
                return;
            }
            try {
                Stopword[] stopwords = StopwordDB.getListFieldStopword((Connection)conn, (String)this.collection, (String)this.field, (String)"KEYWORD ASC");
                int i = 0;
                while (i < stopwords.length) {
                    Stopword stopword = stopwords[i];
                    out.write(String.valueOf(stopword.getKeyword()) + "\n");
                    ++count;
                    ++i;
                }
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) throws Exception {
        String fieldID;
        if (args.length < 7) {
            System.out.println("Not enough arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        int i = 0;
        while (i < args.length) {
            System.out.println("[" + i + "] " + args[i]);
            ++i;
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String profileID = args[3];
        if (profileID.equalsIgnoreCase("NULL")) {
            profileID = "";
        }
        if ((fieldID = args[4]).equalsIgnoreCase("NULL")) {
            fieldID = "";
        }
        int cmdType = Integer.parseInt(args[5]);
        String fileName = args[6];
        if (1 > cmdType || cmdType > 12) {
            System.out.println("Illegal type : " + cmdType + "\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            StopwordDicMaker_old cmd = new StopwordDicMaker_old(ip, port, collectionID, profileID, fieldID);
            switch (cmdType) {
                case 1: {
                    cmd.transTxtToSystemDic(fileName);
                    break;
                }
                case 2: {
                    cmd.transTxtToCollectionDic(fileName);
                    break;
                }
                case 3: {
                    cmd.transTxtToProfileDic(fileName);
                    break;
                }
                case 4: {
                    cmd.transTxtToFieldDic(fileName);
                    break;
                }
                case 5: {
                    cmd.transTxtToSystemDB(fileName);
                    break;
                }
                case 6: {
                    cmd.transTxtToCollectionDB(fileName);
                    break;
                }
                case 7: {
                    cmd.transTxtToProfileDB(fileName);
                    break;
                }
                case 8: {
                    cmd.transTxtToFieldDB(fileName);
                    break;
                }
                case 9: {
                    cmd.transSystemDBToTxt(fileName);
                    break;
                }
                case 10: {
                    cmd.transCollectionDBToTxt(fileName);
                    break;
                }
                case 11: {
                    cmd.transProfileDBToTxt(fileName);
                    break;
                }
                case 12: {
                    cmd.transFieldDBToTxt(fileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

