/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.profile.thesaurus.Thesaurus;
import com.diquest.ir.common.database.handler.dictionary.ThesaurusDB;
import com.diquest.ir.common.msg.dictionary.ThesaurusDictionary;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.ByteT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class ThesaurusDicMaker {
    public static StringBuffer help = new StringBuffer();
    public static final char SYSTEM = '1';
    public static final char USER_SYSTEM = '2';
    public static final char COLLECTION = '3';
    public static final char SINGLE_WAY = '1';
    public static final char MULTI_WAY = '2';
    private static final char DELIMETER_DB = ',';
    private static final char DELIMETER_FILE = ',';
    private static final char DELIMETER_DIC = '\t';
    private final String ip;
    private final int port;
    private final String collection;
    private final String profile;
    private final byte thesaurus;

    static {
        help.append("ThesaurusDicMaker : Import or export Thesaurus dictionary.\n");
        help.append("[IP] [Port] [collectionID] [profileID] [dictionary] [type] [filename]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("CollectionID : Target collection ID\n");
        help.append("ProfileID : Target profile ID\n");
        help.append("dictionary : EQUIV_SYNONYM, QUASI_SYNONYM \n");
        help.append("type : 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12\n");
        help.append("\t1 - text file => System Thesaurus dictionary. single-way(first keyword to the others.)\n");
        help.append("\t2 - text file => System Thesaurus dictionary. multi-way(each keyword to the others.)\n");
        help.append("\t3 - text file => User System Thesaurus dictionary. single-way(first keyword to the others.)\n");
        help.append("\t4 - text file => User System Thesaurus dictionary. multi-way(each keyword to the others.)\n");
        help.append("\t5 - text file => Collection(profile) Thesaurus dictionary. single-way(first keyword to the others.)\n");
        help.append("\t6 - text file => Collection(profile) Thesaurus dictionary. multi-way(each keyword to the others.)\n");
        help.append("\t7 - text file => User System Thesaurus dictionary RDBMS table(PREFIX_SYNONYM). single-way(first keyword to the others.)\n");
        help.append("\t8 - text file => User System Thesaurus dictionary RDBMS table(PREFIX_SYNONYM). multi-way(each keyword to the others.)\n");
        help.append("\t9 - text file => Collection(profile) Thesaurus dictionary RDBMS table(PREFIX_SYNONYM). single-way(first keyword to the others.)\n");
        help.append("\t10 - text file => Collection(profile) Thesaurus dictionary RDBMS table(PREFIX_SYNONYM). multi-way(each keyword to the others.)\n");
        help.append("\t11 - User System Thesaurus dictionary RDBMS table(PREFIX_SYNONYM) => text file\n");
        help.append("\t12 - Collection(profile) Thesaurus dictionary RDBMS table(PREFIX_SYNONYM). => text file\n");
        help.append("filename : Thesaurus Dictionary text file path\n");
        help.append("(text file : thesaurus set for each line, ex) keyword,thesaurus,thesaurus)\n\n");
        help.append("<notice>\n");
        help.append("Type 1, 2, 3, 4, 5, 6 does not execute this process but register task to server. Server must be alive.\n");
        help.append("System Thesaurus dictionary : preserve only binary format. Does not store to RDBMS\n");
        help.append("User System Thesaurus dictionary : does not subordinate to collection, can be inherited by any collection.\n");
        help.append("Collection(profile) Thesaurus dictionary : subordinated to collection or profile.\n");
        help.append("When expand Thesaurus, use both System Thesaurus dictionary and {User System Thesaurus dictionary or Collection(profile) Thesaurus dictionary}.\n");
        help.append("When expand Thesaurus, expand Thesaurus using {User System Thesaurus dictionary or Collection(profile) Thesaurus dictionary} first.\n");
        help.append("If there is no expanded Thesauruss, expand Thesaurus using System Thesaurus Dictionary.\n");
    }

    public ThesaurusDicMaker(String ip, int port, String collection, String profile, byte thesaurus) {
        this.ip = ip;
        this.port = port;
        this.collection = StringUtil.isEmpty((String)collection) ? "" : collection;
        this.profile = StringUtil.isEmpty((String)profile) ? "" : profile;
        this.thesaurus = thesaurus;
    }

    public void transTxtToSystemDic(String file) {
        this.transTxtToDic(file, '1', '1');
    }

    public void transAllTxtToSystemDic(String file) {
        this.transTxtToDic(file, '1', '2');
    }

    public void transTxtToUserSystemDic(String file) {
        this.transTxtToDic(file, '2', '1');
    }

    public void transAllTxtToUserSystemDic(String file) {
        this.transTxtToDic(file, '2', '2');
    }

    public void transTxtToCollectionDic(String file) {
        this.transTxtToDic(file, '3', '1');
    }

    public void transAllTxtToCollectionDic(String file) {
        this.transTxtToDic(file, '3', '2');
    }

    public void transTxtToUserSystemDB(String file) {
        this.transTxtToDB(file, '2', '1');
    }

    public void transAllTxtToUserSystemDB(String file) {
        this.transTxtToDB(file, '2', '2');
    }

    public void transTxtToCollectionDB(String file) {
        this.transTxtToDB(file, '3', '1');
    }

    public void transAllTxtToCollectionDB(String file) {
        this.transTxtToDB(file, '3', '2');
    }

    public void transUserSystemDBToTxt(String file) {
        this.transDBToTxt(file, '2');
    }

    public void transCollectionDBToTxt(String file) {
        this.transDBToTxt(file, '3');
    }

    public void transTxtToDic(String file, char type, char way) {
        block29: {
            BufferedReader in = null;
            try {
                try {
                    ThesaurusDictionary dic = new ThesaurusDictionary(16384);
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    while (line != null && line.length() > 0) {
                        List list = this.makeList(line);
                        String value = "";
                        if (list.size() > 1) {
                            switch (way) {
                                case '1': {
                                    value = this.makeDicInput(list, 0);
                                    dic.add((String)list.get(0), value.toCharArray(), 0, value.length());
                                    ++count;
                                    break;
                                }
                                case '2': {
                                    int i = 0;
                                    while (i < list.size()) {
                                        value = this.makeDicInput(list, i);
                                        dic.add((String)list.get(i), value.toCharArray(), 0, value.length());
                                        ++count;
                                        ++i;
                                    }
                                    break;
                                }
                            }
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(5);
                    switch (type) {
                        case '1': {
                            data.put("isSystem", (Transmitable)new BooleanT(true));
                            data.put("collectionID", (Transmitable)new StringT(""));
                            data.put("profileID", (Transmitable)new StringT(""));
                            data.put("thesaurusID", (Transmitable)new ByteT(this.thesaurus));
                            data.put("dictionary", (Transmitable)dic);
                            break;
                        }
                        case '2': {
                            data.put("isSystem", (Transmitable)new BooleanT(false));
                            data.put("collectionID", (Transmitable)new StringT(""));
                            data.put("profileID", (Transmitable)new StringT(""));
                            data.put("thesaurusID", (Transmitable)new ByteT(this.thesaurus));
                            data.put("dictionary", (Transmitable)dic);
                            break;
                        }
                        case '3': {
                            data.put("isSystem", (Transmitable)new BooleanT(false));
                            data.put("collectionID", (Transmitable)new StringT(this.collection));
                            data.put("profileID", (Transmitable)new StringT(this.profile));
                            data.put("thesaurusID", (Transmitable)new ByteT(this.thesaurus));
                            data.put("dictionary", (Transmitable)dic);
                            break;
                        }
                    }
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.thesaurus.ExtMessageThesaurusDicApply", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " is imported");
                        break block29;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDB(String file, char type, char way) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                if (type == '2' || StringUtil.isEmpty((String)this.collection)) {
                    ThesaurusDB.deleteSystemThesaurus((Connection)conn, (byte)this.thesaurus);
                } else if (StringUtil.isEmpty((String)this.profile)) {
                    ThesaurusDB.deleteCollection((Connection)conn, (String)this.collection, (byte)this.thesaurus);
                } else {
                    ThesaurusDB.deleteProfile((Connection)conn, (String)this.collection, (String)this.profile, (byte)this.thesaurus);
                }
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                int _count = 0;
                while (line != null && line.length() > 0) {
                    ++_count;
                    String[] tokens = ThesaurusDB.makeThesaurusList((String)line);
                    if (tokens.length > 1) {
                        String keyword = tokens[0];
                        String[] keywords = new String[tokens.length - 1];
                        System.arraycopy(tokens, 1, keywords, 0, tokens.length - 1);
                        try {
                            if (type == '2' && way == '1') {
                                ThesaurusDB.put((Connection)conn, null, null, (byte)this.thesaurus, (String)keyword, (String[])keywords);
                            }
                            if (type == '2' && way == '2') {
                                ThesaurusDB.putFullDuplex((Connection)conn, null, null, (byte)this.thesaurus, (String)keyword, (String[])keywords);
                            }
                            if (type == '3' && way == '1') {
                                ThesaurusDB.put((Connection)conn, (String)this.collection, (String)this.profile, (byte)this.thesaurus, (String)keyword, (String[])keywords);
                            }
                            if (type == '3' && way == '2') {
                                ThesaurusDB.putFullDuplex((Connection)conn, (String)this.collection, (String)this.profile, (byte)this.thesaurus, (String)keyword, (String[])keywords);
                            }
                            ++count;
                        }
                        catch (SQLException e) {
                            System.out.println(String.valueOf(e.getMessage()) + " [error_string: " + keyword + "] [error_line: " + _count + "]");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transDBToTxt(String file, char type) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = FileUtil.getBufferedWriter((String)file);
                int count = 0;
                Thesaurus[] thesauruses = null;
                switch (type) {
                    case '2': {
                        thesauruses = ThesaurusDB.getList((Connection)conn, null, null, (byte)this.thesaurus, (String)"KEYWORD ASC");
                        break;
                    }
                    case '3': {
                        thesauruses = ThesaurusDB.getList((Connection)conn, (String)this.collection, (String)this.profile, (byte)this.thesaurus, (String)"KEYWORD ASC");
                    }
                }
                int i = 0;
                while (i < thesauruses.length) {
                    Thesaurus thesaurus = thesauruses[i];
                    out.write(String.valueOf(thesaurus.getKeyword()) + ',' + ThesaurusDB.makeThesaurusList((String[])thesaurus.getKeywords()) + "\n");
                    ++count;
                    ++i;
                }
                out.flush();
                out.close();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private List makeList(String sequence) {
        ArrayList<String> list = new ArrayList<String>();
        char[] arr = sequence.toCharArray();
        int prevPos = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == ',') {
                list.add(StringUtil.removeWhitespaces((String)new String(arr, prevPos, i - prevPos).toUpperCase()));
                prevPos = i + 1;
            }
            ++i;
        }
        list.add(StringUtil.removeWhitespaces((String)new String(arr, prevPos, arr.length - prevPos).toUpperCase()));
        return this.refine(list);
    }

    private List refine(List list) {
        LinkedHashSet set = new LinkedHashSet(list);
        if (set.size() == list.size()) {
            return list;
        }
        list.clear();
        list.addAll(set);
        return list;
    }

    private String makeInput(List list, int index) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < index) {
            buf.append(StringUtil.removeWhitespaces((String)((String)list.get(i))).toUpperCase());
            buf.append(',');
            ++i;
        }
        i = index + 1;
        while (i < list.size()) {
            buf.append(StringUtil.removeWhitespaces((String)((String)list.get(i))).toUpperCase());
            buf.append(',');
            ++i;
        }
        return new String(buf.toString().substring(0, buf.toString().length() - 1));
    }

    private String makeDicInput(List list, int index) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < index) {
            buf.append(StringUtil.removeWhitespaces((String)((String)list.get(i))).toUpperCase());
            buf.append('\t');
            ++i;
        }
        i = index + 1;
        while (i < list.size()) {
            buf.append(StringUtil.removeWhitespaces((String)((String)list.get(i))).toUpperCase());
            buf.append('\t');
            ++i;
        }
        if (buf == null) {
            System.out.println("empty");
            return "";
        }
        return new String(buf.toString().substring(0, buf.toString().length() - 1));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            System.out.println("Not enough arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String profileID = args[3];
        if ("NULL".equalsIgnoreCase(collectionID) || "*".equals(collectionID)) {
            collectionID = "";
        }
        if ("NULL".equalsIgnoreCase(profileID) || "*".equals(profileID)) {
            profileID = "";
        }
        String thesaurusName = args[4];
        byte thesaurusID = 0;
        int cmdType = Integer.parseInt(args[5]);
        String fileName = args[6];
        if (1 > cmdType || cmdType > 12) {
            System.out.println("Illegal type : " + cmdType + "\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        if (thesaurusName.equalsIgnoreCase("EQUIV_SYNONYM")) {
            thesaurusID = cmdType >= 1 && cmdType < 3 || cmdType >= 5 && cmdType < 7 ? (byte)2 : 1;
        } else if (thesaurusName.equalsIgnoreCase("QUASI_SYNONYM")) {
            thesaurusID = cmdType >= 1 && cmdType < 3 || cmdType >= 5 && cmdType < 7 ? (byte)8 : 4;
        } else {
            System.out.println("Illegal dic type : " + thesaurusName + "\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            ThesaurusDicMaker cmd = new ThesaurusDicMaker(ip, port, collectionID, profileID, thesaurusID);
            switch (cmdType) {
                case 1: {
                    cmd.transTxtToSystemDic(fileName);
                    break;
                }
                case 2: {
                    cmd.transAllTxtToSystemDic(fileName);
                    break;
                }
                case 3: {
                    cmd.transTxtToUserSystemDic(fileName);
                    break;
                }
                case 4: {
                    cmd.transAllTxtToUserSystemDic(fileName);
                    break;
                }
                case 5: {
                    cmd.transTxtToCollectionDic(fileName);
                    break;
                }
                case 6: {
                    cmd.transAllTxtToCollectionDic(fileName);
                    break;
                }
                case 7: {
                    cmd.transTxtToUserSystemDB(fileName);
                    break;
                }
                case 8: {
                    cmd.transAllTxtToUserSystemDB(fileName);
                    break;
                }
                case 9: {
                    cmd.transTxtToCollectionDB(fileName);
                    break;
                }
                case 10: {
                    cmd.transAllTxtToCollectionDB(fileName);
                    break;
                }
                case 11: {
                    cmd.transUserSystemDBToTxt(fileName);
                    break;
                }
                case 12: {
                    cmd.transCollectionDBToTxt(fileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

