/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.util.common.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ThesaurusDicMerger {
    public static StringBuffer help = new StringBuffer();
    private static final String NEWLINE;
    private static final String THESARUS_DELIM = ",";
    private static final String QUASI = "-q";
    private static final String EQUIV = "-e";
    private static final String ENCODING = "-t";
    private String delim;
    private Map keyMap;
    private Map dataMap;
    private Map keyCandidate;
    private int lastKey;

    static {
        help.append("ThesaurusDicMerger : Merge input files into a result file.\n");
        help.append("Usage: ThesaurusDicMerger [type of thesaurus] [type of encoding set -t(optional)] [encoding type(optional)] [delimiter] [input file1] ... [input fileN]\n\n");
        help.append("Type of thesaurus(-q or -e):\n");
        help.append("\t-q - Quasi synonym(\uc720\uc758\uc5b4)\n");
        help.append("\t-e - Equiv synonym(\ub3d9\uc758\uc5b4)\n");
        help.append("Encoding type for result file(-t encoding type): A result file is encoded if you write encoding type(optional). Default encoding type is system encoding. \n");
        help.append("Delimiter: Delimiter of input files. It must be same in all of input files. \n");
        help.append("Input files: Write file names as much as you want to merge");
        NEWLINE = System.getProperty("line.separator");
    }

    public ThesaurusDicMerger(String delim) {
        this.delim = delim;
        this.keyMap = new HashMap();
        this.dataMap = new HashMap();
        this.keyCandidate = new HashMap();
        this.lastKey = 0;
    }

    public void mergeFiles(String resultFile, List inputFiles) {
        int i = 0;
        while (i < inputFiles.size()) {
            System.out.println("Read file[" + inputFiles.get(i) + "]...");
            this.readFile((String)inputFiles.get(i));
            ++i;
        }
        System.out.println("Write file...");
        this.writeFile(resultFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFile(String resultFile) {
        BufferedWriter bw = null;
        try {
            try {
                bw = FileUtil.getBufferedWriter((String)resultFile);
                this.writeData(bw);
                bw.flush();
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (bw == null) return;
                try {
                    bw.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (bw == null) return;
                try {
                    bw.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void writeData(BufferedWriter bw) {
        int cnt = 0;
        int total = 0;
        Iterator iter = this.dataMap.values().iterator();
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            LinkedHashSet dataList = (LinkedHashSet)iter.next();
            total += this.makeBidirectData(dataList, sb);
            try {
                bw.write(sb.toString());
                sb.setLength(0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (++cnt % 10000 != 0) continue;
            System.out.println(String.valueOf(cnt) + " words were written.");
        }
        System.out.println("The number of total thesarus : " + cnt);
        System.out.println("The number of total word : " + total);
    }

    private int makeBidirectData(LinkedHashSet dataList, StringBuffer sb) {
        int dataSize = dataList.size();
        int[] startPos = new int[dataSize];
        int[] endPos = new int[dataSize];
        StringBuffer result = new StringBuffer();
        Iterator dataIter = dataList.iterator();
        int i = 0;
        while (dataIter.hasNext()) {
            String data = (String)dataIter.next();
            if (result.length() > 0) {
                startPos[i] = result.length() + 1;
                endPos[i] = result.length();
                result.append(THESARUS_DELIM);
            } else {
                startPos[i] = 0;
                endPos[i] = 0;
            }
            result.append(data);
            ++i;
        }
        char[] resultChars = result.toString().toCharArray();
        int i2 = 0;
        while (i2 < dataSize) {
            sb.append(resultChars, startPos[i2], resultChars.length - startPos[i2]);
            if (startPos[i2] != endPos[i2]) {
                sb.append(THESARUS_DELIM).append(resultChars, 0, endPos[i2]);
            }
            sb.append(NEWLINE);
            ++i2;
        }
        return dataSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readFile(String inputFile) {
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "utf-8"));
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.makeData(line);
                }
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (br == null) return;
                try {
                    br.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (br == null) return;
                try {
                    br.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void makeData(String line) {
        String[] input = line.split(this.delim);
        Integer key = null;
        boolean hasKey = false;
        int i = 0;
        while (i < input.length) {
            if (this.keyMap.containsKey(input[i])) {
                key = (Integer)this.keyMap.get(input[i]);
                hasKey = true;
                this.keyCandidate.put(key, input[i]);
            }
            ++i;
        }
        if (!hasKey) {
            key = new Integer(this.lastKey++);
        }
        i = 0;
        while (i < input.length) {
            this.keyMap.put(input[i], key);
            ++i;
        }
        LinkedHashSet dataList = null;
        if (this.dataMap.containsKey(key)) {
            dataList = (LinkedHashSet)this.dataMap.get(key);
        } else {
            dataList = new LinkedHashSet();
            this.dataMap.put(key, dataList);
        }
        int i2 = 0;
        while (i2 < input.length) {
            dataList.add(input[i2]);
            ++i2;
        }
        this.mergeData(key);
    }

    private void mergeData(Integer key) {
        if (this.keyCandidate.size() > 1) {
            LinkedHashSet dataList = (LinkedHashSet)this.dataMap.get(key);
            Iterator iter = this.keyCandidate.keySet().iterator();
            while (iter.hasNext()) {
                Integer beforeKey = (Integer)iter.next();
                if (key.intValue() == beforeKey.intValue()) continue;
                String data = (String)this.keyCandidate.get(beforeKey);
                this.keyMap.put(data, key);
                LinkedHashSet beforeData = (LinkedHashSet)this.dataMap.remove(beforeKey);
                dataList.addAll(beforeData);
            }
        }
        this.keyCandidate.clear();
    }

    public static void checkParam(String[] inputs) {
        if (inputs.length < 3) {
            System.out.println("Not enough arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        if (!inputs[0].equalsIgnoreCase(QUASI) && !inputs[0].equalsIgnoreCase(EQUIV)) {
            System.out.println("invalid thesaurus type.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        if (inputs[1].equalsIgnoreCase(ENCODING) && inputs.length < 5) {
            System.out.println(help.toString());
            System.exit(-1);
        }
    }

    public static String getResultFilename(String[] inputs) {
        if (inputs[1].equalsIgnoreCase(ENCODING)) {
            if (inputs[0].equalsIgnoreCase(QUASI)) {
                return "quasiSynonym." + inputs[2];
            }
            return "equivSynonym." + inputs[2];
        }
        if (inputs[0].equalsIgnoreCase(QUASI)) {
            return "quasiSynonym.txt";
        }
        return "equivSynonym.txt";
    }

    private static String getDelimiter(String[] inputs) {
        if (inputs[1].equalsIgnoreCase(ENCODING)) {
            return inputs[3];
        }
        return inputs[1];
    }

    private static int getStartIdx(String[] inputs) {
        if (inputs[1].equalsIgnoreCase(ENCODING)) {
            return 4;
        }
        return 2;
    }

    public static void main(String[] args) {
        ThesaurusDicMerger.checkParam(args);
        String resultFile = ThesaurusDicMerger.getResultFilename(args);
        String delim = ThesaurusDicMerger.getDelimiter(args);
        int startIdx = ThesaurusDicMerger.getStartIdx(args);
        ArrayList<String> files = new ArrayList<String>();
        int i = startIdx;
        while (i < args.length) {
            files.add(args[i]);
            ++i;
        }
        ThesaurusDicMerger merger = new ThesaurusDicMerger(delim);
        merger.mergeFiles(resultFile, files);
    }
}

