/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.dicmaker;

import com.diquest.ir.client.apps.dicmaker.UserDicMaker;
import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.profile.usercndic.UserCnDic;
import com.diquest.ir.common.database.handler.dictionary.UserCnDicDB;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.IntegerT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.sql.Connection;

public class UserCnDicMaker {
    public static StringBuffer help = new StringBuffer();
    private final String ip;
    private final int port;
    private String userid;

    static {
        help.append("UserCnDicMaker : Import or export user compound noun dictionary.\n");
        help.append("(type 1) [IP] [Port] [type] [filename] [userid]\n");
        help.append("(type 2,3) [IP] [Port] [type] [filename]\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port\n");
        help.append("type : 1, 2, 3\n");
        help.append("\t1 - text file => User Compound Noun Dictionary \n");
        help.append("\t2 - text file => User Compound Noun Dictionary RDBMS table (PREFIX_USER_CNDIC)\n");
        help.append("\t3 - RDBMS table => text file\n");
        help.append("filename : text user compound noun dictionary file path\n");
        help.append("(text file : term for each line)\n\n");
        help.append("userid : user id of mariner management tool\n");
        help.append("<notice>\n");
        help.append("Type 1, not execute this process but register task to server. Server must be alive.\n");
    }

    private void setUserID(String id) {
        this.userid = id;
    }

    public UserCnDicMaker(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public void transTxtToDic(String file) {
        block19: {
            BufferedReader in = null;
            try {
                try {
                    in = FileUtil.getBufferedReader((String)file);
                    String line = in.readLine();
                    int count = 0;
                    StringBuffer sb = new StringBuffer();
                    while (line != null) {
                        String keyword = StringUtil.removeWhitespaces((String)line);
                        if (keyword.length() > 0) {
                            sb.append(String.valueOf(keyword) + "\n");
                            ++count;
                        }
                        line = in.readLine();
                    }
                    in.close();
                    DataT data = new DataT(1);
                    data.put("dic", (Transmitable)new StringT(sb.toString()));
                    data.put("ip", (Transmitable)new StringT(this.ip));
                    data.put("port", (Transmitable)new IntegerT(this.port));
                    data.put("userid", (Transmitable)new StringT(this.userid));
                    ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.usercndic.ExtMessageNetApplyUserCnDic", (Transmitable)data);
                    ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
                    if (response.getErrorCode() > 0) {
                        System.out.println("Success : " + count + " will be imported.");
                        break block19;
                    }
                    System.out.println("Failed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void transTxtToDB(String file) {
        BufferedReader in = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                in = FileUtil.getBufferedReader((String)file);
                String line = in.readLine();
                int count = 0;
                while (line != null && line.length() > 0) {
                    String keyword = StringUtil.removeWhitespaces((String)line);
                    if (keyword.length() > 0) {
                        UserCnDicDB.put((Connection)conn, (String)keyword);
                        ++count;
                    }
                    line = in.readLine();
                }
                conn.commit();
                System.out.println("Success : " + count + " is imported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void transDBToTxt(String file) {
        BufferedWriter out = null;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                conn.setAutoCommit(false);
                out = FileUtil.getBufferedWriter((String)file);
                int count = 0;
                UserCnDic[] dics = UserCnDicDB.getList((Connection)conn, (String)"KEYWORD ASC");
                int i = 0;
                while (i < dics.length) {
                    out.write(String.valueOf(dics[i].getKeyword()) + "\n");
                    ++count;
                    ++i;
                }
                out.flush();
                out.close();
                System.out.println("Success : " + count + " is exported");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Not enough argument.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        int cmdType = Integer.parseInt(args[2]);
        String fileName = args[3];
        if (1 > cmdType || cmdType > 3) {
            System.out.println("Illegal type : " + cmdType + "\n");
            System.out.println(help.toString());
            System.exit(-1);
        } else if (cmdType == 1 && args.length < 5) {
            System.out.println("Not enough argument of cmdType[" + cmdType + "].\n");
            System.out.println(UserDicMaker.help.toString());
            System.exit(-1);
        }
        System.out.println("start...");
        try {
            UserCnDicMaker cmd = new UserCnDicMaker(ip, port);
            switch (cmdType) {
                case 1: {
                    cmd.setUserID(args[4]);
                    cmd.transTxtToDic(fileName);
                    break;
                }
                case 2: {
                    cmd.transTxtToDB(fileName);
                    break;
                }
                case 3: {
                    cmd.transDBToTxt(fileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }
}

