/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.stress;

import com.diquest.ir.client.apps.stress.QuerySetMaker;
import com.diquest.ir.client.apps.stress.StressMaker;
import com.diquest.ir.client.command.CommandSearchRequest;
import com.diquest.ir.common.msg.protocol.query.QuerySet;

class SearchThread
extends Thread {
    private int id;
    private QuerySetMaker maker;
    public long elipsedTime = 0L;
    public long maxElipsedTime = 0L;
    public int errorCount = 0;

    public SearchThread(int id, QuerySetMaker maker) {
        this.id = id;
        this.maker = maker;
        this.setName("SearchThread(" + id + ")");
    }

    public void run() {
        try {
            while (true) {
                String keyword;
                if ((keyword = StressMaker.nextKeyword()) == null) {
                    System.out.println("Keyword is null, " + this.getName());
                    break;
                }
                QuerySet query = this.maker.getQuerySet(keyword);
                if (query == null) {
                    System.out.println(String.valueOf(this.getName()) + " Query is null");
                } else {
                    CommandSearchRequest.setProps(StressMaker.IP, StressMaker.PORT, 10000, StressMaker.connectionNum, StressMaker.connectionNum);
                    CommandSearchRequest request = new CommandSearchRequest(StressMaker.IP, StressMaker.PORT);
                    long start = System.currentTimeMillis();
                    int res = request.request(query);
                    long elipsed = System.currentTimeMillis() - start;
                    this.elipsedTime += elipsed;
                    if (elipsed > this.maxElipsedTime) {
                        this.maxElipsedTime = elipsed;
                    }
                    if (res < 0) {
                        ++this.errorCount;
                    }
                    if (StressMaker.debugLevel >= 1) {
                        if (res < 0) {
                            System.out.println(String.valueOf(this.getName()) + " #ERROR#");
                        } else {
                            int totalSize = request.getResultSet().getResult(0).getTotalSize();
                            System.out.println("[" + elipsed + "\t" + keyword + "(" + totalSize + ")]");
                        }
                    }
                }
                Thread.sleep(StressMaker.threadSleep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(String.valueOf(this.getName()) + " terminated.");
        }
    }
}

