/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps.stress;

import com.diquest.ir.client.apps.stress.QuerySetMaker;
import com.diquest.ir.client.apps.stress.StressMaker2;
import com.diquest.ir.client.command.CommandSearchRequest;
import com.diquest.ir.common.msg.protocol.query.QuerySet;

class SearchThread2
extends Thread {
    private int id;
    private QuerySetMaker maker;
    public long elipsedTime = 0L;

    public SearchThread2(int id, QuerySetMaker maker) {
        this.id = id;
        this.maker = maker;
        this.setName("SearchThread2(" + id + ")");
    }

    public void run() {
        try {
            String keyword;
            while ((keyword = StressMaker2.nextKeyword()) != null) {
                QuerySet query = this.maker.getQuerySet(keyword);
                if (query == null) {
                    System.out.println(String.valueOf(this.getName()) + " Query is null");
                } else {
                    CommandSearchRequest.setProps(StressMaker2.IP, StressMaker2.PORT, 10000, StressMaker2.connectionNum, StressMaker2.connectionNum);
                    CommandSearchRequest request = new CommandSearchRequest(StressMaker2.IP, StressMaker2.PORT);
                    long start = System.currentTimeMillis();
                    int res = request.request(query);
                    long elipsed = System.currentTimeMillis() - start;
                    this.elipsedTime += elipsed;
                    if (StressMaker2.debugLevel >= 1) {
                        if (res < 0) {
                            System.out.println(String.valueOf(this.getName()) + " #ERROR#");
                        } else {
                            int totalSize = request.getResultSet().getResult(0).getTotalSize();
                            System.out.println("[" + elipsed + "\t" + keyword + "(" + totalSize + ")]");
                        }
                    }
                }
                Thread.sleep(StressMaker2.threadSleep);
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.getName()) + " terminated.");
        }
    }
}

