/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.chart;

import com.diquest.ir.client.chart.ChartData;
import java.util.List;

public class ChartXmlMaker {
    public static String getChartXml(ChartData data) {
        int i;
        StringBuffer searchChartXML2 = new StringBuffer();
        String xMaxCnt = data.getMaxWidthCnt();
        String xAxisName = ChartXmlMaker.xmlchartChar(data.getxAxisName());
        String yAxisName = ChartXmlMaker.xmlchartChar(data.getyAxisName());
        List seriesName = data.getSeriesNames();
        List categoryUnit = data.getUnit();
        String plotSpace = ChartXmlMaker.getPlotSpace(categoryUnit.size());
        List labelList = data.getLabelLists();
        List colorSet = data.getColorList();
        int seriesSize = data.getSeriesSize();
        searchChartXML2.append("<chart numVisiblePlot='").append(xMaxCnt).append("' caption='' xAxisName='").append(xAxisName).append("' yAxisName='").append(yAxisName).append("' decimals='0' formatNumberScale='0' showValues='0' bgColor='FFFFFF' borderColor='FFFFFF'").append(" outCnvBaseFont='arial' outCnvBaseFontSize='11' canvasBorderColor='A0A0A0' canvasBorderThickness='2'").append(" baseFontColor='A0A0A0' useRoundEdges='1' showShadow='1' showPlotBorder='1' lineThickness='4'plotSpacePercent='").append(plotSpace).append("'>");
        searchChartXML2.append("<categories>");
        if (categoryUnit.size() < 1) {
            searchChartXML2.append("<category label='").append("-").append("' />");
        } else {
            i = 0;
            int end = categoryUnit.size();
            while (i < end) {
                String unit = (String)categoryUnit.get(i);
                searchChartXML2.append("<category label='").append(ChartXmlMaker.xmlchartChar(unit)).append("' />");
                ++i;
            }
        }
        searchChartXML2.append("</categories>");
        if (seriesSize > 0) {
            i = 0;
            while (i < seriesSize) {
                List label = (List)labelList.get(i);
                searchChartXML2.append("<dataset ");
                if (seriesName != null) {
                    searchChartXML2.append("seriesName='").append(ChartXmlMaker.xmlchartChar((String)seriesName.get(i))).append("' ");
                }
                if (colorSet.size() < 1) {
                    searchChartXML2.append("borderColor='FFFFFF' color='").append("FFFFFF").append("' >");
                } else {
                    searchChartXML2.append("borderColor='FFFFFF' color='").append(colorSet.get(i)).append("' >");
                }
                int j = 0;
                int end = label.size();
                while (j < end) {
                    String labelValue = (String)label.get(j);
                    searchChartXML2.append("<set value='").append(ChartXmlMaker.xmlchartChar(labelValue)).append("' />");
                    ++j;
                }
                searchChartXML2.append("</dataset>");
                ++i;
            }
        } else {
            searchChartXML2.append("<dataset ");
            searchChartXML2.append("borderColor='FFFFFF' color='").append("FFFFFF").append("' >");
            searchChartXML2.append("<set value='").append("0.0").append("' />");
            searchChartXML2.append("</dataset>");
        }
        searchChartXML2.append("</chart>");
        return searchChartXML2.toString();
    }

    private static String getPlotSpace(int size) {
        if (size == 0) {
            return "80";
        }
        if (size == 1) {
            return "80";
        }
        if (size == 2) {
            return "70";
        }
        if (size == 3) {
            return "60";
        }
        if (size == 4) {
            return "50";
        }
        if (size == 5) {
            return "40";
        }
        if (size == 6) {
            return "30";
        }
        if (size == 7) {
            return "20";
        }
        return "10";
    }

    private static String xmlchartChar(String str) {
        if (str == null) {
            return "";
        }
        char[] charArr = str.toCharArray();
        int len = charArr.length;
        StringBuffer strB = new StringBuffer();
        int i = 0;
        while (i < len) {
            switch (charArr[i]) {
                case '<': {
                    strB = strB.append("%26lt;");
                    break;
                }
                case '>': {
                    strB = strB.append("%26gt;");
                    break;
                }
                case '&': {
                    strB = strB.append("%26amp;");
                    break;
                }
                case '\"': {
                    strB = strB.append("%26quot;");
                    break;
                }
                default: {
                    strB = strB.append(charArr[i]);
                }
            }
            ++i;
        }
        return strB.toString();
    }
}

