/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.chart;

import com.diquest.ir.common.msg.status.MemoryStatus;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MemoryChart {
    public static final int SECONDLY = 0;
    public static final int MINUTELY = 1;
    public static final int HOURLY = 2;
    private static final int[] CHART;
    private static final int[] slots;
    private static final int USED_MEM = 0;
    private static final int MAX_USED_MEM = 1;
    private static final int CURR_MEM = 2;
    private static final int MAX_MEM = 3;
    private static final String[] LABEL;
    private static final Color[] COLORS;
    private static final int[][] SERIESES;
    static MemoryChart singleton;
    JFreeChart[] charts = new JFreeChart[CHART.length];
    XYSeries[][] series = new XYSeries[CHART.length][];
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        CHART = nArray;
        slots = new int[]{60, 60, 24};
        LABEL = new String[]{"Used", "Max-Used", "Current", "Max"};
        COLORS = new Color[]{Color.blue, new Color(1.0f, 0.0f, 0.0f, 0.65f), Color.green, new Color(0.85f, 0.85f, 0.85f, 0.75f)};
        int[][] nArrayArray = new int[3][];
        int[] nArray2 = new int[3];
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        nArrayArray[1] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 3;
        nArrayArray[2] = nArray4;
        SERIESES = nArrayArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryChart getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.client.chart.MemoryChart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (singleton == null) {
                singleton = new MemoryChart();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private MemoryChart() {
        int c = 0;
        while (c < CHART.length) {
            this.series[c] = new XYSeries[SERIESES[c].length];
            ++c;
        }
        this.charts[0] = this.createChart("60 Seconds Memory Chart", 0, "Second Passed");
        this.charts[1] = this.createChart("60 Minutes Memory Chart", 1, "Minute Passed");
        this.charts[2] = this.createChart("24 Hours Memory Chart", 2, "Hour Passed");
        this.initDataset();
    }

    private JFreeChart createChart(String title, int chartType, String domainLabel) {
        int[] SERIES = SERIESES[chartType];
        int s = 0;
        while (s < SERIES.length) {
            this.series[chartType][s] = new XYSeries((Comparable)((Object)LABEL[SERIES[s]]));
            this.series[chartType][s].setMaximumItemCount(slots[chartType]);
            ++s;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        int s2 = 0;
        while (s2 < SERIES.length) {
            dataset.addSeries(this.series[chartType][s2]);
            ++s2;
        }
        NumberAxis domain = new NumberAxis(domainLabel);
        domain.setLowerMargin(0.0);
        domain.setUpperMargin(0.0);
        domain.setTickLabelsVisible(true);
        NumberAxis range = new NumberAxis("Memory in Megabytes");
        range.setAutoRangeMinimumSize(32.0);
        range.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        range.setAutoRangeStickyZero(true);
        XYAreaRenderer renderer = new XYAreaRenderer(4);
        int s3 = 0;
        while (s3 < SERIES.length) {
            renderer.setSeriesPaint(s3, (Paint)COLORS[SERIES[s3]]);
            ++s3;
        }
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)domain, (ValueAxis)range, (XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    public void getChartAsPNG(int index, File file, int width, int height) throws IOException {
        if (index < 0 || index >= CHART.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (file == null) {
            throw new NullPointerException("Null file cannot be allowed.");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height should be larger than 0.");
        }
        ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.charts[index], (int)width, (int)height);
    }

    private void initDataset() {
        int s;
        int c = 0;
        while (c < CHART.length) {
            s = 0;
            while (s < SERIESES[c].length) {
                XYSeries currentSeries = this.series[c][s];
                currentSeries.clear();
                int d = 0;
                while (d < slots[c]) {
                    currentSeries.add((double)d, 0.0, false);
                    ++d;
                }
                ++s;
            }
            ++c;
        }
        c = 0;
        while (c < CHART.length) {
            s = 0;
            while (s < SERIESES[c].length) {
                this.series[c][s].fireSeriesChanged();
                ++s;
            }
            ++c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(MemoryStatus status) {
        MemoryChart memoryChart = this;
        synchronized (memoryChart) {
            int s;
            if (status == null) {
                throw new IllegalArgumentException("Status cannot be null.");
            }
            long[][][] data = new long[][][]{status.getSec(), status.getMin(), status.getHour()};
            int c = 0;
            while (c < CHART.length) {
                s = 0;
                while (s < SERIESES[c].length) {
                    XYSeries currentSeries = this.series[c][s];
                    currentSeries.clear();
                    long[] dat = null;
                    switch (SERIESES[c][s]) {
                        case 3: {
                            dat = data[c][MemoryStatus.getMaxIndex()];
                            break;
                        }
                        case 2: {
                            dat = data[c][MemoryStatus.getCurrIndex()];
                            break;
                        }
                        case 0: {
                            dat = data[c][MemoryStatus.getUsedIndex()];
                            break;
                        }
                        case 1: {
                            dat = data[c][MemoryStatus.getMaxUsedIndex()];
                        }
                    }
                    int d = 0;
                    while (d < dat.length) {
                        currentSeries.add((double)d, (double)(dat[d] / 0x100000L), false);
                        ++d;
                    }
                    ++s;
                }
                ++c;
            }
            c = 0;
            while (c < CHART.length) {
                s = 0;
                while (s < SERIESES[c].length) {
                    this.series[c][s].fireSeriesChanged();
                    ++s;
                }
                ++c;
            }
        }
    }
}

