/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.chart;

import com.diquest.ir.common.msg.status.QueryStatus;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class QueryCountChart {
    public static final int SECONDLY = 0;
    public static final int MINUTELY = 1;
    public static final int HOURLY = 2;
    private static final int[] CHART;
    private static final int QUERY_COUNT = 0;
    private static final int AVERAGE_COUNT = 1;
    private static final int MAX_COUNT = 2;
    private static final String[] LABEL;
    private static final Stroke[] STROKES;
    private static final Color[] COLORS;
    private static final int[][] SERIESES;
    static QueryCountChart singleton;
    JFreeChart[] charts = new JFreeChart[CHART.length];
    XYSeries[][] series = new XYSeries[CHART.length][];
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        CHART = nArray;
        LABEL = new String[]{"Query Count", "Average Count per Second", "Maximum Count per Second"};
        STROKES = new Stroke[]{new BasicStroke(1.5f), new BasicStroke(1.5f), new BasicStroke(1.0f)};
        COLORS = new Color[]{Color.black, Color.black, Color.red};
        SERIESES = new int[][]{new int[1], {1, 2}, {1, 2}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryCountChart getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.client.chart.QueryCountChart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (singleton == null) {
                singleton = new QueryCountChart();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private static int max(int[] array) {
        int max = 0;
        int i = 0;
        while (i < array.length) {
            if (max < array[i]) {
                max = array[i];
            }
            ++i;
        }
        return max;
    }

    private QueryCountChart() {
        int c = 0;
        while (c < CHART.length) {
            this.series[c] = new XYSeries[SERIESES[c].length];
            ++c;
        }
        this.charts[0] = this.createChart("60 Seconds Query Chart", 0, 60, "Second Passed");
        this.charts[1] = this.createChart("60 Minutes Query Chart", 1, 60, "Minute Passed");
        this.charts[2] = this.createChart("24 Hours Query Chart", 2, 24, "Hour Passed");
    }

    private JFreeChart createChart(String title, int chartType, int slots, String domainLabel) {
        int[] SERIES = SERIESES[chartType];
        int s = 0;
        while (s < SERIES.length) {
            this.series[chartType][s] = new XYSeries((Comparable)((Object)LABEL[SERIES[s]]));
            this.series[chartType][s].setMaximumItemCount(slots);
            ++s;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        int s2 = 0;
        while (s2 < SERIES.length) {
            dataset.addSeries(this.series[chartType][s2]);
            ++s2;
        }
        NumberAxis domain = new NumberAxis(domainLabel);
        domain.setAutoRange(true);
        domain.setLowerMargin(0.0);
        domain.setUpperMargin(0.0);
        domain.setTickLabelsVisible(true);
        NumberAxis range = new NumberAxis("Counts");
        range.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        int s3 = 0;
        while (s3 < SERIES.length) {
            renderer.setSeriesPaint(s3, (Paint)COLORS[SERIES[s3]]);
            renderer.setSeriesStroke(s3, STROKES[SERIES[s3]]);
            ++s3;
        }
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)domain, (ValueAxis)range, (XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    public void getChartAsPNG(int index, File file, int width, int height) throws IOException {
        if (index < 0 || index >= CHART.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (file == null) {
            throw new NullPointerException("Null file cannot be allowed.");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height should be larger than 0.");
        }
        ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.charts[index], (int)width, (int)height);
    }

    public void update(QueryStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("Status cannot be null");
        }
        int[][][] data = new int[][][]{new int[][]{status.getSec(), new int[0], new int[0]}, new int[][]{new int[0], status.getMin(), status.getMaxMin()}, new int[][]{new int[0], status.getHour(), status.getMaxHour()}};
        int c = 0;
        while (c < CHART.length) {
            int upper = 0;
            int s = 0;
            while (s < SERIESES[c].length) {
                XYSeries currentSeries = this.series[c][s];
                currentSeries.clear();
                int[] dat = data[c][SERIESES[c][s]];
                int d = 0;
                while (d < dat.length) {
                    currentSeries.add((double)d, (double)dat[d], false);
                    ++d;
                }
                int datMax = QueryCountChart.max(dat);
                if (upper < datMax) {
                    upper = datMax;
                }
                ++s;
            }
            XYPlot plot = (XYPlot)this.charts[c].getPlot();
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setRange(0.0, Math.max((double)upper * 1.15, 10.0));
            ++c;
        }
        c = 0;
        while (c < CHART.length) {
            int s = 0;
            while (s < SERIESES[c].length) {
                this.series[c][s].fireSeriesChanged();
                ++s;
            }
            this.charts[c].fireChartChanged();
            ++c;
        }
    }
}

