/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.job.JobCommand;
import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.client.util.JobDescription;
import com.diquest.ir.common.database.entity.JobLog;
import com.diquest.ir.common.database.handler.JobLogDB;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.filter.io.ResponseFilterWorker;
import com.diquest.ir.common.setting.manager.ClientProperties;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.Serializable;
import java.sql.Connection;

public class AdminServerClient
implements Serializable {
    private static final long serialVersionUID = 5638875885323936156L;
    JobLogDB jobRepository;
    JobCommand jobCommand;
    protected final String ip;
    protected final int port;

    public AdminServerClient(ClientProperties properties) {
        this((String)properties.getAdminServer()[0], (Integer)properties.getAdminServer()[1]);
    }

    public AdminServerClient(String ip, int port) {
        this.ip = ip;
        this.port = port;
        this.jobRepository = new JobLogDB();
        this.jobCommand = new JobCommand(ip, port);
    }

    public String getHostAddress() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public ExtResponse invoke(ExtRequest request, String ip, int port) throws IRException {
        ExtResponse response = ExternalClientPool.getInstance(ip, port).invoke(request);
        try {
            ResponseFilterWorker.accept((ExtResponse)response);
        }
        catch (IRException e) {
            throw new IRException(e);
        }
        return response;
    }

    public ExtResponse invokeRetrial(ExtRequest request, String ip, int port, int retrial) throws IRException, InterruptedException {
        ExtResponse response = ExternalClientPool.getInstance(ip, port).invoke(request);
        if (retrial == 0) {
            while (response == null) {
                Thread.sleep(1000L);
                response = ExternalClientPool.getInstance(ip, port).invoke(request);
            }
        } else {
            int i = 0;
            while (i < retrial) {
                Thread.sleep(1000L);
                response = ExternalClientPool.getInstance(ip, port).invoke(request);
                if (response == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        try {
            ResponseFilterWorker.accept((ExtResponse)response);
        }
        catch (IRException e) {
            throw new IRException(e);
        }
        return response;
    }

    public ExtResponse invoke(ExtRequest request) throws IRException {
        return this.invoke(request, this.ip, this.port);
    }

    public boolean registerJob(Connection conn, ExtRequest request, JobDescription description, String userid, long created, long last_updated) throws IRException {
        JobLog job = null;
        boolean notified = false;
        try {
            job = this.push(conn, request, description.toString(), userid, created, last_updated);
            notified = this.jobCommand.notifyJob();
            if (!notified) {
                this.jobRepository.delete(conn, job.getJobID());
            }
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot register a job.", (Throwable)e);
        }
        return notified;
    }

    public boolean registerJob(ExtRequest request, JobDescription description, String userid) throws IRException {
        Connection conn = null;
        try {
            conn = ConnectionFactory.getConnection();
            boolean bl = this.registerJob(conn, request, description, userid, System.currentTimeMillis(), System.currentTimeMillis());
            return bl;
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot register a job.", (Throwable)e);
        }
        finally {
            if (conn != null) {
                ConnectionFactory.release((Connection)conn);
            }
        }
    }

    private JobLog push(Connection conn, ExtRequest request, String description, String userid, long created, long last_updated) throws IRException {
        try {
            JobLog job = this.jobRepository.push(conn, request, description, userid, created, last_updated);
            return job;
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot inserta job to RDBMS table.", (Throwable)e);
        }
    }

    public boolean alive() throws IRException {
        return this.alive(this.ip, this.port);
    }

    public boolean alive(String ip, int port) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.system.ExtMessageAlive");
        ExtResponse response = this.invoke(request, ip, port);
        return ((BooleanT)response.getData()).value;
    }

    public boolean removeJob(Connection conn, int jobID) throws IRException {
        boolean removed = false;
        try {
            removed = this.jobCommand.removeJob(jobID);
            if (removed) {
                this.jobRepository.delete(conn, jobID);
            }
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot remove a job.", (Throwable)e);
        }
        return removed;
    }
}

