/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.common.msg.ext.body.setting.ReqAddServerT;
import com.diquest.ir.common.msg.ext.body.setting.ReqModifyServerT;
import com.diquest.ir.common.msg.ext.body.setting.ReqRemoveServerT;
import com.diquest.ir.common.msg.ext.body.setting.ResAddServerT;
import com.diquest.ir.common.setting.manager.ServerListSettingManager;
import com.diquest.ir.common.setting.manager.SettingObjectFactory;
import com.diquest.ir.common.setting.serverlist.Group;
import com.diquest.ir.common.setting.serverlist.Server;
import com.diquest.ir.common.setting.serverlist.ServerList;
import com.diquest.ir.common.setting.serversetting.ServerSetting;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.msg.type.XmlT;
import java.util.List;
import javax.xml.bind.JAXBException;

public class CommandAdminServerSetting {
    public AdminServerClient client;

    public CommandAdminServerSetting(String ip, int port) {
        this.client = new AdminServerClient(ip, port);
    }

    public ServerList getServerList() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageGetServerListSetting");
        ExtResponse response = this.client.invoke(request);
        ServerListSettingManager slm = (ServerListSettingManager)response.getData();
        return (ServerList)slm.getSettingObject();
    }

    public Server getServer(String serverName) throws IRException {
        try {
            ServerList serverList = this.getServerList();
            List groupList = serverList.getGroup();
            int i = 0;
            while (i < groupList.size()) {
                Group group = (Group)groupList.get(i);
                List servers = group.getServer();
                int k = 0;
                while (k < servers.size()) {
                    Server server = (Server)servers.get(k);
                    if (server.getName().equalsIgnoreCase(serverName)) {
                        return server;
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (IRException e) {
            throw new IRException("An Exception is occurred during getting server setting : " + serverName + ".", (Throwable)e);
        }
        return null;
    }

    public Server getServerInfo(int group, int id) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageGetServerListSetting");
        ExtResponse response = this.client.invoke(request);
        ServerListSettingManager slm = (ServerListSettingManager)response.getData();
        return slm.getServer(group, id);
    }

    public ResAddServerT addServer(int serverGroup, String serverIP, int keyPort, String serverName, String serverPrefix, String serverDesc, int joinWaitTime, int receiverHandshakeTimeout, int receiverBackLogSize, int externalReceiverBackLogSize, int externalReceiverMaxThread, long externalReceiverTimeout, long ldtTimeout, long receiveSyncTimeout, long checkAliveTimeout, int maxSize, int minSize, long keepAliveTime, String workCacheSize, String businessBufferSize, String searchCacheSize, int searchCacheResultSizeLimit) throws IRException {
        Object serverSetting = null;
        try {
            serverSetting = SettingObjectFactory.ServerSettingFactory.create((int)serverGroup, (int)0, (String)serverDesc, (int)joinWaitTime, (int)receiverHandshakeTimeout, (int)receiverBackLogSize, (int)externalReceiverBackLogSize, (int)externalReceiverMaxThread, (long)externalReceiverTimeout, (long)ldtTimeout, (long)receiveSyncTimeout, (long)checkAliveTimeout, (int)maxSize, (int)minSize, (long)keepAliveTime, (String)workCacheSize, (String)businessBufferSize, (String)searchCacheSize, (int)searchCacheResultSizeLimit);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot add server setting : " + serverName, (Throwable)e);
        }
        XmlT serverSettingT = new XmlT(serverSetting, "com.diquest.ir.common.setting.serversetting");
        ReqAddServerT reqAddServerInfo = new ReqAddServerT(serverGroup, serverIP, keyPort, serverName, serverPrefix, serverDesc, serverSettingT);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.system.ExtMessageAddServer", (Transmitable)reqAddServerInfo);
        ExtResponse response = this.client.invoke(request);
        if (response.getErrorCode() >= 0) {
            ResAddServerT responseData = (ResAddServerT)response.getData();
            return responseData;
        }
        ErrorMessage errorMessage = (ErrorMessage)response.getData();
        throw new IRException(2, "Cannot add server : " + serverName + ".(" + errorMessage.getErrorMessage() + ")");
    }

    public ResAddServerT addServer(int serverGroup, String serverIP, int keyPort, String serverName, String serverPrefix, String serverDesc, int joinWaitTime, int receiverHandshakeTimeout, int receiverBackLogSize, int externalReceiverBackLogSize, int externalReceiverMaxThread, long externalReceiverTimeout, long ldtTimeout, long receiveSyncTimeout, long checkAliveTimeout, int maxSize, int minSize, long keepAliveTime, String workCacheSize, String businessBufferSize, String searchCacheSize, int searchCacheResultSizeLimit, String jianaVersion) throws IRException {
        Object serverSetting = null;
        try {
            serverSetting = SettingObjectFactory.ServerSettingFactory.create((int)serverGroup, (int)0, (String)serverDesc, (int)joinWaitTime, (int)receiverHandshakeTimeout, (int)receiverBackLogSize, (int)externalReceiverBackLogSize, (int)externalReceiverMaxThread, (long)externalReceiverTimeout, (long)ldtTimeout, (long)receiveSyncTimeout, (long)checkAliveTimeout, (int)maxSize, (int)minSize, (long)keepAliveTime, (String)workCacheSize, (String)businessBufferSize, (String)searchCacheSize, (int)searchCacheResultSizeLimit, (String)jianaVersion);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot add server setting : " + serverName, (Throwable)e);
        }
        XmlT serverSettingT = new XmlT(serverSetting, "com.diquest.ir.common.setting.serversetting");
        ReqAddServerT reqAddServerInfo = new ReqAddServerT(serverGroup, serverIP, keyPort, serverName, serverPrefix, serverDesc, serverSettingT);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.system.ExtMessageAddServer", (Transmitable)reqAddServerInfo);
        ExtResponse response = this.client.invoke(request);
        if (response.getErrorCode() >= 0) {
            ResAddServerT responseData = (ResAddServerT)response.getData();
            return responseData;
        }
        ErrorMessage errorMessage = (ErrorMessage)response.getData();
        throw new IRException(2, "Cannot add server : " + serverName + ".(" + errorMessage.getErrorMessage() + ")");
    }

    public ServerSetting getServerSetting(String serverName) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageGetServerSetting", (Transmitable)new StringT(serverName));
        try {
            ExtResponse response = this.client.invoke(request);
            XmlT xmlT = (XmlT)response.getData();
            ServerSetting serverSetting = (ServerSetting)xmlT.getSettingObject();
            return serverSetting;
        }
        catch (IRException e) {
            throw new IRException("An Error is occurred during getting server setting: " + serverName + ".", (Throwable)e);
        }
    }

    public boolean modify(int serverGroup, int serverID, String serverIP, int keyPort, String serverName, String serverPrefix, String serverDesc, int joinWaitTime, int receiverHandshakeTimeout, int receiverBackLogSize, int externalReceiverBackLogSize, int externalReceiverMaxThread, long externalReceiverTimeout, long ldtTimeout, long receiveSyncTimeout, long checkAliveTimeout, int maxSize, int minSize, long keepAliveTime, String workCacheSize, String businessBufferSize, String searchCacheSize, int searchCacheResultSizeLimit) throws JAXBException, IRException {
        try {
            Object serverSetting = SettingObjectFactory.ServerSettingFactory.create((int)serverGroup, (int)serverID, (String)serverDesc, (int)joinWaitTime, (int)receiverHandshakeTimeout, (int)receiverBackLogSize, (int)externalReceiverBackLogSize, (int)externalReceiverMaxThread, (long)externalReceiverTimeout, (long)ldtTimeout, (long)receiveSyncTimeout, (long)checkAliveTimeout, (int)maxSize, (int)minSize, (long)keepAliveTime, (String)workCacheSize, (String)businessBufferSize, (String)searchCacheSize, (int)searchCacheResultSizeLimit);
            XmlT serverSettingT = new XmlT(serverSetting, "com.diquest.ir.common.setting.serversetting");
            ReqModifyServerT reqModifyServerInfo = new ReqModifyServerT(serverGroup, serverID, serverIP, keyPort, serverName, serverPrefix, serverDesc, serverSettingT);
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.system.ExtMessageModifyServer", (Transmitable)reqModifyServerInfo);
            ExtResponse response = this.client.invoke(request);
            boolean isSettable = ((BooleanT)response.getData()).value;
            return isSettable;
        }
        catch (IRException e) {
            throw new IRException("Cannot modify serverSetting : [group=" + serverGroup + " id=" + serverID + "]", (Throwable)e);
        }
    }

    public boolean modify(int serverGroup, int serverID, String serverIP, int keyPort, String serverName, String serverPrefix, String serverDesc, int joinWaitTime, int receiverHandshakeTimeout, int receiverBackLogSize, int externalReceiverBackLogSize, int externalReceiverMaxThread, long externalReceiverTimeout, long ldtTimeout, long receiveSyncTimeout, long checkAliveTimeout, int maxSize, int minSize, long keepAliveTime, String workCacheSize, String businessBufferSize, String searchCacheSize, int searchCacheResultSizeLimit, String jianaVersion) throws JAXBException, IRException {
        try {
            Object serverSetting = SettingObjectFactory.ServerSettingFactory.create((int)serverGroup, (int)serverID, (String)serverDesc, (int)joinWaitTime, (int)receiverHandshakeTimeout, (int)receiverBackLogSize, (int)externalReceiverBackLogSize, (int)externalReceiverMaxThread, (long)externalReceiverTimeout, (long)ldtTimeout, (long)receiveSyncTimeout, (long)checkAliveTimeout, (int)maxSize, (int)minSize, (long)keepAliveTime, (String)workCacheSize, (String)businessBufferSize, (String)searchCacheSize, (int)searchCacheResultSizeLimit, (String)jianaVersion);
            XmlT serverSettingT = new XmlT(serverSetting, "com.diquest.ir.common.setting.serversetting");
            ReqModifyServerT reqModifyServerInfo = new ReqModifyServerT(serverGroup, serverID, serverIP, keyPort, serverName, serverPrefix, serverDesc, serverSettingT);
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.system.ExtMessageModifyServer", (Transmitable)reqModifyServerInfo);
            ExtResponse response = this.client.invoke(request);
            boolean isSettable = ((BooleanT)response.getData()).value;
            return isSettable;
        }
        catch (IRException e) {
            throw new IRException("Cannot modify serverSetting : [group=" + serverGroup + " id=" + serverID + "]", (Throwable)e);
        }
    }

    public void remove(int serverGroup, int serverID) throws IRException {
        boolean status = false;
        ReqRemoveServerT removeServerT = new ReqRemoveServerT(serverGroup, serverID);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.system.ExtMessageRemoveServer", (Transmitable)removeServerT);
        ExtResponse response = this.client.invoke(request);
        if (response.getErrorCode() <= 0) {
            ErrorMessage errorMessage = (ErrorMessage)response.getData();
            throw new IRException("An Error is occurred during removing server : [group=" + serverGroup + " id=" + serverID + "]. (" + errorMessage.getErrorMessage() + ")");
        }
        BooleanT booleanT = (BooleanT)response.getData();
    }
}

