/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.setting.ResApplySettingT;
import com.diquest.ir.common.setting.broker.BrokerSetting;
import com.diquest.ir.common.setting.manager.BrokerSettingManager;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.XmlT;
import java.util.Collections;
import java.util.Map;

public class CommandBrokerSetting {
    private Map exceptions = Collections.EMPTY_MAP;
    public AdminServerClient client;

    public CommandBrokerSetting(String ip, int port) {
        this(new AdminServerClient(ip, port));
    }

    public CommandBrokerSetting(AdminServerClient client) {
        this.client = client;
    }

    public BrokerSetting getSetting() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageGetBrokerSetting");
        try {
            ExtResponse response = this.client.invoke(request);
            XmlT xmlT = (XmlT)response.getData();
            BrokerSetting brokerSetting = (BrokerSetting)xmlT.getSettingObject();
            return brokerSetting;
        }
        catch (IRException e) {
            throw new IRException(2, "An Error is occurred during getting broker setting.", (Throwable)e);
        }
    }

    public boolean modifySetting(BrokerSetting brokerSetting) throws IRException {
        try {
            return this.modifySettting(BrokerSettingManager.readFromObject((Object)brokerSetting));
        }
        catch (IRException e) {
            throw new IRException(2, "An Error is occurred during modifyinging broker setting.", (Throwable)e);
        }
    }

    public boolean modifySettting(BrokerSettingManager brokerSettingManager) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageModifyBrokerSetting", (Transmitable)brokerSettingManager);
        ExtResponse response = this.client.invoke(request);
        return response != null && response.getErrorCode() >= 0;
    }

    public boolean applySetting() throws IRException {
        this.exceptions = Collections.EMPTY_MAP;
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageApplyBrokerSetting");
        ExtResponse response = this.client.invoke(request);
        if (response == null || response.getErrorCode() < 0 || response.getData() == null) {
            return false;
        }
        ResApplySettingT data = (ResApplySettingT)response.getData();
        this.exceptions = data.getExceptions();
        return data.isSuccess();
    }

    public Map getExceptions() {
        return this.exceptions;
    }
}

