/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ProfileKey;
import com.diquest.ir.common.msg.ext.body.dbwatcher.ReqGetAllDBWatcherSettings;
import com.diquest.ir.common.msg.ext.body.dbwatcher.ReqGetDBWatcherSetting;
import com.diquest.ir.common.msg.ext.body.dbwatcher.ReqRemoveDBWatcherSetting;
import com.diquest.ir.common.msg.ext.body.dbwatcher.ResGetAllDBWatcherSettings;
import com.diquest.ir.common.setting.dbwatcher.DbWatcherSetting;
import com.diquest.ir.common.setting.dbwatcher.Mapping;
import com.diquest.ir.common.setting.dbwatcher.MappingListType;
import com.diquest.ir.common.setting.dbwatcher.ObjectFactory;
import com.diquest.ir.common.setting.dbwatcher.Query;
import com.diquest.ir.common.setting.manager.DBWatcherListSettingManager;
import com.diquest.ir.common.setting.manager.SingleDBWatcherSettingManager;
import com.diquest.ir.util.msg.Message;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.StringT;
import java.util.List;

public class CommandDBWatcher {
    ObjectFactory OF = new ObjectFactory();
    private final String userid;
    private AdminServerClient client = null;

    public CommandDBWatcher(AdminServerClient client, String userid) {
        this.client = client;
        this.userid = userid;
    }

    public boolean addDBWatcherSetting(String collectionID, String dbWatcherID, String description, String dataSourceID, String filterSettingID, String logLevel) throws IRException {
        return this.addDBWatcherSetting(collectionID, dbWatcherID, filterSettingID, 0, null, null, description);
    }

    public boolean addDBWatcherSetting(String collectionID, String dbWatcherID, String filterSettingID, int fetchSize, String encoding, String extension, String description) throws IRException {
        try {
            SingleDBWatcherSettingManager setMgr = SingleDBWatcherSettingManager.create();
            setMgr.frame(collectionID, dbWatcherID, filterSettingID, fetchSize, encoding, extension, description);
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageAddDBWatcherSetting", (Transmitable)setMgr);
            ExtResponse response = this.client.invoke(request);
            return response != null && response.getErrorCode() >= 0;
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding a DBWatcher setting. [dbWatcherID=" + dbWatcherID + "]", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }

    public boolean addDBWatcherSetting(String collectionID, String dbWatcherID, String filterSettingID, int fetchSize, int bulkFactor, String encoding, String extension, String description) throws IRException {
        try {
            SingleDBWatcherSettingManager setMgr = SingleDBWatcherSettingManager.create();
            setMgr.frame(collectionID, dbWatcherID, filterSettingID, fetchSize, bulkFactor, encoding, extension, description);
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageAddDBWatcherSetting", (Transmitable)setMgr);
            ExtResponse response = this.client.invoke(request);
            return response != null && response.getErrorCode() >= 0;
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding a DBWatcher setting. [dbWatcherID=" + dbWatcherID + "]", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }

    public boolean addDBWatcherSetting(String collectionID, String dbWatcherID, String description, String dataSourceID, String filterSettingID, String logLevel, int fetchSize) throws IRException {
        try {
            SingleDBWatcherSettingManager setMgr = SingleDBWatcherSettingManager.create();
            setMgr.frame(collectionID, dbWatcherID, description, dataSourceID, logLevel, filterSettingID, fetchSize);
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageAddDBWatcherSetting", (Transmitable)setMgr);
            ExtResponse response = this.client.invoke(request);
            return response != null && response.getErrorCode() >= 0;
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding a DBWatcher setting. [collectionID=" + collectionID + " dbWatcherID=" + dbWatcherID + "]", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }

    public boolean removeDBWatcherSetting(String collectionID, String dbWatcherID) throws IRException {
        ReqRemoveDBWatcherSetting requestData = new ReqRemoveDBWatcherSetting(collectionID, dbWatcherID);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageRemoveDBWatcherSetting", (Transmitable)requestData);
        ExtResponse response = this.client.invoke(request);
        return response != null && response.getErrorCode() >= 0;
    }

    public DbWatcherSetting[] getAllDBWatcherSettings(String collectionID) throws IRException {
        try {
            ReqGetAllDBWatcherSettings requestData = new ReqGetAllDBWatcherSettings(collectionID);
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageGetAllDBWatcherSettings", (Transmitable)requestData);
            ExtResponse response = this.client.invoke(request);
            ResGetAllDBWatcherSettings responseData = (ResGetAllDBWatcherSettings)response.getData();
            return responseData.getAllDBWatcherSettings();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting all DBWatcher setting.", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }

    public DbWatcherSetting getDBWatcherSetting(String collectionID, String dbWatcherID) throws IRException {
        ReqGetDBWatcherSetting requestData = new ReqGetDBWatcherSetting(collectionID, dbWatcherID);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageGetDBWatcherSetting", (Transmitable)requestData);
        ExtResponse response = this.client.invoke(request);
        DbWatcherSetting dbWatcherSetting = ((SingleDBWatcherSettingManager)response.getData()).getDbWatcherSetting();
        return dbWatcherSetting;
    }

    public DBWatcherListSettingManager getDBWatcherListSetting(String collection) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageGetDBWatcherList", (Transmitable)new StringT(collection));
        ExtResponse response = this.client.invoke(request);
        return (DBWatcherListSettingManager)response.getData();
    }

    public boolean modifyDBWatcherSetting(DbWatcherSetting setting, String dataSourceID, String filterSettingID, String description, String logLevel) throws IRException {
        try {
            SingleDBWatcherSettingManager setMgr = SingleDBWatcherSettingManager.readFromObject((Object)setting);
            setMgr.modifyFrame(description, dataSourceID, filterSettingID, logLevel);
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageModifyDBWatcherSetting", (Transmitable)setMgr);
            ExtResponse response = this.client.invoke(request);
            return response != null && response.getErrorCode() >= 0;
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying a DBWatcher setting. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean modifyDBWatcherSetting(DbWatcherSetting setting, String dataSourceID, String filterSettingID, String description, String logLevel, int fetchSize) throws IRException {
        try {
            SingleDBWatcherSettingManager setMgr = SingleDBWatcherSettingManager.readFromObject((Object)setting);
            setMgr.modifyFrame(description, dataSourceID, filterSettingID, logLevel, fetchSize);
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageModifyDBWatcherSetting", (Transmitable)setMgr);
            ExtResponse response = this.client.invoke(request);
            return response != null && response.getErrorCode() >= 0;
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying a DBWatcher setting. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean modifyDBWatcherListSetting(String collectionID, int numThread) throws IRException {
        Message msg = new Message(2);
        msg.setString(0, collectionID);
        msg.setInt(1, numThread);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageModifyDBWatcherListSetting", (Transmitable)msg);
        ExtResponse response = this.client.invoke(request);
        return response != null && response.getErrorCode() >= 0;
    }

    public boolean modifyDBWatcherSetting(String collectionID, String dbWatcherID, String filterSettingID, int fetchSize, String encoding, String extension, String description) throws IRException {
        DbWatcherSetting setting = this.getDBWatcherSetting(collectionID, dbWatcherID);
        try {
            SingleDBWatcherSettingManager setMgr = SingleDBWatcherSettingManager.readFromObject((Object)setting);
            setMgr.modifyFrame(filterSettingID, fetchSize, encoding, extension, description);
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageModifyDBWatcherSetting", (Transmitable)setMgr);
            ExtResponse response = this.client.invoke(request);
            return response != null && response.getErrorCode() >= 0;
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying a DBWatcher setting. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean modifyDBWatcherSetting(String collectionID, String dbWatcherID, String filterSettingID, int fetchSize, int bulkFactor, String encoding, String extension, String description) throws IRException {
        DbWatcherSetting setting = this.getDBWatcherSetting(collectionID, dbWatcherID);
        try {
            SingleDBWatcherSettingManager setMgr = SingleDBWatcherSettingManager.readFromObject((Object)setting);
            setMgr.modifyFrame(filterSettingID, fetchSize, bulkFactor, encoding, extension, description);
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageModifyDBWatcherSetting", (Transmitable)setMgr);
            ExtResponse response = this.client.invoke(request);
            return response != null && response.getErrorCode() >= 0;
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying a DBWatcher setting. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void addFullCollectSqlPre(DbWatcherSetting setting, String query) throws IRException {
        try {
            SingleDBWatcherSettingManager.readFromObject((Object)setting).addFullCollectSqlPre(query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding full collect pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public List getFullCollectSqlPre(DbWatcherSetting setting) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getFullCollectSqlPre();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting full collect pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void setUseAutoInc(DbWatcherSetting setting, boolean useAutoInc) throws IRException {
        SingleDBWatcherSettingManager.readFromObject((Object)setting).setUseAutoInc(useAutoInc);
    }

    public void setUseManualInc(DbWatcherSetting setting, boolean useManualInc) throws IRException {
        SingleDBWatcherSettingManager.readFromObject((Object)setting).setUseManualInc(useManualInc);
    }

    public void setUseFieldUpdate(DbWatcherSetting setting, boolean useFieldUpdate) throws IRException {
        SingleDBWatcherSettingManager.readFromObject((Object)setting).setUseFieldUpdate(useFieldUpdate);
    }

    public void setUseIncSql(DbWatcherSetting setting, boolean useIncSql) throws IRException {
        SingleDBWatcherSettingManager.readFromObject((Object)setting).setUseFieldUpdate(useIncSql);
    }

    public void setUseFullCollectSql(DbWatcherSetting setting, boolean useFullCollectSql) throws IRException {
        SingleDBWatcherSettingManager.readFromObject((Object)setting).setUseFieldUpdate(useFullCollectSql);
    }

    public Query getFullCollectSqlPre(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getFullCollectSqlPre(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting full collect pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean modifyFullCollectSqlPre(DbWatcherSetting setting, int sequence, String query) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).modifyFullCollectSqlPre(sequence, query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying full collect pre-SQL. dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean removeFullCollectSqlPre(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).removeFullCollectSqlPre(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred removing full collect pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void setFullCollectSql(DbWatcherSetting setting, String query) throws IRException {
        try {
            SingleDBWatcherSettingManager.readFromObject((Object)setting).setFullCollectSql(query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred setting full collect SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public String getFullCollectSql(DbWatcherSetting setting) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getFullCollectSql();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting full collect SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void addFullCollectSqlPost(DbWatcherSetting setting, String query) throws IRException {
        try {
            SingleDBWatcherSettingManager.readFromObject((Object)setting).addFullCollectSqlPost(query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding full collect post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public List getFullCollectSqlPost(DbWatcherSetting setting) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getFullCollectSqlPost();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting full collect post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public Query getFullCollectSqlPost(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getFullCollectSqlPost(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting full collect post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean modifyFullCollectSqlPost(DbWatcherSetting setting, int sequence, String query) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).modifyFullCollectSqlPost(sequence, query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying full collect post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean removeFullCollectSqlPost(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).removeFullCollectSqlPost(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred removing full collect post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void setIncCollectSql(DbWatcherSetting setting, String query) throws IRException {
        try {
            SingleDBWatcherSettingManager.readFromObject((Object)setting).setIncCollectSql(query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred setting incremental collect SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public String getIncCollectSql(DbWatcherSetting setting) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getIncCollectSql();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting incremental collect SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void setIdSeletSql(DbWatcherSetting setting, String query) throws IRException {
        try {
            SingleDBWatcherSettingManager.readFromObject((Object)setting).setIdSeletSql(query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred setting ID select SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public String getIdSelectSql(DbWatcherSetting setting) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getIdSelectSql();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting ID select SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void addAutoUpdateCheckPre(DbWatcherSetting setting, String query) throws IRException {
        try {
            SingleDBWatcherSettingManager.readFromObject((Object)setting).addAutoUpdateCheckPre(query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding auto update check pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public List getAutoUpdateCheckPre(DbWatcherSetting setting) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getAutoUpdateCheckPre();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting auto update check pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public Query getAutoUpdateCheckPre(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getAutoUpdateCheckPre(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting auto update check pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean modifyAutoUpdateCheckPre(DbWatcherSetting setting, int sequence, String query) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).modifyAutoUpdateCheckPre(sequence, query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying auto update check pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean removeAutoUpdateCheckPre(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).removeAutoUpdateCheckPre(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred removing auto update check pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void addAutoUpdateCheckPost(DbWatcherSetting setting, String query) throws IRException {
        try {
            SingleDBWatcherSettingManager.readFromObject((Object)setting).addAutoUpdateCheckPost(query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding auto update check post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public List getAutoUpdateCheckPost(DbWatcherSetting setting) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getAutoUpdateCheckPost();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting auto update check post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public Query getAutoUpdateCheckPost(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getAutoUpdateCheckPost(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting auto update check post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean modifyAutoUpdateCheckPost(DbWatcherSetting setting, int sequence, String query) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).modifyAutoUpdateCheckPost(sequence, query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying auto update check post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean removeAutoUpdateCheckPost(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).removeAutoUpdateCheckPost(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred removing auto update check post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void addManualUpdateCheckPost(DbWatcherSetting setting, String query) throws IRException {
        try {
            SingleDBWatcherSettingManager.readFromObject((Object)setting).addManualUpdateCheckPost(query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding manual update check post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public List getManualUpdateCheckPost(DbWatcherSetting setting) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getManualUpdateCheckPost();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting manual update check post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public Query getManualUpdateCheckPost(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getManualUpdateCheckPost(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting manual update check post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean modifyManualUpdateCheckPost(DbWatcherSetting setting, int sequence, String query) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).modifyManualUpdateCheckPost(sequence, query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying manual update check post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean removeManualUpdateCheckPost(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).removeManualUpdateCheckPost(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred removing manual update check post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void addFieldUpdateCollectSqlPre(DbWatcherSetting setting, String query) throws IRException {
        try {
            SingleDBWatcherSettingManager.readFromObject((Object)setting).addFieldUpdateCollectSqlPre(query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding field update collect pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public List getFieldUpdateCollectSqlPre(DbWatcherSetting setting) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getFieldUpdateCollectSqlPre();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting field update collect pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public Query getFieldUpdateCollectSqlPre(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getFieldUpdateCollectSqlPre(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting field update collect pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean modifyFieldUpdateCollectSqlPre(DbWatcherSetting setting, int sequence, String query) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).modifyFieldUpdateCollectSqlPre(sequence, query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying field update collect pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean removeFieldUpdateCollectSqlPre(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).removeFieldUpdateCollectSqlPre(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred removing field update collect pre-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void setFieldUpdateCollectSql(DbWatcherSetting setting, String query) throws IRException {
        try {
            SingleDBWatcherSettingManager.readFromObject((Object)setting).setFieldUpdateCollectSql(query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred setting field update collect SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public String getFieldUpdateCollectSql(DbWatcherSetting setting) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getFieldUpdateCollectSql();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting field update collect SQL. [dbWatcherID=" + setting.getId() + "]", (Throwable)e);
        }
    }

    public void addFieldUpdateCollectSqlPost(DbWatcherSetting setting, String query) throws IRException {
        try {
            SingleDBWatcherSettingManager.readFromObject((Object)setting).addFieldUpdateCollectSqlPost(query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding field update collect post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public List getFieldUpdateCollectSqlPost(DbWatcherSetting setting) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getFieldUpdateCollectSqlPost();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting field update collect post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public Query getFieldUpdateCollectSqlPost(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).getFieldUpdateCollectSqlPost(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting field update collect post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean modifyFieldUpdateCollectSqlPost(DbWatcherSetting setting, int sequence, String query) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).modifyFieldUpdateCollectSqlPost(sequence, query);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying field update collect post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean removeFieldUpdateCollectSqlPost(DbWatcherSetting setting, int sequence) throws IRException {
        try {
            return SingleDBWatcherSettingManager.readFromObject((Object)setting).removeFieldUpdateCollectSqlPost(sequence);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred removing field update collect post-SQL. [dbWatcherID=" + setting.getId() + "]", ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean modifyDBWatcherSetting(DbWatcherSetting setting) throws IRException {
        try {
            SingleDBWatcherSettingManager settingMgr = SingleDBWatcherSettingManager.readFromObject((Object)setting);
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageModifyDBWatcherSetting", (Transmitable)settingMgr);
            ExtResponse response = this.client.invoke(request);
            return response != null && response.getErrorCode() >= 0;
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred modifying dbwatcher setting. [dbWatcherID=" + setting.getId() + "] " + e.getMessage(), ProfileKey.getKey((String)setting.getCollectionID()), (Throwable)e);
        }
    }

    public void initMappingList(DbWatcherSetting dbWatcherSetting, boolean extension, String extensionLabel) throws IRException {
        try {
            SingleDBWatcherSettingManager dbWatcherSettingMgr = SingleDBWatcherSettingManager.readFromObject((Object)dbWatcherSetting);
            dbWatcherSettingMgr.setMappingList(extension, extensionLabel);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred initializing mapping list. [dbWatcherID=" + dbWatcherSetting.getId() + "] " + e.getMessage(), ProfileKey.getKey((String)dbWatcherSetting.getCollectionID()), (Throwable)e);
        }
    }

    public void addMapping(DbWatcherSetting dbWatcherSetting, String schemaID, String dbField, boolean useExtension, boolean removeHtmlTag, boolean useAttachFileFilter, boolean useFieldUpdate, boolean isFileMeta) throws IRException {
        try {
            SingleDBWatcherSettingManager dbWatcherElementSettingMgr = SingleDBWatcherSettingManager.readFromObject((Object)dbWatcherSetting);
            dbWatcherElementSettingMgr.addMapping(schemaID, dbField, useExtension, removeHtmlTag, useAttachFileFilter, useFieldUpdate, isFileMeta);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding mapping to list. [dbWatcherID=" + dbWatcherSetting.getId() + " schemaID=" + schemaID + " dbField=" + dbField + "] " + e.getMessage(), ProfileKey.getKey((String)dbWatcherSetting.getCollectionID()), (Throwable)e);
        }
    }

    public void removeMapping(DbWatcherSetting dbWatcherSetting, String schemaID) throws IRException {
        try {
            SingleDBWatcherSettingManager dbWatcherElementSettingMgr = SingleDBWatcherSettingManager.readFromObject((Object)dbWatcherSetting);
            dbWatcherElementSettingMgr.removeMapping(schemaID);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred removing mapping from list. [dbWatcherID=" + dbWatcherSetting.getId() + " schemaID=" + schemaID + "] " + e.getMessage(), ProfileKey.getKey((String)dbWatcherSetting.getCollectionID()), (Throwable)e);
        }
    }

    public void addExtensionMapping(DbWatcherSetting dbWatcherSetting, String schemaID, boolean removeHtmlTag, boolean useAttachFileFilter) throws IRException {
        try {
            SingleDBWatcherSettingManager dbWatcherElementSettingMgr = SingleDBWatcherSettingManager.readFromObject((Object)dbWatcherSetting);
            dbWatcherElementSettingMgr.addMapping(schemaID, removeHtmlTag, useAttachFileFilter);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred adding extension mapping. [dbWatcherID=" + dbWatcherSetting.getId() + " schemaID=" + schemaID + "] " + e.getMessage(), ProfileKey.getKey((String)dbWatcherSetting.getCollectionID()), (Throwable)e);
        }
    }

    public List getMappingList(String collectionID, String dbWatcherID) throws IRException {
        DbWatcherSetting dbWatcherSetting = this.getDBWatcherSetting(collectionID, dbWatcherID);
        return dbWatcherSetting.getMappingList().getMapping();
    }

    public MappingListType getMappingListType(DbWatcherSetting setting) {
        return setting.getMappingList();
    }

    public void setMetaField(DbWatcherSetting dbWatcherSetting, String schemaId, String filterMetaField, boolean useFilterMetaField) throws IRException {
        try {
            SingleDBWatcherSettingManager dbWatcherElementSettingMgr = SingleDBWatcherSettingManager.readFromObject((Object)dbWatcherSetting);
            dbWatcherElementSettingMgr.setMetaField(schemaId, filterMetaField, useFilterMetaField);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred setting meta field. [dbWatcherID=" + dbWatcherSetting.getId() + " schemaID=" + schemaId + "] " + e.getMessage(), ProfileKey.getKey((String)dbWatcherSetting.getCollectionID()), (Throwable)e);
        }
    }

    public List getFilteredMappingList(DbWatcherSetting dbWatcherSetting) throws IRException {
        try {
            SingleDBWatcherSettingManager dbWatcherElementSettingMgr = SingleDBWatcherSettingManager.readFromObject((Object)dbWatcherSetting);
            return dbWatcherElementSettingMgr.getFilteredMappingList();
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting fitered mapping list. [dbWatcherID=" + dbWatcherSetting.getId() + "] " + e.getMessage(), ProfileKey.getKey((String)dbWatcherSetting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean needFilterSetting(DbWatcherSetting dbWatcherSetting) throws IRException {
        try {
            SingleDBWatcherSettingManager dbWatcherElementSettingMgr = SingleDBWatcherSettingManager.readFromObject((Object)dbWatcherSetting);
            return dbWatcherElementSettingMgr.getFilteredMappingList().size() > 0;
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred checking needs for filter setting. [dbWatcherID=" + dbWatcherSetting.getId() + "] " + e.getMessage(), ProfileKey.getKey((String)dbWatcherSetting.getCollectionID()), (Throwable)e);
        }
    }

    public boolean hasDisabledSchemaIdList(DbWatcherSetting dbWatcherSetting, List schemaSettingList) throws IRException {
        try {
            SingleDBWatcherSettingManager dbWatcherElementSettingMgr = SingleDBWatcherSettingManager.readFromObject((Object)dbWatcherSetting);
            return dbWatcherElementSettingMgr.hasDisabledSchemaIdList(schemaSettingList);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred checking disabled schema id list.[dbWatcherID=" + dbWatcherSetting.getId() + "] " + e.getMessage(), ProfileKey.getKey((String)dbWatcherSetting.getCollectionID()), (Throwable)e);
        }
    }

    public List getDisabledSchemaIdList(DbWatcherSetting dbWatcherSetting, List schemaSettingList) throws IRException {
        try {
            SingleDBWatcherSettingManager dbWatcherElementSettingMgr = SingleDBWatcherSettingManager.readFromObject((Object)dbWatcherSetting);
            return dbWatcherElementSettingMgr.getDisabledSchemaIdList(schemaSettingList);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting disabled schema id list. [dbWatcherID=" + dbWatcherSetting.getId() + "] " + e.getMessage(), ProfileKey.getKey((String)dbWatcherSetting.getCollectionID()), (Throwable)e);
        }
    }

    public Mapping getMapping(DbWatcherSetting dbWatcherSetting, String schemaId) throws IRException {
        try {
            SingleDBWatcherSettingManager dbWatcherElementSettingMgr = SingleDBWatcherSettingManager.readFromObject((Object)dbWatcherSetting);
            return dbWatcherElementSettingMgr.getMapping(schemaId);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred getting mapping list. [dbWatcherID=" + dbWatcherSetting.getId() + "] " + e.getMessage(), ProfileKey.getKey((String)dbWatcherSetting.getCollectionID()), (Throwable)e);
        }
    }
}

