/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.setting.ResApplySettingT;
import com.diquest.ir.common.setting.affilter.DbWatcherFilterSetting;
import com.diquest.ir.common.setting.affilter.Extension;
import com.diquest.ir.common.setting.affilter.ExtensionType;
import com.diquest.ir.common.setting.manager.AttachFileFilterSettingManager;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CommandDBWatcherFilterSetting {
    private Map exceptions = Collections.EMPTY_MAP;
    AttachFileFilterSettingManager filterSettingManager;
    private final String userid;
    AdminServerClient client;

    public CommandDBWatcherFilterSetting(AdminServerClient client, String userid) throws IRException {
        this.client = client;
        this.userid = userid;
        this.setFilterSettingManager();
    }

    public void setFilterSettingManager() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageGetDbWatcherFilter");
        ExtResponse response = this.client.invoke(request);
        this.filterSettingManager = (AttachFileFilterSettingManager)response.getData();
    }

    public boolean applySetting() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageModifyDbWatcherFilter", (Transmitable)this.filterSettingManager);
        ExtResponse response = this.client.invoke(request);
        return response != null && response.getErrorCode() >= 0;
    }

    public boolean applySetting2() throws IRException {
        this.exceptions = Collections.EMPTY_MAP;
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageApplyDbWatcherFilter", (Transmitable)this.filterSettingManager);
        ExtResponse response = this.client.invoke(request);
        if (response == null || response.getErrorCode() < 0 || response.getData() == null) {
            return false;
        }
        ResApplySettingT data = (ResApplySettingT)response.getData();
        this.exceptions = data.getExceptions();
        return data.isSuccess();
    }

    public List getFilterSettingList() {
        return this.filterSettingManager.getFilterSettingList();
    }

    public DbWatcherFilterSetting getFilterSetting(String id) {
        return this.filterSettingManager.getFilterSetting(id);
    }

    public void addFilterSetting(String id, String internalFileFilterDefaultEncoding) throws IRException {
        try {
            this.filterSettingManager.addFilterSetting(id, internalFileFilterDefaultEncoding);
        }
        catch (IRException e) {
            throw new IRException(e);
        }
    }

    public void removeFilterSetting(String id) throws IRException {
        this.filterSettingManager.removeFilterSetting(id);
    }

    public void modifyFilterSetting(String id, String internalFileFilterDefaultEncoding, List list) throws IRException {
        try {
            if (this.filterSettingManager.getFilterSetting(id) == null) {
                this.filterSettingManager.addFilterSetting(id, internalFileFilterDefaultEncoding);
            } else {
                this.filterSettingManager.updateAttributes(id, internalFileFilterDefaultEncoding);
            }
            List old = this.filterSettingManager.retrieveExtensionList(id);
            HashSet<String> oldExts = new HashSet<String>(old.size());
            Iterator it = old.iterator();
            while (it.hasNext()) {
                ExtensionType oldExt = (ExtensionType)it.next();
                oldExts.add(oldExt.getName());
            }
            HashSet<String> newExts = new HashSet<String>(list.size());
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                ExtensionType newExt = (ExtensionType)it2.next();
                newExts.add(newExt.getName());
            }
            HashSet removed = new HashSet(oldExts);
            removed.removeAll(newExts);
            Iterator it3 = removed.iterator();
            while (it3.hasNext()) {
                this.filterSettingManager.deleteExtension(id, (String)it3.next());
            }
            it3 = list.iterator();
            while (it3.hasNext()) {
                ExtensionType ext = (ExtensionType)it3.next();
                String encoding = ext.getEncoding();
                String name = ext.getName();
                boolean autoDetect = ext.isAutoDetect();
                boolean removeHtmlTag = ext.isRemoveHtmlTag();
                boolean useFileFilter = ext.useFileFilter();
                boolean useTextFilter = ext.useTextFilter();
                if (oldExts.contains(name)) {
                    this.filterSettingManager.updateExtension(id, name, removeHtmlTag, useFileFilter, useTextFilter, autoDetect, encoding);
                    continue;
                }
                this.filterSettingManager.createExtension(id, name, removeHtmlTag, useFileFilter, useTextFilter, autoDetect, encoding);
            }
        }
        catch (IRException e) {
            throw new IRException(e);
        }
    }

    public void createExtension(String parentId, String name, boolean removeHtmlTag, boolean useFileFilter, boolean useTextFilter) throws IRException {
        this.createExtension(parentId, name, removeHtmlTag, useFileFilter, useTextFilter, false, null);
    }

    public void createExtension(String parentId, String name, boolean removeHtmlTag, boolean useFileFilter, boolean useTextFilter, boolean autoDetect, String encoding) throws IRException {
        try {
            this.filterSettingManager.createExtension(parentId, name, removeHtmlTag, useFileFilter, useTextFilter, autoDetect, encoding);
        }
        catch (IRException e) {
            throw new IRException(e);
        }
    }

    public Extension retrieveExtension(String parentId, String name) {
        return this.filterSettingManager.retrieveExtension(parentId, name);
    }

    public List retrieveExtensionList(String parentId) {
        return this.filterSettingManager.retrieveExtensionList(parentId);
    }

    public void updateExtension(String parentId, String name, boolean removeHtmlTag, boolean useFileFilter, boolean useTextFilter) {
        this.updateExtension(parentId, name, removeHtmlTag, useFileFilter, useTextFilter, false, null);
    }

    public void updateExtension(String parentId, String name, boolean removeHtmlTag, boolean useFileFilter, boolean useTextFilter, boolean autoDetect, String encoding) {
        this.filterSettingManager.updateExtension(parentId, name, removeHtmlTag, useFileFilter, useTextFilter, autoDetect, encoding);
    }

    public void deleteExtension(String parentId, String name) {
        this.filterSettingManager.deleteExtension(parentId, name);
    }

    public Map getExceptions() {
        return this.exceptions;
    }
}

