/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.common.msg.ext.body.index.df.DFReqT;
import com.diquest.ir.common.msg.ext.body.index.df.DFResT;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;

public class CommandDFInfo {
    private final String ip;
    private final int port;
    ErrorMessage failMsg;
    private DFResT result;

    public CommandDFInfo(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public int request(String collection, String keywordInfoField, String[] keywords) throws IRException {
        DFReqT reqData = new DFReqT(collection, keywordInfoField, keywords);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.ExtMessageDFInfo", (Transmitable)reqData);
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        if (response == null) {
            this.failMsg = new ErrorMessage("Cannot connect to server.");
            return -60000;
        }
        if (response.getErrorCode() > -100) {
            this.result = (DFResT)response.getData();
        } else {
            this.failMsg = (ErrorMessage)response.getData();
        }
        return response.getErrorCode();
    }

    public DFResT getResult() {
        return this.result;
    }

    public ErrorMessage getException() {
        return this.failMsg;
    }

    public static void main(String[] args) throws IRException {
        if (args.length < 5) {
            System.out.println("Not enough arguments.");
            System.out.println("[IP] [PORT] [COLLECTIONID] [FIELDID] [KEYWORDS ....]");
            System.exit(args.length);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collection = args[2];
        String field = args[3];
        String[] keywords = null;
        int keywordSize = args.length - 4;
        if (keywordSize <= 0) {
            System.out.println("Empty keywords.");
            System.exit(-1);
        } else {
            keywords = new String[keywordSize];
            int i = 0;
            while (i < keywordSize) {
                keywords[i] = args[i + 4];
                ++i;
            }
        }
        CommandDFInfo command = new CommandDFInfo(ip, port);
        int resultCode = command.request(collection, field, keywords);
        if (resultCode != 1) {
            System.out.println("[ERROR]");
            ErrorMessage errorMessage = command.getException();
            System.out.println(errorMessage.getErrorMessage());
            System.out.println(errorMessage.getStackTrace());
        } else {
            DFResT result = command.getResult();
            String[] resultKeywords = result.getKeywords();
            int[] dfs = result.getDfs();
            int i = 0;
            while (i < resultKeywords.length) {
                System.out.println("[" + resultKeywords[i] + "][" + dfs[i] + "]");
                ++i;
            }
        }
    }
}

