/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.setting.ResApplySettingT;
import com.diquest.ir.common.setting.datasource.DataSourceSetting;
import com.diquest.ir.common.setting.datasource.ObjectFactory;
import com.diquest.ir.common.setting.manager.DataSourceSettingManager;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CommandDataSourceSetting {
    static ObjectFactory OF = new ObjectFactory();
    private Map exceptions = Collections.EMPTY_MAP;
    DataSourceSettingManager dataSourceSettingMgr = null;
    private final String userid;
    AdminServerClient client;

    public CommandDataSourceSetting(AdminServerClient client, String userid) throws IRException {
        this.client = client;
        this.userid = userid;
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageGetDataSourceSetting");
        ExtResponse response = this.client.invoke(request);
        this.dataSourceSettingMgr = (DataSourceSettingManager)response.getData();
    }

    public boolean addDataSourceSetting(String id, String driver, String url, String userid, String password, String desc) throws IRException {
        try {
            this.dataSourceSettingMgr.add(id, desc, driver, url, userid, password);
            return this.applySetting();
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot add a data source setting : " + id, (Throwable)e);
        }
    }

    public boolean modifyDataSourceSetting(String id, String driver, String url, String userid, String password, String description) throws IRException {
        try {
            this.dataSourceSettingMgr.modify(id, description, driver, url, userid, password);
            return this.applySetting();
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot modify a data source setting : " + id, (Throwable)e);
        }
    }

    public boolean applySetting() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageModifyDataSourceSetting", (Transmitable)this.dataSourceSettingMgr);
        ExtResponse response = this.client.invoke(request);
        return response != null && response.getErrorCode() >= 0;
    }

    public boolean applySetting2() throws IRException {
        this.exceptions = Collections.EMPTY_MAP;
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageApplyDataSource");
        ExtResponse response = this.client.invoke(request);
        if (response == null || response.getErrorCode() < 0 || response.getData() == null) {
            return false;
        }
        ResApplySettingT data = (ResApplySettingT)response.getData();
        this.exceptions = data.getExceptions();
        return data.isSuccess();
    }

    public DataSourceSetting getDataSourceSetting(String id) {
        return this.dataSourceSettingMgr.get(id);
    }

    public boolean removeDataSourceSetting(String id) throws IRException {
        try {
            this.dataSourceSettingMgr.delete(id);
            return this.applySetting();
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot remove a data source setting : " + id, (Throwable)e);
        }
    }

    public List getAllDataSourceSettings() {
        return this.dataSourceSettingMgr.getRootSettingObject().getDataSourceSetting();
    }

    public Map getExceptions() {
        return this.exceptions;
    }
}

