/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.ArrayT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;
import java.io.BufferedReader;
import java.io.File;

public class CommandExtractor {
    private final String ip;
    private final int port;
    ErrorMessage failMsg;

    public CommandExtractor(AdminServerClient adminserver) {
        this.ip = adminserver.ip;
        this.port = adminserver.port;
    }

    public CommandExtractor(String ip, int port) throws Exception {
        this.ip = ip;
        this.port = port;
    }

    public String[][] request(String extractor, String option, String keyword) throws IRException {
        DataT data = new DataT();
        DataT result = null;
        data.put("TYPE", (Transmitable)new StringT(extractor));
        data.put("OPTION", (Transmitable)new StringT(option));
        data.put("KEYWORD", (Transmitable)new StringT(keyword));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.ExtMessageExtractor", (Transmitable)data);
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        if (response == null) {
            this.failMsg = new ErrorMessage("Cannot connect to Server.");
            return null;
        }
        if (response.getErrorCode() < 0) {
            this.failMsg = new ErrorMessage("Fail to extract terms.");
            return null;
        }
        result = (DataT)response.getData();
        Transmitable[] resultList = ((ArrayT)result.get((String)"result")).value;
        Transmitable[] remnantList = ((ArrayT)result.get((String)"remnant")).value;
        Transmitable[] additionalList = ((ArrayT)result.get((String)"additional")).value;
        String[][] resultKeywords = new String[][]{StringT.convert((Transmitable[])resultList), StringT.convert((Transmitable[])remnantList), StringT.convert((Transmitable[])additionalList)};
        return resultKeywords;
    }

    public ErrorMessage getException() {
        return this.failMsg;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("usage : $IP $PORT $KEYWORD $EXTRACTOR $EXTRACTOR_OPTION");
            System.exit(args.length);
        }
        String ip = args[0].trim();
        int port = Integer.parseInt(args[1]);
        String keyword = args[2].trim();
        String extractor = args[3].trim();
        String option = null;
        if (args.length >= 5) {
            option = args[4].trim();
        }
        String[][] result = null;
        CommandExtractor commmand = new CommandExtractor(ip, port);
        File keywordFile = new File(keyword);
        if (keywordFile.exists()) {
            BufferedReader reader = FileUtil.getBufferedReader((String)keyword);
            String fKeyword = reader.readLine();
            while (fKeyword != null) {
                result = commmand.request(extractor, option, fKeyword);
                CommandExtractor.printResult(fKeyword, result);
                fKeyword = reader.readLine();
            }
        } else {
            result = commmand.request(extractor, option, keyword);
            CommandExtractor.printResult(keyword, result);
        }
    }

    public static void printResult(String keyword, String[][] result) {
        System.out.println("INPUT [" + keyword + "]");
        if (result == null || result.length != 3) {
            System.out.println("OUTPUT [#ERROR#]");
        } else {
            System.out.print("OUTPUT(result = " + result[0].length + ") ");
            int i = 0;
            while (i < result[0].length) {
                System.out.print("[" + result[0][i] + "] ");
                ++i;
            }
            System.out.println();
            System.out.print("OUTPUT(ramnent = " + result[1].length + ") ");
            i = 0;
            while (i < result[1].length) {
                System.out.print("[" + result[1][i] + "] ");
                ++i;
            }
            System.out.println();
            System.out.print("OUTPUT(additional  = " + result[2].length + ") ");
            i = 0;
            while (i < result[2].length) {
                System.out.print("[" + result[2][i] + "] ");
                ++i;
            }
            System.out.println();
        }
    }
}

