/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.client.util.JobDescription;
import com.diquest.ir.common.database.entity.IndexingJob;
import com.diquest.ir.common.database.handler.IndexingJobDB;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ProfileKey;
import com.diquest.ir.common.msg.ext.body.indexdb.DocumentAddT;
import com.diquest.ir.common.msg.ext.body.indexdb.DocumentRemoveT;
import com.diquest.ir.common.msg.ext.body.indexdb.IndexBuildAddT;
import com.diquest.ir.common.msg.ext.body.indexdb.IndexBuildAllT;
import com.diquest.ir.common.msg.ext.body.indexdb.IndexBuildUpdateT;
import com.diquest.ir.common.msg.ext.body.indexdb.IndexChangeT;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import java.sql.Connection;

public class CommandIndexDBManagement {
    IndexingJobDB indexJobDB;
    private final String userid;
    private final AdminServerClient client;

    public CommandIndexDBManagement(AdminServerClient client, String userid) throws Exception {
        this.client = client;
        this.userid = userid;
        this.indexJobDB = new IndexingJobDB();
    }

    public boolean indexBuildAll(Connection conn, String collectionID, String executor, JobDescription jobDescription, long created, long updated) throws IRException {
        IndexBuildAllT body = new IndexBuildAllT(collectionID, executor);
        ExtRequest extRequest = new ExtRequest("com.diquest.ir.server.msg.management.indexdb.ExtMessageIndexBuildAll", (Transmitable)body);
        return this.client.registerJob(conn, extRequest, jobDescription, this.userid, created, updated);
    }

    public boolean indexRebuild(Connection conn, String collectionID, String executor, JobDescription jobDescription, long created, long updated) throws IRException {
        IndexBuildAllT body = new IndexBuildAllT(collectionID, executor);
        ExtRequest extRequest = new ExtRequest("com.diquest.ir.server.msg.management.indexdb.ExtMessageIndexRebuild", (Transmitable)body);
        return this.client.registerJob(conn, extRequest, jobDescription, this.userid, created, updated);
    }

    public boolean indexBuildAdd(Connection conn, String collectionID, String executor, JobDescription jobDescription, long created, long updated) throws IRException {
        IndexBuildAddT body = new IndexBuildAddT(collectionID, executor);
        ExtRequest extRequest = new ExtRequest("com.diquest.ir.server.msg.management.indexdb.ExtMessageIndexBuildAdd", (Transmitable)body);
        return this.client.registerJob(conn, extRequest, jobDescription, this.userid, created, updated);
    }

    public boolean indexBuildUpdate(Connection conn, String collectionID, String executor, JobDescription jobDescription, long created, long updated) throws IRException {
        IndexBuildUpdateT body = new IndexBuildUpdateT(collectionID, executor);
        ExtRequest extRequest = new ExtRequest("com.diquest.ir.server.msg.management.indexdb.ExtMessageIndexBuildUpdate", (Transmitable)body);
        return this.client.registerJob(conn, extRequest, jobDescription, this.userid, created, updated);
    }

    public boolean indexChange(Connection conn, String collectionID, String executor, JobDescription jobDescription, long created, long updated) throws IRException {
        IndexChangeT body = new IndexChangeT(collectionID, executor);
        ExtRequest extRequest = new ExtRequest("com.diquest.ir.server.msg.management.indexdb.ExtMessageIndexChange", (Transmitable)body);
        return this.client.registerJob(conn, extRequest, jobDescription, this.userid, created, updated);
    }

    public boolean documentAdd(Connection conn, String collectionID, String[] docIDArray, String executor, JobDescription jobDescription, long created, long updated) throws IRException {
        DocumentAddT body = new DocumentAddT(collectionID, docIDArray);
        ExtRequest extRequest = new ExtRequest("com.diquest.ir.server.msg.management.indexdb.ExtMessageDocumentAdd", (Transmitable)body);
        return this.client.registerJob(conn, extRequest, jobDescription, this.userid, created, updated);
    }

    public boolean documentAdd(Connection conn, String collectionID, String[] docIDArray, String dbWatcher, String executor, JobDescription jobDescription, long created, long updated) throws IRException {
        DocumentAddT body = new DocumentAddT(collectionID, docIDArray, dbWatcher);
        ExtRequest extRequest = new ExtRequest("com.diquest.ir.server.msg.management.indexdb.ExtMessageDocumentAdd", (Transmitable)body);
        return this.client.registerJob(conn, extRequest, jobDescription, this.userid, created, updated);
    }

    public boolean documentRemove(Connection conn, String collectionID, String[] docIDArray, String executor, JobDescription jobDescription, long created, long updated) throws IRException {
        DocumentRemoveT body = new DocumentRemoveT(collectionID, docIDArray);
        ExtRequest extRequest = new ExtRequest("com.diquest.ir.server.msg.management.indexdb.ExtMessageDocumentDel", (Transmitable)body);
        return this.client.registerJob(conn, extRequest, jobDescription, this.userid, created, updated);
    }

    public IndexingJob notScheduleIndexAll(Connection conn, String collectionID, String executor) throws IRException {
        try {
            return this.indexJobDB.disable(conn, collectionID, 'A', executor);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot disable full index schedule.", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }

    public IndexingJob scheduleIndexAll(Connection conn, String collectionID, long indexCycle, char startDateType, long startDate, String executor, char limitEnable, long limitStart, long limitEnd) throws IRException {
        try {
            return this.indexJobDB.enable(conn, collectionID, 'A', indexCycle, startDateType, startDate, executor, limitEnable, limitStart, limitEnd);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot schedule full index.", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }

    public IndexingJob notScheduleIndexAdd(Connection conn, String collectionID, String executor) throws IRException {
        try {
            return this.indexJobDB.disable(conn, collectionID, 'B', executor);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot disable incremental index schedule.", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }

    public IndexingJob scheduleIndexAdd(Connection conn, String collectionID, long indexCycle, char startdate_type, long startDate, String executor, char limitEnable, long limitStart, long limitEnd) throws IRException {
        try {
            return this.indexJobDB.enable(conn, collectionID, 'B', indexCycle, startdate_type, startDate, executor, limitEnable, limitStart, limitEnd);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot scheduleincremental index.", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }

    public IndexingJob notScheduleIndexUpdate(Connection conn, String collectionID, String executor) throws IRException {
        try {
            return this.indexJobDB.disable(conn, collectionID, 'C', executor);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot disable field update index schedule.", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }

    public IndexingJob scheduleIndexUpdate(Connection conn, String collectionID, long indexCycle, char startdate_type, long startDate, String executor, char limitEnable, long limitStart, long limitEnd) throws IRException {
        try {
            return this.indexJobDB.enable(conn, collectionID, 'C', indexCycle, startdate_type, startDate, executor, limitEnable, limitStart, limitEnd);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot schedule field update index.", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }

    public IndexingJob notScheduleIndexRebuild(Connection conn, String collectionID, String executor) throws IRException {
        try {
            return this.indexJobDB.disable(conn, collectionID, 'R', executor);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot disable index rebuild schedule.", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }

    public IndexingJob scheduleIndexRebuild(Connection conn, String collectionID, long indexCycle, char startDateType, long startDate, String executor, char limitEnable, long limitStart, long limitEnd) throws IRException {
        try {
            return this.indexJobDB.enable(conn, collectionID, 'R', indexCycle, startDateType, startDate, executor, limitEnable, limitStart, limitEnd);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot schedulie index rebuild.", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
    }
}

