/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.common.msg.ext.body.index.KeyListReqT;
import com.diquest.ir.common.msg.ext.body.index.KeyListResT;
import com.diquest.ir.common.msg.protocol.query.Query;
import com.diquest.ir.common.msg.protocol.query.SelectSet;
import com.diquest.ir.common.msg.protocol.query.WhereSet;
import com.diquest.ir.common.msg.protocol.result.ResultSet;
import com.diquest.ir.common.setting.collection.CollectionSetting;
import com.diquest.ir.common.setting.collection.IndexField;
import com.diquest.ir.common.setting.collection.IndexSetting;
import com.diquest.ir.common.setting.collection.SchemaSetting;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.TransmitableUtil;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.ArrayT;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.DataT;
import java.util.List;

public class CommandIndexKeyList {
    String[] resultSet = null;
    ResultSet searchResultSet = null;
    boolean[] delListMark = null;
    ErrorMessage failMsg;
    AdminServerClient client;
    String userId;

    public CommandIndexKeyList(AdminServerClient client, String userId) throws Exception {
        this.client = client;
        this.userId = userId;
    }

    public int request(String collectionId, String indexId, String keyword, int start, int length) throws IRException {
        KeyListReqT keyListReq = new KeyListReqT(collectionId, indexId, keyword, start, length);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.ExtMessageIndexKeyList", (Transmitable)keyListReq);
        ExtResponse response = null;
        Object errorMsg = null;
        response = this.client.invoke(request);
        if (response == null) {
            this.failMsg = new ErrorMessage("Cannot connect to server.");
            return -60000;
        }
        if (response.getErrorCode() > -100) {
            this.resultSet = ((KeyListResT)response.getData()).getKeywords();
        } else {
            this.failMsg = (ErrorMessage)response.getData();
        }
        return response.getErrorCode();
    }

    public int search(CollectionSetting cs, String indexId, String keyword, int start, int length, int sumSize, String[] sField) throws IRException {
        Query q = new Query("<B>", "</B>");
        q.setResult(start, start + length - 1);
        q.setFrom(cs.getId());
        WhereSet whereSet = new WhereSet(indexId, 1, keyword);
        q.setWhere(new WhereSet[]{whereSet});
        String idField = null;
        List schemaSettings = cs.getSchemaSetting();
        int i = 0;
        while (i < schemaSettings.size()) {
            SchemaSetting ss = (SchemaSetting)schemaSettings.get(i);
            if (ss.isIdField()) {
                idField = ss.getId();
                break;
            }
            ++i;
        }
        List indexFields = null;
        List indexSettings = cs.getIndexSetting();
        int i2 = 0;
        while (i2 < indexSettings.size()) {
            IndexSetting is = (IndexSetting)indexSettings.get(i2);
            if (is.getId().equalsIgnoreCase(indexId)) {
                indexFields = is.getIndexField();
                break;
            }
            ++i2;
        }
        if (indexFields == null) {
            return -1;
        }
        int sFieldLeng = 0;
        sFieldLeng = sField != null ? sField.length : 0;
        SelectSet[] selectSet = new SelectSet[indexFields.size() * 2 + 1 + sFieldLeng];
        int selectCurrent = 0;
        selectSet[selectCurrent++] = new SelectSet(idField);
        int i3 = 0;
        while (i3 < indexFields.size()) {
            String fieldID = ((IndexField)indexFields.get(i3)).getId();
            selectSet[selectCurrent++] = new SelectSet(fieldID, 19, sumSize);
            selectSet[selectCurrent++] = new SelectSet(fieldID, 18, sumSize);
            ++i3;
        }
        if (sField != null) {
            i3 = 0;
            while (i3 < sFieldLeng) {
                selectSet[selectCurrent++] = new SelectSet(sField[i3], 16);
                ++i3;
            }
        }
        q.setSelect(selectSet);
        q.setDebug(true);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.ExtMessageIndexKeyDocList", (Transmitable)q);
        ExtResponse response = null;
        Object errorMsg = null;
        response = this.client.invoke(request);
        if (response == null) {
            this.failMsg = new ErrorMessage("Cannot connect to Server.");
            return -60000;
        }
        if (response.getErrorCode() > -100) {
            DataT resData = (DataT)response.getData();
            this.searchResultSet = (ResultSet)resData.get("resultSet");
            Transmitable[] trs = ((ArrayT)resData.get((String)"delListMarkArray")).value;
            BooleanT[] delList = (BooleanT[])TransmitableUtil.copy((Transmitable[])trs, (Transmitable[])new BooleanT[trs.length]);
            this.delListMark = new boolean[delList.length];
            int delLen = delList.length;
            int i4 = 0;
            while (i4 < delLen) {
                this.delListMark[i4] = delList[i4].value;
                ++i4;
            }
        } else {
            this.failMsg = (ErrorMessage)response.getData();
        }
        return response.getErrorCode();
    }

    public String[] getKeyList() {
        return this.resultSet;
    }

    public ResultSet getSearchResult() {
        return this.searchResultSet;
    }

    public boolean[] getDelListMark() {
        return this.delListMark;
    }

    public ErrorMessage getException() {
        return this.failMsg;
    }

    public String getErrorMsg() {
        String errorMsg = this.failMsg.getErrorMessage();
        return errorMsg.substring(errorMsg.indexOf(":") + 1);
    }

    public static void main(String[] args) throws Exception {
        CommandIndexKeyList command = new CommandIndexKeyList(new AdminServerClient("localhost", 5555), "test");
        int errorCode = command.request("blog", "P_CONTENT", "\ube14\ub85c\uadf8", 0, 100);
        String[] keylist = command.getKeyList();
        int i = 0;
        while (i < keylist.length) {
            System.out.println("[" + i + "]" + keylist[i]);
            ++i;
        }
    }
}

