/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.database.entity.ErrorLog;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.ArrayT;
import com.diquest.ir.util.msg.type.IntegerT;
import java.sql.SQLException;
import java.util.Date;

public class CommandMailReporter {
    private final AdminServerClient client;
    private final String user;

    public CommandMailReporter(String ip, int port, String user) {
        this.client = new AdminServerClient(ip, port);
        this.user = user;
    }

    public CommandMailReporter(AdminServerClient client, String user) {
        this.client = client;
        this.user = user;
    }

    public boolean sendMailReport(int errorID) throws SQLException, IRException {
        int[] errorIDs = new int[]{errorID};
        return this.sendMailReport(errorIDs);
    }

    public boolean sendMailReport(int[] errorID) throws SQLException, IRException {
        IntegerT[] errorIDs = new IntegerT[errorID.length];
        int i = 0;
        while (i < errorID.length) {
            errorIDs[i] = new IntegerT(errorID[i]);
            ++i;
        }
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.ExtMessageSendMailReport", (Transmitable)new ArrayT((Transmitable[])errorIDs));
        ExtResponse response = this.client.invoke(request);
        return response != null && response.getErrorCode() >= 0;
    }

    public static void main(String[] args) throws IRException, SQLException {
        String propHome = System.getProperty("IR_HOME");
        CommandMailReporter reporter = new CommandMailReporter("localhost", 5555, "user");
        ErrorLog error = new ErrorLog(0, 65, 0, "adminServer", "localhost", new Date(System.currentTimeMillis()), 1, "ErrorMessage", "ServiceStack", "RawStack");
    }
}

