/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.setting.ResApplySettingT;
import com.diquest.ir.common.setting.mailreporter.MailReporterSetting;
import com.diquest.ir.common.setting.mailreporter.ObjectFactory;
import com.diquest.ir.common.setting.manager.MailReporterSettingManager;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.XmlT;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.JAXBException;

public class CommandMailReporterSetting {
    private Map exceptions = Collections.EMPTY_MAP;
    private final String userid;
    private final AdminServerClient client;

    public CommandMailReporterSetting(String ip, int port, String userid) throws IRException {
        this.client = new AdminServerClient(ip, port);
        this.userid = userid;
    }

    public CommandMailReporterSetting(AdminServerClient client, String userid) {
        this.client = client;
        this.userid = userid;
    }

    public MailReporterSetting getSetting() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageGetMailReporterSetting");
        try {
            ExtResponse response = this.client.invoke(request);
            XmlT xmlT = (XmlT)response.getData();
            MailReporterSetting mailReporterSetting = (MailReporterSetting)xmlT.getSettingObject();
            return mailReporterSetting;
        }
        catch (IRException e) {
            throw new IRException(2, "An Error is occurred during getting mailreporter setting: ", (Throwable)e);
        }
    }

    public boolean modifySetting(boolean auth, String hostname, String username, String password, String from, String personal, String to, boolean useMailReport) throws IRException {
        ObjectFactory OF = new ObjectFactory();
        MailReporterSetting mailReporterSetting = null;
        try {
            mailReporterSetting = OF.createMailReporterSetting();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        mailReporterSetting.setAuth(auth);
        mailReporterSetting.setHostname(hostname);
        mailReporterSetting.setUsername(username);
        mailReporterSetting.setPassword(password);
        mailReporterSetting.setFrom(from);
        mailReporterSetting.setPersonal(personal);
        mailReporterSetting.setTo(to);
        mailReporterSetting.setUseMailReport(useMailReport);
        return this.modifySetting(mailReporterSetting);
    }

    public boolean modifySetting(boolean auth, int errorLevel, String hostname, boolean starttls, String username, String password, String from, String personal, String to, boolean useMailReport) throws IRException {
        ObjectFactory OF = new ObjectFactory();
        MailReporterSetting mailReporterSetting = null;
        try {
            mailReporterSetting = OF.createMailReporterSetting();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        mailReporterSetting.setAuth(auth);
        mailReporterSetting.setErrorLevel(errorLevel);
        mailReporterSetting.setHostname(hostname);
        mailReporterSetting.setUsername(username);
        mailReporterSetting.setPassword(password);
        mailReporterSetting.setFrom(from);
        mailReporterSetting.setPersonal(personal);
        mailReporterSetting.setTo(to);
        mailReporterSetting.setUseMailReport(useMailReport);
        mailReporterSetting.setStarttls(starttls);
        return this.modifySetting(mailReporterSetting);
    }

    public boolean modifySetting(MailReporterSetting mailReporterSetting) throws IRException {
        try {
            return this.modifySetting(MailReporterSettingManager.readFromObject((Object)mailReporterSetting));
        }
        catch (IRException e) {
            throw new IRException(2, "An Error is occurred during modifyinging MailReporter setting: ", (Throwable)e);
        }
    }

    public boolean modifySetting(MailReporterSettingManager mailReporterSettingManager) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageModifyMailReportSetting", (Transmitable)mailReporterSettingManager);
        ExtResponse response = this.client.invoke(request);
        return response != null && response.getErrorCode() >= 0;
    }

    public boolean testMailReport(boolean auth, String hostname, boolean starttls, String username, String password, String from, String personal, String to, boolean useMailReport) throws IRException {
        ObjectFactory OF = new ObjectFactory();
        MailReporterSetting mailReporterSetting = null;
        try {
            mailReporterSetting = OF.createMailReporterSetting();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        mailReporterSetting.setAuth(auth);
        mailReporterSetting.setHostname(hostname);
        mailReporterSetting.setUsername(username);
        mailReporterSetting.setPassword(password);
        mailReporterSetting.setFrom(from);
        mailReporterSetting.setPersonal(personal);
        mailReporterSetting.setTo(to);
        mailReporterSetting.setUseMailReport(useMailReport);
        mailReporterSetting.setStarttls(starttls);
        return this.testMailReport(mailReporterSetting);
    }

    public boolean testMailReport(boolean auth, int errorLevel, String hostname, boolean starttls, String username, String password, String from, String personal, String to, boolean useMailReport) throws IRException {
        ObjectFactory OF = new ObjectFactory();
        MailReporterSetting mailReporterSetting = null;
        try {
            mailReporterSetting = OF.createMailReporterSetting();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        mailReporterSetting.setAuth(auth);
        mailReporterSetting.setErrorLevel(errorLevel);
        mailReporterSetting.setHostname(hostname);
        mailReporterSetting.setUsername(username);
        mailReporterSetting.setPassword(password);
        mailReporterSetting.setFrom(from);
        mailReporterSetting.setPersonal(personal);
        mailReporterSetting.setTo(to);
        mailReporterSetting.setUseMailReport(useMailReport);
        mailReporterSetting.setStarttls(starttls);
        return this.testMailReport(mailReporterSetting);
    }

    public boolean testMailReport(MailReporterSetting mailReporterSetting) throws IRException {
        try {
            return this.testMailReport(MailReporterSettingManager.readFromObject((Object)mailReporterSetting));
        }
        catch (IRException e) {
            throw new IRException(2, "An Error is occurred during modifyinging MailReporter setting: ", (Throwable)e);
        }
    }

    public boolean testMailReport(MailReporterSettingManager mailReporterSettingManager) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageTestMailReportSetting", (Transmitable)mailReporterSettingManager);
        ExtResponse response = this.client.invoke(request);
        return response != null && response.getErrorCode() >= 0;
    }

    public boolean applySetting() throws IRException {
        this.exceptions = Collections.EMPTY_MAP;
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageApplyMailReporter");
        ExtResponse response = this.client.invoke(request);
        if (response == null || response.getErrorCode() < 0 || response.getData() == null) {
            return false;
        }
        ResApplySettingT data = (ResApplySettingT)response.getData();
        this.exceptions = data.getExceptions();
        return data.isSuccess();
    }

    public Map getExceptions() {
        return this.exceptions;
    }
}

