/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.LongT;

public class CommandNetwork {
    private final String ip;
    private final int port;
    ErrorMessage failMsg;

    public CommandNetwork(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public int disconnectExtNetwork(long timeout) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.system.ExtMessageDisconnectExtNetwork", (Transmitable)new LongT(timeout));
        ExternalClientPool targetPool = ExternalClientPool.getInstance(this.ip, this.port);
        ExtResponse response = targetPool.invoke(request, targetPool.getPoolWaitTimeout());
        if (response == null) {
            this.failMsg = new ErrorMessage("Cannot connect to Server.");
            return -60000;
        }
        if (response.getErrorCode() == 1) {
            return 1;
        }
        this.failMsg = (ErrorMessage)response.getData();
        return response.getErrorCode();
    }

    public ErrorMessage getException() {
        return this.failMsg;
    }

    public static void main(String[] args) throws IRException {
        if (args.length < 3) {
            System.out.println("$usage : [ADMIN-IP] [ADMIN-PORT] [TIMEOUT(ms)]");
            System.exit(args.length);
        }
        String ip = args[0].trim();
        int port = Integer.parseInt(args[1].trim());
        long timeout = Long.parseLong(args[2].trim());
        CommandNetwork network = new CommandNetwork(ip, port);
        network.disconnectExtNetwork(timeout);
    }
}

