/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.common.msg.protocol.query.QuerySet;
import com.diquest.ir.common.msg.protocol.result.ResultSet;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;

public class CommandSearchRequest {
    private final String ip;
    private final int port;
    ResultSet resultSet;
    ErrorMessage failMsg;

    public CommandSearchRequest(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public int request(QuerySet querySet) throws IRException {
        this.resultSet = null;
        this.failMsg = null;
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.ExtMessageSearchRequest", (Transmitable)querySet);
        ExternalClientPool targetPool = ExternalClientPool.getInstance(this.ip, this.port);
        ExtResponse response = targetPool.invoke(request, targetPool.getPoolWaitTimeout());
        if (response == null) {
            this.failMsg = new ErrorMessage("Cannot connect to Server.");
            return -60000;
        }
        if (response.getErrorCode() > -100) {
            this.resultSet = (ResultSet)response.getData();
        } else {
            this.failMsg = (ErrorMessage)response.getData();
        }
        return response.getErrorCode();
    }

    public static boolean setProps(String ip, int port, int poolWaitTimeout, int minPoolSize, int maxPoolSize) {
        return ExternalClientPool.getInstance(ip, port).setProps(poolWaitTimeout, minPoolSize, maxPoolSize);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public ErrorMessage getException() {
        return this.failMsg;
    }
}

