/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.CommandSearchRequest;
import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.common.msg.protocol.query.OrderBySet;
import com.diquest.ir.common.msg.protocol.query.Query;
import com.diquest.ir.common.msg.protocol.query.QuerySet;
import com.diquest.ir.common.msg.protocol.query.SelectSet;
import com.diquest.ir.common.msg.protocol.query.WhereSet;
import com.diquest.ir.common.msg.protocol.result.ResultSet;
import com.diquest.ir.common.msg.simulation.SimulationResult;
import com.diquest.ir.util.msg.Message;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import java.io.IOException;

public class CommandSearchSimulation {
    private final String ip;
    private final int port;
    SimulationResult resultSet;
    ErrorMessage failMsg;

    public CommandSearchSimulation(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public int request(Query query, boolean displayRemoved, boolean fromDB, String keyStartTag, String keyEndTag) throws IRException, IOException {
        this.resultSet = null;
        this.failMsg = null;
        Message data = new Message(5);
        data.setBoolean(0, displayRemoved);
        data.setBoolean(1, fromDB);
        data.setString(2, keyStartTag);
        data.setString(3, keyEndTag);
        data.set(4, (Transmitable)query);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.ExtMessageSearchSimulation", (Transmitable)data);
        ExternalClientPool targetPool = ExternalClientPool.getInstance(this.ip, this.port);
        ExtResponse response = targetPool.invoke(request, 20000);
        if (response == null) {
            this.failMsg = new ErrorMessage("Cannot connect to Server.");
            return -60000;
        }
        if (response.getErrorCode() > -100) {
            this.resultSet = (SimulationResult)response.getData();
        } else {
            this.failMsg = (ErrorMessage)response.getData();
        }
        return response.getErrorCode();
    }

    public static boolean setProps(String ip, int port, int poolWaitTimeout, int minPoolSize, int maxPoolSize) {
        return ExternalClientPool.getInstance(ip, port).setProps(poolWaitTimeout, minPoolSize, maxPoolSize);
    }

    public SimulationResult getSimulationResult() {
        return this.resultSet;
    }

    public ErrorMessage getException() {
        return this.failMsg;
    }

    public static void main(String[] args) throws IRException, IOException {
        long st = System.currentTimeMillis();
        CommandSearchSimulation.simulation();
        long ed = System.currentTimeMillis();
        System.out.println(String.valueOf(ed - st) + "ms");
    }

    public static void search() throws IRException {
        String keyword = "\uc640\uc778";
        CommandSearchRequest command = new CommandSearchRequest("118.217.147.7", 3333);
        QuerySet querySet = new QuerySet(1);
        Query query = new Query("[", "]");
        query.setFrom("WINE");
        query.setSearchOption(10);
        query.setThesaurusOption(3);
        query.setResult(0, 10);
        query.setSelect(new SelectSet[]{new SelectSet("DOCID"), new SelectSet("CONTS_TITL"), new SelectSet("CONTS_CONTS"), new SelectSet("CONTS_KGCD"), new SelectSet("SALES_COUNT"), new SelectSet("STOCK_COUNT"), new SelectSet("SALES_PRICE"), new SelectSet("WEIGHT")});
        query.setWhere(new WhereSet[]{new WhereSet("CONTS_TITL", 2, keyword, 1000), new WhereSet(6), new WhereSet("CONTENT", 2, keyword, 100)});
        query.setOrderby(new OrderBySet[]{new OrderBySet(true, "NUM1NUM2")});
        querySet.addQuery(query);
        int errorCode = command.request(querySet);
        ResultSet resultSet = command.getResultSet();
        System.out.println(resultSet.getResult(0).toString());
    }

    public static void simulation() throws IRException, IOException {
        String keyword = "\ub2e4\uc774\ubc84";
        CommandSearchSimulation command = new CommandSearchSimulation("192.168.0.188", 5555);
        QuerySet querySet = new QuerySet(1);
        Query query = new Query("[", "]");
        query.setFrom("test");
        query.setSearchOption(10);
        query.setThesaurusOption(3);
        query.setRankingOption(7);
        query.setProfile("test2");
        query.setResult(0, 10);
        query.setSelect(new SelectSet[]{new SelectSet("ID"), new SelectSet("TITLE"), new SelectSet("CONTENT"), new SelectSet("NUM1"), new SelectSet("NUM2"), new SelectSet("CAT1"), new SelectSet("CAT2"), new SelectSet("WEIGHT")});
        query.setWhere(new WhereSet[]{new WhereSet("TITLE", 2, keyword, 1000), new WhereSet(6), new WhereSet("CONTENT", 2, keyword, 100)});
        query.setOrderby(new OrderBySet[]{new OrderBySet(true, "NUM1NUM2")});
        querySet.addQuery(query);
        int errorCode = command.request(query, true, false, "<", ">");
        SimulationResult resultSet = command.getSimulationResult();
        System.out.println("[EXTRACTED RESULT]");
        System.out.println(resultSet.getExtractedResult().toString());
        System.out.println(resultSet.getDocumentResults().toString());
        System.out.println(resultSet.getSearchResult().toString());
    }
}

