/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.CommandAdminServerSetting;
import com.diquest.ir.client.command.ServerManagerClient;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.setting.ReqApplyServerT;
import com.diquest.ir.common.msg.ext.body.setting.ResAddServerT;
import com.diquest.ir.common.msg.ext.body.setting.ResApplySettingT;
import com.diquest.ir.common.setting.manager.ClientProperties;
import com.diquest.ir.common.setting.serverlist.Server;
import com.diquest.ir.common.setting.serverlist.ServerList;
import com.diquest.ir.common.setting.serversetting.ServerSetting;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.JAXBException;

public class CommandServerSetting {
    CommandAdminServerSetting adCommand;
    ServerManagerClient serverManagerClient;
    private Map exceptions = null;

    public CommandServerSetting(ClientProperties properties) {
        this.adCommand = new CommandAdminServerSetting((String)properties.getAdminServer()[0], (Integer)properties.getAdminServer()[1]);
        this.serverManagerClient = new ServerManagerClient(properties);
    }

    public ServerList getServerList() throws IRException {
        return this.adCommand.getServerList();
    }

    public Server getServer(String serverName) throws IRException {
        return this.adCommand.getServer(serverName);
    }

    public ServerSetting getServerSetting(String serverName) throws IRException {
        return this.adCommand.getServerSetting(serverName);
    }

    public boolean remove(int group, int id) throws IRException {
        try {
            Server serverInfo = this.adCommand.getServerInfo(group, id);
            this.serverManagerClient.stop(serverInfo.getIp(), group, id);
        }
        catch (IRException iRException) {
            // empty catch block
        }
        this.adCommand.remove(group, id);
        this.serverManagerClient.remove(group, id);
        return true;
    }

    public int add(int group, String ip, int keyPort, String name, String prefix, String description) throws IRException {
        ResAddServerT response = this.adCommand.addServer(group, ip, keyPort, name, prefix, description, 5000, 10000, 0, 0, 0, 60000L, 60000L, 30000L, 10000L, 20, 20, 86400000L, "128M", "128M", "0", 0, "");
        if (response.isSettable()) {
            this.serverManagerClient.add(group, response.getServerID(), ip, keyPort, name, prefix);
        }
        return response.isSettable() ? response.getServerID() : -1;
    }

    public boolean apply() throws IRException {
        this.exceptions = Collections.EMPTY_MAP;
        ExtRequest req = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageApplyServer", (Transmitable)new ReqApplyServerT());
        ExtResponse response = this.adCommand.client.invoke(req);
        if (response == null || response.getErrorCode() < 0 || response.getData() == null) {
            return false;
        }
        ResApplySettingT data = (ResApplySettingT)response.getData();
        this.exceptions = data.getExceptions();
        return data.isSuccess();
    }

    public boolean applyAdd(int serverGroup, int serverID, String serverName, String ip, int port, String prefix) throws IRException {
        this.exceptions = Collections.EMPTY_MAP;
        ExtRequest req = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageApplyServer", (Transmitable)new ReqApplyServerT(serverGroup, serverID, serverName, ip, port, prefix));
        ExtResponse response = this.adCommand.client.invoke(req);
        if (response == null || response.getErrorCode() < 0 || response.getData() == null) {
            return false;
        }
        ResApplySettingT data = (ResApplySettingT)response.getData();
        this.exceptions = data.getExceptions();
        return data.isSuccess();
    }

    public boolean applyModify(int serverGroup, int serverID, String serverName) throws IRException {
        this.exceptions = Collections.EMPTY_MAP;
        ExtRequest req = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageApplyServer", (Transmitable)new ReqApplyServerT(serverGroup, serverID, serverName));
        ExtResponse response = this.adCommand.client.invoke(req);
        if (response == null || response.getErrorCode() < 0 || response.getData() == null) {
            return false;
        }
        ResApplySettingT data = (ResApplySettingT)response.getData();
        this.exceptions = data.getExceptions();
        return data.isSuccess();
    }

    public boolean modify(int serverGroup, int serverID, String serverIP, int keyPort, String serverName, String serverPrefix, String serverDesc, int joinWaitTime, int receiverHandshakeTimeout, int receiverBackLogSize, int externalReceiverBackLogSize, int externalReceiverMaxThread, long externalReceiverTimeout, long ldtTimeout, long receiveSyncTimeout, long checkAliveTimeout, int maxSize, int minSize, long keepAliveTime, String workCacheSize, String businessBufferSize, String searchCacheSize, int searchCacheResultSizeLimit) throws IRException {
        boolean modify;
        try {
            modify = this.adCommand.modify(serverGroup, serverID, serverIP, keyPort, serverName, serverPrefix, serverDesc, joinWaitTime, receiverHandshakeTimeout, receiverBackLogSize, externalReceiverBackLogSize, externalReceiverMaxThread, externalReceiverTimeout, ldtTimeout, receiveSyncTimeout, checkAliveTimeout, maxSize, minSize, keepAliveTime, workCacheSize, businessBufferSize, searchCacheSize, searchCacheResultSizeLimit);
        }
        catch (JAXBException e) {
            throw new IRException(2, "A JAXBException is occurred during modifying server setting.", (Throwable)e);
        }
        return modify;
    }

    public boolean modify(int serverGroup, int serverID, String serverIP, int keyPort, String serverName, String serverPrefix, String serverDesc, int joinWaitTime, int receiverHandshakeTimeout, int receiverBackLogSize, int externalReceiverBackLogSize, int externalReceiverMaxThread, long externalReceiverTimeout, long ldtTimeout, long receiveSyncTimeout, long checkAliveTimeout, int maxSize, int minSize, long keepAliveTime, String workCacheSize, String businessBufferSize, String searchCacheSize, int searchCacheResultSizeLimit, String jianaVersion) throws IRException {
        boolean modify;
        try {
            modify = this.adCommand.modify(serverGroup, serverID, serverIP, keyPort, serverName, serverPrefix, serverDesc, joinWaitTime, receiverHandshakeTimeout, receiverBackLogSize, externalReceiverBackLogSize, externalReceiverMaxThread, externalReceiverTimeout, ldtTimeout, receiveSyncTimeout, checkAliveTimeout, maxSize, minSize, keepAliveTime, workCacheSize, businessBufferSize, searchCacheSize, searchCacheResultSizeLimit, jianaVersion);
        }
        catch (JAXBException e) {
            throw new IRException(2, "A JAXBException is occurred during modifying server setting.", (Throwable)e);
        }
        return modify;
    }

    public Map getExceptions() {
        return this.exceptions;
    }
}

