/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.common.msg.status.IndexingStatus;
import com.diquest.ir.common.msg.status.SystemStatus;
import com.diquest.ir.common.setting.manager.ClientProperties;
import com.diquest.ir.util.msg.Message;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.IntegerT;
import com.diquest.ir.util.msg.type.StringT;

public class CommandStatus {
    AdminServerClient adminServerClient;
    private ErrorMessage failMsg;
    private SystemStatus systemStatus;
    private IndexingStatus indexingStatus;

    public CommandStatus(ClientProperties properties) {
        Object[] adminserver = properties.getAdminServer();
        Object[] servermanagers = properties.getServerManagers();
        this.adminServerClient = new AdminServerClient((String)adminserver[0], (Integer)adminserver[1]);
    }

    public int requestSystemStatus(int serverGroup, int serverID) throws IRException {
        Message data = new Message(2);
        data.set(0, (Transmitable)new IntegerT(serverGroup));
        data.set(1, (Transmitable)new IntegerT(serverID));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.status.ExtMessageGetSystemStatus", (Transmitable)data);
        ExtResponse response = this.adminServerClient.invoke(request);
        if (response == null) {
            return -60000;
        }
        if (response.getErrorCode() < 0) {
            this.failMsg = (ErrorMessage)response.getData();
            return -1;
        }
        this.systemStatus = (SystemStatus)response.getData();
        return 0;
    }

    public int requestIndexingStatus(String collectionId) throws IRException {
        StringT data = new StringT(collectionId);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.status.ExtMessageGetIndexingStatus", (Transmitable)data);
        ExtResponse response = this.adminServerClient.invoke(request);
        if (response == null) {
            return -60000;
        }
        if (response.getErrorCode() < 0) {
            this.failMsg = (ErrorMessage)response.getData();
            return -1;
        }
        this.indexingStatus = (IndexingStatus)response.getData();
        return 0;
    }

    public ErrorMessage getException() {
        return this.failMsg;
    }

    public IndexingStatus getIndexingStatus() {
        return this.indexingStatus;
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public int requestSetCancelIndexStatus(String collectionId) throws IRException {
        StringT data = new StringT(collectionId);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.status.ExtMessageSetCancelIndexingStatus", (Transmitable)data);
        ExtResponse response = this.adminServerClient.invoke(request);
        if (response == null) {
            return -60000;
        }
        if (response.getErrorCode() < 0) {
            this.failMsg = (ErrorMessage)response.getData();
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        String home = "C:\\M2S";
        Object[] adminserver = new Object[]{"localhost", new Integer(5555)};
        Object[] servermanagers = new Object[]{new Object[]{"localhost", new Integer(5005)}};
        ClientProperties properties = new ClientProperties(adminserver, servermanagers, home);
        int i = 0;
        while (i < 10000) {
            CommandStatus command = new CommandStatus(properties);
            System.out.println("===================================================");
            int returnCode = command.requestSystemStatus(83, 0);
            SystemStatus systemStatus = command.getSystemStatus();
            System.out.println(systemStatus);
            Thread.sleep(1000L);
            ++i;
        }
    }
}

