/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.TaskMonitorKey;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.ByteT;
import com.diquest.ir.util.msg.type.StringT;

public class CommandTaskMonitor {
    AdminServerClient client;
    String userid;

    public CommandTaskMonitor(String ip, int port, String userID) {
        this.client = new AdminServerClient(ip, port);
        this.userid = userID;
    }

    public CommandTaskMonitor(AdminServerClient client, String userID) {
        this.client = client;
        this.userid = userID;
    }

    public CommandTaskMonitor(String ip, int port) {
        this.client = new AdminServerClient(ip, port);
        this.userid = "";
    }

    public CommandTaskMonitor() {
    }

    public boolean isRunning(String taskName) throws IRException {
        if (taskName == null) {
            throw new NullPointerException("TaskName is null.");
        }
        if (taskName.equals("") || taskName.length() == 0) {
            throw new IRException("TaskName is empty.");
        }
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.taskmonitor.ExtMessageIsRunningTaskMonitor", (Transmitable)new StringT(taskName));
        ExtResponse response = this.client.invoke(request);
        BooleanT isRunning = (BooleanT)response.getData();
        return isRunning.value;
    }

    public byte getStatus(String taskName) throws IRException {
        if (taskName == null) {
            throw new NullPointerException("TaskName is null.");
        }
        if (taskName.equals("") || taskName.length() == 0) {
            throw new IRException("TaskName is empty.");
        }
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.taskmonitor.ExtMessageGetTaskMonitor", (Transmitable)new StringT(taskName));
        ExtResponse response = this.client.invoke(request);
        ByteT statusT = (ByteT)response.getData();
        return statusT.value;
    }

    public void setStatus(String taskName, byte status) throws IRException {
        if (taskName == null) {
            throw new NullPointerException("TaskName is null.");
        }
        if (taskName.equals("") || taskName.length() == 0) {
            throw new IRException("TaskName is empty.");
        }
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.taskmonitor.ExtMessageSetTaskMonitor", (Transmitable)new TaskMonitorKey(taskName, status));
        ExtResponse response = this.client.invoke(request);
    }

    public void removeStatus(String taskName) throws IRException {
        if (taskName == null) {
            throw new NullPointerException("TaskName is null.");
        }
        if (taskName.equals("") || taskName.length() == 0) {
            throw new IRException("TaskName is empty.");
        }
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.taskmonitor.ExtMessageRemoveTaskMonitor", (Transmitable)new StringT(taskName));
        ExtResponse response = this.client.invoke(request);
    }

    public void removeAllStatus() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.taskmonitor.ExtMessageRemoveAllTaskMonitor");
        ExtResponse response = this.client.invoke(request);
    }
}

