/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.network.ExternalClientWorker;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.common.msg.ext.body.common.ServerKey;
import com.diquest.ir.common.msg.ext.body.setting.WDReqAddServerT;
import com.diquest.ir.common.msg.ext.body.setting.WDReqRemoveServerT;
import com.diquest.ir.common.setting.manager.ClientProperties;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;

public class ServerManagerClient {
    private final ClientProperties properties;

    public ServerManagerClient(ClientProperties properties) {
        this.properties = properties;
    }

    public boolean isAlive(String ip, int port) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.mgr.msg.WDMessageIsAlive");
        ExtResponse response = this.invoke(request, ip, port);
        return response != null && response.getErrorCode() >= 0;
    }

    public void stopActiveServers() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.mgr.msg.WDMessageStopActiveServers");
        Object[] servermanagers = this.properties.getServerManagers();
        int i = 0;
        while (i < servermanagers.length) {
            Object[] servermanager = (Object[])servermanagers[i];
            String ip = (String)servermanager[0];
            int port = (Integer)servermanager[1];
            ExtResponse response = null;
            try {
                response = this.invoke(request, ip, port);
            }
            catch (Exception e) {
                throw new IRException(2, "Cannot stop active servers. An Exception is occurred during sending message to ServerManager[ip:" + ip + ",port:" + port + "]", (Throwable)e);
            }
            if (response.getErrorCode() < 0) {
                ErrorMessage error = (ErrorMessage)response.getData();
                throw new IRException(2, "Cannot stop active servers." + error.getErrorMessage());
            }
            ++i;
        }
    }

    public void startActiveServers() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.mgr.msg.WDMessageStartActiveServers");
        Object[] servermanagers = this.properties.getServerManagers();
        int i = 0;
        while (i < servermanagers.length) {
            Object[] servermanager = (Object[])servermanagers[i];
            String ip = (String)servermanager[0];
            int port = (Integer)servermanager[1];
            ExtResponse response = null;
            try {
                response = this.invoke(request, ip, port);
            }
            catch (Exception e) {
                throw new IRException(2, "Cannot start active servers. An Exception is occurred during sending message to ServerManager[ip:" + ip + ",port:" + port + "]", (Throwable)e);
            }
            if (response.getErrorCode() < 0) {
                ErrorMessage error = (ErrorMessage)response.getData();
                throw new IRException(2, "Cannot start active servers." + error.getErrorMessage());
            }
            ++i;
        }
    }

    public void start(String ip, int group, int id) throws IRException {
        ServerKey body = new ServerKey(group, id);
        ExtRequest request = new ExtRequest("com.diquest.ir.mgr.msg.WDMessageStartServer", (Transmitable)body);
        int port = this.properties.getServerManagerPort(ip);
        ExtResponse response = null;
        try {
            response = this.invoke(request, ip, port);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot start server[Group=" + group + " ID=" + id + "].", (Throwable)e);
        }
        if (response.getErrorCode() < 0) {
            ErrorMessage error = (ErrorMessage)response.getData();
            throw new IRException(2, "Cannot start server[Group=" + group + " ID=" + id + "]. " + error.getErrorMessage());
        }
    }

    public void stop(String ip, int group, int id) throws IRException {
        ServerKey body = new ServerKey(group, id);
        ExtRequest request = new ExtRequest("com.diquest.ir.mgr.msg.WDMessageStopServer", (Transmitable)body);
        int port = this.properties.getServerManagerPort(ip);
        ExtResponse response = null;
        try {
            response = this.invoke(request, ip, port);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot stop server[Group=" + group + " ID=" + id + "]. " + "An Exception is occurred during sending message to ServerManager[ip:" + ip + ",port:" + port + "]", (Throwable)e);
        }
        if (response.getErrorCode() < 0) {
            ErrorMessage error = (ErrorMessage)response.getData();
            throw new IRException(2, "Cannot stop the server[Group=" + group + " ID=" + id + "]. " + error.getErrorMessage());
        }
        if (!((BooleanT)response.getData()).value) {
            throw new IRException(2, "Cannot stop the server[Group=" + group + " ID=" + id + "].");
        }
    }

    public ExtResponse invoke(ExtRequest request, String ip, int port) throws IRException {
        ExternalClientWorker worker = new ExternalClientWorker(ip, port);
        ExtResponse response = null;
        try {
            response = worker.invoke(request);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot send message to ServerManager[ip:" + ip + ",port:" + port + "]", (Throwable)e);
        }
        return response;
    }

    public void add(int group, int id, String ip, int port, String name, String prefix) throws IRException {
        WDReqAddServerT requestData = new WDReqAddServerT(ip, port, group, id, prefix, name);
        ExtRequest request = new ExtRequest("com.diquest.ir.mgr.msg.WDMessageAddServer", (Transmitable)requestData);
        Object[] servermanagers = this.properties.getServerManagers();
        int i = 0;
        while (i < servermanagers.length) {
            Object[] servermanager = (Object[])servermanagers[i];
            String smip = (String)servermanager[0];
            int smport = (Integer)servermanager[1];
            ExtResponse response = this.invoke(request, smip, smport);
            if (response.getErrorCode() < 0) {
                ErrorMessage error = (ErrorMessage)response.getData();
                throw new IRException(2, "Cannot add server[Group=" + group + " ID=" + id + "]. " + error.getErrorMessage());
            }
            ++i;
        }
    }

    public void remove(int group, int id) throws IRException {
        WDReqRemoveServerT wdReq = new WDReqRemoveServerT(group, id);
        ExtRequest request = new ExtRequest("com.diquest.ir.mgr.msg.WDMessageRemoveServer", (Transmitable)wdReq);
        Object[] servermanagers = this.properties.getServerManagers();
        int i = 0;
        while (i < servermanagers.length) {
            Object[] servermanager = (Object[])servermanagers[i];
            String smip = (String)servermanager[0];
            int smport = (Integer)servermanager[1];
            ExtResponse response = this.invoke(request, smip, smport);
            if (response.getErrorCode() < 0) {
                ErrorMessage error = (ErrorMessage)response.getData();
                throw new IRException(2, "Cannot remove server[Group=" + group + " ID=" + id + "]. " + error.getErrorMessage());
            }
            ++i;
        }
    }
}

