/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command;

import com.diquest.ir.client.network.ExternalClientWorker;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.common.msg.ext.body.common.ServerKey;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;

public class ServerManagerClientWorker {
    private static final int SERVER_MANAGER = 3;
    private static final int SERVER_DIRECT = 5;
    private static final int SERVER_KEY = 7;
    private static final String ALIVE = "alive";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String RESTART = "restart";
    private static final String SHUTDOWN = "shutdown";
    private static final String SHUTDOWN_FORCE = "shutdown_force";
    private static final String[] commands = new String[]{"alive", "start", "stop", "restart", "shutdown", "shutdown_force"};
    private static final int[] parameters = new int[]{5, 7, 7, 7, 3, 3};
    private String serverManagerIP;
    private int serverManagerPort;

    public ServerManagerClientWorker(String serverManagerIP, int serverManagerPort) {
        this.serverManagerIP = serverManagerIP;
        this.serverManagerPort = serverManagerPort;
    }

    public static void main(String[] args) throws IRException {
        String cmd = "";
        String serverManagerIp = "";
        int serverManagerPort = 0;
        String serverIp = "";
        int serverPort = 0;
        char serverGroup = '\u0000';
        int serverId = 0;
        if (args.length < 1) {
            System.out.println("Specify command.");
            System.exit(-1);
        }
        cmd = args[0];
        int numArguments = -1;
        int c = 0;
        while (c < commands.length) {
            if (commands[c].equalsIgnoreCase(cmd)) {
                numArguments = parameters[c];
            }
            ++c;
        }
        if (numArguments == -1) {
            System.out.println("Unknown command [" + cmd + "]");
            System.exit(-1);
        } else if (args.length < numArguments) {
            System.out.println("Not enough arguments [" + args.length + "]");
            System.exit(-1);
        }
        switch (numArguments) {
            case 7: {
                serverGroup = args[5].toUpperCase().charAt(0);
                if (args[5].length() != 1 || serverGroup != 'A' && serverGroup != 'S' && serverGroup != 'B') {
                    System.out.println("Illegal Server Group [" + args[5] + "]");
                    System.exit(-1);
                }
                try {
                    serverId = Integer.parseInt(args[6]);
                }
                catch (NumberFormatException e) {
                    System.out.println("Illegal SERVER_ID [" + args[6] + "]");
                    System.exit(-1);
                }
            }
            case 5: {
                serverIp = args[3];
                try {
                    serverPort = Integer.parseInt(args[4]);
                }
                catch (NumberFormatException e) {
                    System.out.println("Illegal SERVER_PORT [" + args[4] + "]");
                    System.exit(-1);
                }
            }
            case 3: {
                serverManagerIp = args[1];
                try {
                    serverManagerPort = Integer.parseInt(args[2]);
                    break;
                }
                catch (NumberFormatException e) {
                    System.out.println("Illegal SERVERMANAGER_PORT [" + args[2] + "]");
                    System.exit(-1);
                }
            }
        }
        ServerManagerClientWorker.dispatch(cmd, serverManagerIp, serverManagerPort, serverIp, serverPort, serverGroup, serverId);
    }

    private static boolean dispatch(String cmd, String serverManagerIp, int serverManagerPort, String serverIp, int serverPort, int serverGroup, int serverId) throws IRException {
        ServerManagerClientWorker client = new ServerManagerClientWorker(serverManagerIp, serverManagerPort);
        if (cmd.equalsIgnoreCase(ALIVE)) {
            boolean alive = client.isAlive(serverIp, serverPort);
            System.out.println("Server IP[" + serverIp + "] PORT[" + serverPort + "] is " + (alive ? "" : "not ") + "alive.");
        } else if (cmd.equalsIgnoreCase(START)) {
            client.start(serverGroup, serverId);
            System.out.println("Server started.");
        } else if (cmd.equalsIgnoreCase(STOP)) {
            client.stop(serverGroup, serverId);
            System.out.println("Server stopped.");
        } else if (cmd.equalsIgnoreCase(RESTART)) {
            client.stop(serverGroup, serverId);
            client.start(serverGroup, serverId);
            System.out.println("Server restarted.");
        } else if (cmd.equalsIgnoreCase(SHUTDOWN)) {
            client.shutdown(false);
            System.out.println("ServerManager shutdown.");
        } else if (cmd.equalsIgnoreCase(SHUTDOWN_FORCE)) {
            client.shutdown(true);
            System.out.println("ServerManager shutdown.");
        } else {
            return false;
        }
        return true;
    }

    public void start(int group, int id) throws IRException {
        ServerKey body = new ServerKey(group, id);
        ExtRequest request = new ExtRequest("com.diquest.ir.mgr.msg.WDMessageStartServer", (Transmitable)body);
        ExtResponse response = null;
        try {
            System.out.print("Server GROUP[" + (char)group + "] ID[" + id + "] Starting...");
            response = this.invoke(request, this.serverManagerIP, this.serverManagerPort);
            System.out.println("Started.");
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot start server[Group=" + group + " ID=" + id + "]. " + "An Exception is occurred during sending message to ServerManager[ip:" + this.serverManagerIP + ",port:" + this.serverManagerPort + "]", (Throwable)e);
        }
        if (response.getErrorCode() < 0) {
            ErrorMessage error = (ErrorMessage)response.getData();
            throw new IRException(2, "Cannot start server[Group=" + group + " ID=" + id + "]. " + error.getErrorMessage());
        }
    }

    public void stop(int group, int id) throws IRException {
        ServerKey body = new ServerKey(group, id);
        ExtRequest request = new ExtRequest("com.diquest.ir.mgr.msg.WDMessageStopServer", (Transmitable)body);
        ExtResponse response = null;
        try {
            System.out.print("Server GROUP[" + (char)group + "] ID[" + id + "] Stopping...");
            response = this.invoke(request, this.serverManagerIP, this.serverManagerPort);
            System.out.println("Stopped.");
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot stop server[Group=" + group + " ID=" + id + "]. " + "An Exception is occurred during sending message to ServerManager[ip:" + this.serverManagerIP + ",port:" + this.serverManagerPort + "]", (Throwable)e);
        }
        if (response.getErrorCode() < 0) {
            ErrorMessage error = (ErrorMessage)response.getData();
            throw new IRException(2, "Cannot stop server[Group=" + group + " ID=" + id + "]. " + error.getErrorMessage());
        }
    }

    public void shutdown(boolean force) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.mgr.msg.WDMessageShutdown", (Transmitable)new BooleanT(force));
        ExtResponse response = null;
        try {
            System.out.print("ServerManager Shutdown...");
            response = this.invoke(request, this.serverManagerIP, this.serverManagerPort);
            System.out.println("Shutdown command is sent successfully.");
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot shutdown. An Exception is occurred during sending message to ServerManager[ip:" + this.serverManagerIP + ",port:" + this.serverManagerPort + "]", (Throwable)e);
        }
        if (response.getErrorCode() < 0) {
            ErrorMessage error = (ErrorMessage)response.getData();
            throw new IRException(2, "Cannot shutdown ServerManager. " + error.getErrorMessage());
        }
    }

    public boolean isAlive(String ip, int port) {
        ExtRequest checkAlive = new ExtRequest("com.diquest.ir.server.msg.management.system.ExtMessageAlive");
        boolean isAlive = false;
        try {
            System.out.print("Connect to server...");
            ExtResponse response = this.invoke(checkAlive, ip, port);
            if (response.getErrorCode() > 0) {
                isAlive = true;
            }
        }
        catch (Exception e) {
            isAlive = false;
        }
        return isAlive;
    }

    private ExtResponse invoke(ExtRequest request, String ip, int port) throws IRException {
        ExternalClientWorker worker = new ExternalClientWorker(ip, port);
        ExtResponse response = null;
        try {
            response = worker.invoke(request);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot send message to ServerManager[ip:" + this.serverManagerIP + ",port:" + this.serverManagerPort + "]", (Throwable)e);
        }
        return response;
    }
}

