/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.collection;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.database.entity.CollectionAuthority;
import com.diquest.ir.common.database.entity.CollectionAuthoritySet;
import com.diquest.ir.common.database.handler.AuthorityDB;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ProfileKey;
import com.diquest.ir.common.msg.ext.body.collection.ReqCopyCollection;
import com.diquest.ir.common.msg.ext.body.collection.ReqGetSingleCollection;
import com.diquest.ir.common.msg.ext.body.collection.ReqRemoveCollection;
import com.diquest.ir.common.msg.ext.body.collection.ResGetAllCollections;
import com.diquest.ir.common.msg.ext.body.collection.ResGetSingleCollection;
import com.diquest.ir.common.msg.ext.body.setting.ResApplySettingT;
import com.diquest.ir.common.setting.collection.CollectionSetting;
import com.diquest.ir.common.setting.collection.IndexSetting;
import com.diquest.ir.common.setting.manager.SingleCollectionSettingManager;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.StringT;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CommandCollection {
    private final String userid;
    private final AdminServerClient client;
    private Map exceptions = Collections.EMPTY_MAP;

    public CommandCollection(String ip, int port, String userid) {
        this.client = new AdminServerClient(ip, port);
        this.userid = userid;
    }

    public CommandCollection(AdminServerClient client, String userid) {
        this.client = client;
        this.userid = userid;
    }

    public String[] getAllCollectionNames() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageAllCollection");
        ExtResponse response = this.client.invoke(request);
        ResGetAllCollections responseData = (ResGetAllCollections)response.getData();
        return responseData.getAllCollectionNames();
    }

    public CollectionSetting[] getAllCollections() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageAllCollection");
        ExtResponse response = this.client.invoke(request);
        ResGetAllCollections responseData = (ResGetAllCollections)response.getData();
        return responseData.getAllCollectionList();
    }

    public CollectionSetting getCollection(String collectionID) throws IRException {
        ReqGetSingleCollection requestData = new ReqGetSingleCollection(collectionID);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageGetCollection", (Transmitable)requestData);
        ExtResponse response = this.client.invoke(request);
        ResGetSingleCollection responseData = (ResGetSingleCollection)response.getData();
        return responseData.getCollection();
    }

    public String[] getIndexFieldList(String collectionID) throws IRException {
        CollectionSetting cs = this.getCollection(collectionID);
        List indexSettings = cs.getIndexSetting();
        String[] indexFields = new String[indexSettings.size()];
        int i = 0;
        while (i < indexFields.length) {
            indexFields[i] = ((IndexSetting)indexSettings.get(i)).getId();
            ++i;
        }
        return indexFields;
    }

    public boolean addCollection(String id, String description, String server, boolean useDBWatcher) throws IRException {
        ExtResponse response;
        block3: {
            try {
                SingleCollectionSettingManager collectionSetting = SingleCollectionSettingManager.create();
                collectionSetting.frame(id, description, server, useDBWatcher);
                ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageAddCollection", (Transmitable)collectionSetting);
                response = this.client.invoke(request);
                if (response != null) break block3;
                return false;
            }
            catch (IRException e) {
                throw new IRException(2, "An Exception is occurred during modifying setting.", ProfileKey.getKey((String)id), (Throwable)e);
            }
        }
        return response.getErrorCode() >= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addAndApplyCollection(SingleCollectionSettingManager collectionSetting) throws IRException {
        boolean success = false;
        String collectionID = collectionSetting.getCollectionSetting().getId();
        try {
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageAddCollection", (Transmitable)collectionSetting);
            ExtResponse response = this.client.invoke(request);
            if (response == null) {
                success = false;
            }
            if (response.getErrorCode() < 0) return false;
            success = true;
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred during modifying setting.", ProfileKey.getKey((String)collectionID), (Throwable)e);
        }
        if (!success) return success;
        success = this.applyModifyCollection(collectionID);
        if (!success) return success;
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                AuthorityDB authDB = new AuthorityDB();
                String loginUserId = "super";
                CollectionAuthoritySet cAuthSet = authDB.getCollectionAuthority(conn, loginUserId);
                CollectionAuthority cAuth = cAuthSet.getCollectionAuthority(collectionID);
                if (cAuth != null) return success;
                cAuth = new CollectionAuthority(collectionID, 'W');
                cAuth.addProfileAuthority("Default", 'W');
                cAuthSet.addCollectionAuthority(cAuth);
                authDB.updateCollectionAuth(conn, loginUserId, cAuthSet);
                return success;
            }
            catch (SQLException e) {
                success = false;
                System.out.println("[CommandCollection][WARN] add and apply collection : An Exception is occurred during modifying setting.");
                if (conn == null) return success;
                ConnectionFactory.release((Connection)conn);
                return success;
            }
            catch (IOException e) {
                success = false;
                System.out.println("[CommandCollection][WARN] add and apply collection : An Exception is occurred during modifying setting.");
                if (conn == null) return success;
                ConnectionFactory.release((Connection)conn);
                return success;
            }
        }
        finally {
            if (conn != null) {
                ConnectionFactory.release((Connection)conn);
            }
        }
    }

    public boolean modifyCollection(CollectionSetting original, String description, String server, boolean useDBWatcher) throws IRException {
        try {
            original.setDescription(description);
            original.setUseDBWatcher(useDBWatcher);
            SingleCollectionSettingManager collectionSettingMgr = SingleCollectionSettingManager.readFromObject((Object)original);
            return this.modifyCollection(collectionSettingMgr);
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred during modifying setting.", ProfileKey.getKey((String)original.getId()), (Throwable)e);
        }
    }

    public boolean modifyCollection(CollectionSetting collectionSetting) throws IRException {
        try {
            return this.modifyCollection(SingleCollectionSettingManager.readFromObject((Object)collectionSetting));
        }
        catch (IRException e) {
            throw new IRException(2, "An Exception is occurred during modifying setting.", ProfileKey.getKey((String)collectionSetting.getId()), (Throwable)e);
        }
    }

    public boolean modifyCollection(SingleCollectionSettingManager collectionSettingManager) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageModifyCollection", (Transmitable)collectionSettingManager);
        ExtResponse response = this.client.invoke(request);
        if (response == null) {
            return false;
        }
        return response.getErrorCode() >= 0;
    }

    public boolean removeCollection(String id) throws IRException {
        ReqRemoveCollection reqData = new ReqRemoveCollection(id);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageRemoveCollection", (Transmitable)reqData);
        ExtResponse response = this.client.invoke(request);
        if (response == null) {
            return false;
        }
        return response.getErrorCode() >= 0;
    }

    public boolean applyRemoveCollection(String id) throws IRException {
        this.exceptions = Collections.EMPTY_MAP;
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageApplyRemoveCollection", (Transmitable)new StringT(id));
        ExtResponse response = this.client.invoke(request);
        if (response == null || response.getErrorCode() < 0 || response.getData() == null) {
            return false;
        }
        ResApplySettingT data = (ResApplySettingT)response.getData();
        this.exceptions = data.getExceptions();
        return data.isSuccess();
    }

    public boolean applyModifyCollection(String id) throws IRException {
        this.exceptions = Collections.EMPTY_MAP;
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageApplyModifyCollection", (Transmitable)new StringT(id));
        ExtResponse response = this.client.invoke(request);
        if (response == null || response.getErrorCode() < 0 || response.getData() == null) {
            return false;
        }
        ResApplySettingT data = (ResApplySettingT)response.getData();
        this.exceptions = data.getExceptions();
        return data.isSuccess();
    }

    public boolean copyCollection(String source, String dest, String description, boolean useCollection, boolean useProfile, boolean useDBWatcher) throws IRException {
        ExtResponse response;
        block3: {
            try {
                ReqCopyCollection message = new ReqCopyCollection(source, dest.toUpperCase(), description, useCollection, useProfile, useDBWatcher);
                ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.ExtMessageCopyCollection", (Transmitable)message);
                response = this.client.invoke(request);
                if (response != null) break block3;
                return false;
            }
            catch (IRException e) {
                throw new IRException(2, "An Exception is occurred during coping setting.", ProfileKey.getKey((String)source), (Throwable)e);
            }
        }
        return response.getErrorCode() >= 0;
    }

    public Map getExceptions() {
        return this.exceptions;
    }
}

