/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.collection;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.database.entity.CollectionMonitor;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.ArrayT;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.StringT;

public class CommandCollectionMonitor {
    private final String userid;
    private final AdminServerClient client;

    public CommandCollectionMonitor(AdminServerClient client, String userid) {
        this.client = client;
        this.userid = userid;
    }

    public CollectionMonitor getCollectionMonitor(String collectionID) throws IRException {
        StringT requestData = new StringT(collectionID);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.status.ExtMessageGetCollectionMonitor", (Transmitable)requestData);
        ExtResponse response = this.client.invoke(request);
        CollectionMonitor responseData = (CollectionMonitor)response.getData();
        return responseData;
    }

    public boolean modifyCollectionMonitor(CollectionMonitor monitor) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.status.ExtMessageModifyCollectionMonitor", (Transmitable)monitor);
        ExtResponse response = this.client.invoke(request);
        BooleanT responseData = (BooleanT)response.getData();
        return responseData.value;
    }

    public CollectionMonitor get(String collectionID) throws IRException {
        return this.getCollectionMonitor(collectionID);
    }

    public boolean modify(CollectionMonitor monitor) throws IRException {
        return this.modifyCollectionMonitor(monitor);
    }

    public char getCollectionStatus(String collectionID) throws IRException {
        CollectionMonitor response = this.getCollectionMonitor(collectionID);
        return response.getCollectionStatus();
    }

    public CollectionMonitor[] getAllCollectionMonitors() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.status.ExtMessageGetAllCollectionMonitors");
        ExtResponse response = this.client.invoke(request);
        ArrayT responseArray = (ArrayT)response.getData();
        Transmitable[] tr = responseArray.value;
        CollectionMonitor[] responseData = new CollectionMonitor[tr.length];
        int i = 0;
        while (i < tr.length) {
            responseData[i] = (CollectionMonitor)tr[i];
            ++i;
        }
        return responseData;
    }

    public boolean isAllStoped() throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.status.ExtMessageGetIndexingAllStopStatus");
        ExtResponse response = this.client.invoke(request);
        BooleanT responseData = (BooleanT)response.getData();
        return responseData.value;
    }

    public boolean setAllIndexingStop(boolean set) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.status.ExtMessageSetIndexingAllStopStatus", (Transmitable)new BooleanT(set));
        ExtResponse response = this.client.invoke(request);
        BooleanT responseData = (BooleanT)response.getData();
        return responseData.value;
    }
}

