/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.dictionary;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.client.command.dictionary.CommandDictionary;
import com.diquest.ir.client.util.JobDescription;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;

public class CommandBannedWord
extends CommandDictionary {
    public static final String ANY_COLLECTION = "";
    public static final String ANY_PROFILE = "";
    private static final String KEY_DELIMITER = ",";

    public CommandBannedWord(AdminServerClient client, String userid) {
        super(client, userid);
    }

    public boolean applyImpl(String collectionID, String profileID, String profileKey) throws IRException {
        JobDescription description = new JobDescription("applying BannedWord Dictionary " + profileKey);
        DataT data = new DataT(2);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.bannedword.ExtMessageJobApplyBannedWord", (Transmitable)data);
        return this.client.registerJob(request, description, this.userid);
    }

    public String[] getSystemBannedWord(String key) throws IRException {
        String result = this.getBannedWord(key, "", "", true);
        return result.split(KEY_DELIMITER);
    }

    public String[] getSystemBannedWord(String key, String collectionID) throws IRException {
        String result = this.getBannedWord(key, collectionID, "", true);
        return result.split(KEY_DELIMITER);
    }

    public String getBannedWord(String key) throws IRException {
        return this.getBannedWord(key, "", "", false);
    }

    public String getBannedWord(String key, String collectionID) throws IRException {
        return this.getBannedWord(key, collectionID, "", false);
    }

    public String getBannedWord(String key, String collectionID, boolean isSystem) throws IRException {
        return this.getBannedWord(key, collectionID, "", isSystem);
    }

    public String getBannedWord(String key, String collectionID, String profileID, boolean isSystem) throws IRException {
        DataT data = new DataT(5);
        data.put("key", (Transmitable)new StringT(key));
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID != null ? profileID : ""));
        data.put("isSystem", (Transmitable)new BooleanT(isSystem));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.bannedword.ExtMessageBannedWord", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        DataT dataT = (DataT)response.getData();
        StringT bannedWords = (StringT)dataT.get("bannedWord");
        return bannedWords.value;
    }
}

