/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.dictionary;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.client.util.JobDescription;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.type.ArrayT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;

public class CommandCollectionCategory {
    private AdminServerClient client;
    private String userId;

    public CommandCollectionCategory(String ip, int port, String userId) {
        this.client = new AdminServerClient(ip, port);
        this.userId = userId;
    }

    public CommandCollectionCategory(AdminServerClient client, String userId) {
        this.client = client;
        this.userId = userId;
    }

    public boolean regist(String collectionID, String[] fields) throws IRException {
        JobDescription description = new JobDescription("Update CollectionCategory : " + collectionID);
        DataT data = new DataT(2);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        StringT[] fieldT = new StringT[fields.length];
        int i = 0;
        while (i < fields.length) {
            fieldT[i] = new StringT(fields[i]);
            ++i;
        }
        data.put("fields", (Transmitable)new ArrayT((Transmitable[])fieldT));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.categoryranking.ExtMessageCollectionCategoryUpdate", (Transmitable)data);
        return this.client.registerJob(request, description, this.userId);
    }

    public boolean registFields(String settingName, String collectionID, String[] fields) throws IRException {
        DataT data = new DataT(1);
        data.put("name", (Transmitable)new StringT(settingName));
        String fieldSeq = "";
        int i = 0;
        while (i < fields.length) {
            fieldSeq = String.valueOf(fieldSeq) + fields[i];
            if (i < fields.length - 1) {
                fieldSeq = String.valueOf(fieldSeq) + ", ";
            }
            ++i;
        }
        JobDescription description = new JobDescription("Update CollectionCategory Fields: " + collectionID + ", " + fieldSeq);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.categoryranking.ExtMessageCollectionCategoryUpdateFields", (Transmitable)data);
        return this.client.registerJob(request, description, this.userId);
    }

    public static void main(String[] args) throws IRException {
        if (args.length < 4) {
            StringBuffer help = new StringBuffer();
            help.append("CommandCollecitonCategory : update CollectionCategory tables from running collection.\n");
            help.append("[IP] [Port] [CollectionID] [field1] [field2] ...)\n\n");
            help.append("IP : Destination server IP address\n");
            help.append("Port : Destination server port number\n");
            help.append("CollectionID : ID of collection to index\n");
            help.append("field : update field");
            System.out.println(help);
            System.exit(args.length);
        }
        String ip = args[0].trim();
        int port = Integer.parseInt(args[1].trim());
        String collectionID = args[2].trim();
        String[] fields = new String[args.length - 3];
        System.arraycopy(args, 3, fields, 0, fields.length);
        CommandCollectionCategory command = new CommandCollectionCategory(ip, port, "test");
        boolean success = command.regist(collectionID, fields);
        System.out.println(success);
    }
}

