/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.dictionary;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.client.command.dictionary.CommandDictionary;
import com.diquest.ir.client.util.JobDescription;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;

public class CommandRecommend
extends CommandDictionary {
    public static final String ANY_COLLECTION = "";
    public static final String ANY_PROFILE = "";
    private static final String RECOMMEND_DELIMITER = "\t";
    private static final String NEWLINE = "\n";

    public CommandRecommend(AdminServerClient client, String userid) {
        super(client, userid);
    }

    public boolean applyImpl(String collectionID, String profileID, String profileKey) throws IRException {
        JobDescription description = new JobDescription("applying Recommend Dictionary " + profileKey);
        DataT data = new DataT(2);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.recommend.ExtMessageJobApplyRecommend", (Transmitable)data);
        return this.client.registerJob(request, description, this.userid);
    }

    public String getSystemRecommend(String key) throws IRException {
        return this.getRecommend(key, "", "", true);
    }

    public String[] getSystemRecommend(String key, String collectionID) throws IRException {
        String result = this.getRecommend(key, collectionID, "", true);
        String[] synonyms = result.split(NEWLINE);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < synonyms.length) {
            buffer.append(synonyms[i]);
            buffer.append(RECOMMEND_DELIMITER);
            ++i;
        }
        return buffer.toString().split(RECOMMEND_DELIMITER);
    }

    public String getRecommend(String key) throws IRException {
        return this.getRecommend(key, "", "", false);
    }

    public String getRecommend(String key, String collectionID) throws IRException {
        return this.getRecommend(key, collectionID, "", false);
    }

    public String getRecommend(String key, String collectionID, String profileID) throws IRException {
        return this.getRecommend(key, collectionID, profileID, false);
    }

    public String getRecommend(String key, String collectionID, String profileID, boolean isSystem) throws IRException {
        DataT data = new DataT(4);
        data.put("key", (Transmitable)new StringT(key));
        data.put("collectionID", (Transmitable)new StringT(collectionID != null ? collectionID : ""));
        data.put("profileID", (Transmitable)new StringT(profileID != null ? profileID : ""));
        data.put("isSystem", (Transmitable)new BooleanT(isSystem));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.recommend.ExtMessageRecommend", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        DataT dataT = (DataT)response.getData();
        StringT recommends = (StringT)dataT.get("recommend");
        return recommends.value;
    }
}

