/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.dictionary;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.client.command.dictionary.CommandDictionary;
import com.diquest.ir.client.util.JobDescription;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;

public class CommandRedirect
extends CommandDictionary {
    public static final String ANY_COLLECTION = "";
    public static final String ANY_PROFILE = "";

    public CommandRedirect(AdminServerClient client, String userid) {
        super(client, userid);
    }

    public boolean applyImpl(String collectionID, String profileID, String profileKey) throws IRException {
        JobDescription description = new JobDescription("applying Redirect Dictionary " + profileKey);
        DataT data = new DataT(3);
        boolean isSystem = false;
        if (StringUtil.isEmpty((String)collectionID)) {
            isSystem = true;
        }
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID));
        data.put("isSystem", (Transmitable)new BooleanT(isSystem));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.redirect.ExtMessageJobApplyRedirect", (Transmitable)data);
        return this.client.registerJob(request, description, this.userid);
    }

    public String getSystemRedirect(String key) throws IRException {
        return this.getRedirect(key, "", "", true);
    }

    public String getSystemRedirect(String key, String collectionID) throws IRException {
        return this.getRedirect(key, collectionID, "", true);
    }

    public String getRedirect(String key) throws IRException {
        return this.getRedirect(key, "", "", false);
    }

    public String getRedirect(String key, String collectionID) throws IRException {
        return this.getRedirect(key, collectionID, "", false);
    }

    public String getRedirect(String key, String collectionID, String profileID) throws IRException {
        return this.getRedirect(key, collectionID, profileID, false);
    }

    public String getRedirect(String key, String collectionID, String profileID, boolean isSystem) throws IRException {
        DataT data = new DataT(5);
        data.put("key", (Transmitable)new StringT(key));
        data.put("collectionID", (Transmitable)new StringT(collectionID != null ? collectionID : ""));
        data.put("profileID", (Transmitable)new StringT(profileID != null ? profileID : ""));
        data.put("isSystem", (Transmitable)new BooleanT(isSystem));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.redirect.ExtMessageRedirect", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        DataT dataT = (DataT)response.getData();
        StringT redirects = (StringT)dataT.get("redirects");
        return redirects.value;
    }
}

