/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.dictionary;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.client.util.JobDescription;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.dictionary.DictionaryType;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.IntegerT;
import com.diquest.ir.util.msg.type.StringT;

public class CommandReloadDictionary {
    final String EMPTY = "";
    private String userID;
    private AdminServerClient client;

    public CommandReloadDictionary(String ip, int port, String userID) {
        this.client = new AdminServerClient(ip, port);
        this.userID = userID;
    }

    public CommandReloadDictionary(AdminServerClient client, String userID) {
        this.client = client;
        this.userID = userID;
    }

    protected String getNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public boolean reload(boolean isSystem, String collectionID, String profileID, int dicType) throws IRException {
        collectionID = this.getNull(collectionID);
        profileID = this.getNull(profileID);
        String dictionaryKey = null;
        dictionaryKey = StringUtil.isEmpty((String)collectionID) ? "[System]" : (StringUtil.isEmpty((String)profileID) ? "[Collection : " + collectionID + "(default profile)]" : "[Collection : " + collectionID + "] [Profile : " + profileID + "]");
        if (dicType >= DictionaryType.dicNames.length) {
            System.out.println("Illegal DictionaryType : " + dicType);
            return false;
        }
        String system = isSystem ? "(System)" : "";
        dictionaryKey = String.valueOf(DictionaryType.dicNames[dicType]) + system + dictionaryKey;
        System.out.println("Reload Dictionary " + dictionaryKey);
        JobDescription description = new JobDescription("Reload Dictionary " + dictionaryKey);
        DataT data = new DataT(4);
        data.put("isSystem", (Transmitable)new BooleanT(isSystem));
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID));
        data.put("type", (Transmitable)new IntegerT(dicType));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.reload.ExtMessageReloadDic", (Transmitable)data);
        return this.client.registerJob(request, description, this.userID);
    }

    public static void main(String[] args) throws IRException {
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String userID = args[2];
        boolean isSystem = args[3].trim().equalsIgnoreCase("TRUE");
        System.out.println("isSystem = " + isSystem);
        int dicType = Integer.parseInt(args[4]);
        String collectionID = args.length >= 6 ? args[5] : null;
        String profileID = args.length >= 7 ? args[6] : null;
        CommandReloadDictionary command = new CommandReloadDictionary(ip, port, userID);
        boolean registered = command.reload(isSystem, collectionID, profileID, dicType);
        if (registered) {
            System.out.println("Register Reload message finished. (see log for detail.)");
        } else {
            System.out.println("Register Reload message failed. (see log for detail.)");
        }
    }
}

